/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.SequenceExpressionCompiler;
import java.util.HashSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.functions.DistinctValues;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.AtomicValue;

public class DistinctValuesCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        String compVar;
        DistinctValues exp = (DistinctValues)expr;
        int n = compiler.getUniqueNumber();
        String resultVar = "distinct" + n;
        AtomicComparer comparer = exp.getAtomicComparer();
        if (comparer != null) {
            compVar = compiler.compileAtomicComparer(comparer);
        } else {
            String collVar = compiler.compileStringCollator((CollatingFunction)exp, 1);
            compVar = "comparer" + n;
            compiler.declare(GenericAtomicComparer.class, compVar, "new GenericAtomicComparer(" + collVar + ", " + compiler.getContextVariableName() + ")", true);
        }
        Expression input = exp.getArguments()[0];
        String inVar = compiler.compileToIterator(input);
        compiler.declare(SequenceIterator.class, resultVar, "new DistinctValues.DistinctIterator(" + inVar + ", " + compVar + ")", true);
        return resultVar;
    }

    public void compileAsLoop(CompilerService compiler, Expression expr, final LoopAction action) {
        String compVar;
        DistinctValues exp = (DistinctValues)expr;
        int n = compiler.getUniqueNumber();
        AtomicComparer comparer = exp.getAtomicComparer();
        if (comparer != null) {
            compVar = compiler.compileAtomicComparer(comparer);
        } else {
            String collVar = compiler.compileStringCollator((CollatingFunction)exp, 1);
            compVar = "comparer" + n;
            compiler.declare(GenericAtomicComparer.class, compVar, "new GenericAtomicComparer(" + collVar + ", " + compiler.getContextVariableName() + ")", true);
        }
        final String setVar = "distinctSet" + n;
        final String compVar2 = compVar;
        compiler.declare(HashSet.class, setVar, "new HashSet(100)", true);
        LoopAction inner = new LoopAction(){

            public void compileAction(CompilerService compiler, String itemVar) {
                compiler.emit("if (" + setVar + ".add(" + compVar2 + ".getComparisonKey(" + compiler.cast(itemVar, AtomicValue.class) + "))) {");
                action.compileAction(compiler, itemVar);
                compiler.emit("}");
            }
        };
        compiler.compileAsLoop(exp.getArguments()[0], inner);
    }
}

