/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ComputedElementCompiler;
import com.saxonica.codegen.PushExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.ComputedAttribute;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;

public class ComputedAttributeCompiler
extends PushExpressionCompiler {
    public void compilePush(CompilerService compiler, Expression expr) {
        ComputedAttribute exp = (ComputedAttribute)expr;
        int n = compiler.getUniqueNumber();
        compiler.emitComment("create computed attribute");
        Expression nameExp = exp.getNameExpression();
        Expression namespaceExp = exp.getNamespaceExpression();
        NamespaceResolver resolver = exp.getNamespaceResolver();
        String nameCodeVar = ComputedElementCompiler.compileComputedName(nameExp, namespaceExp, compiler, n, resolver, "attribute");
        Expression content = exp.getContentExpression();
        String stringVar = Literal.isAtomic((Expression)content) ? '\"' + ((AtomicValue)((Literal)content).getValue()).getStringValue() + '\"' : compiler.compileToCharSequence(content);
        SimpleType schemaType = exp.getSchemaType();
        if (schemaType != null) {
            ComputedAttributeCompiler.compileAttributeValidationCode(compiler, stringVar, (SchemaType)schemaType);
        }
        String annotationVar = ComputedAttributeCompiler.compileAnnotationCode(compiler, (SchemaType)schemaType);
        int properties = 0;
        compiler.emit(compiler.getOutputterVariableName() + ".attribute(" + nameCodeVar + ", " + annotationVar + ", " + stringVar + ", " + exp.getLocationId() + ", " + properties + ");");
    }

    protected static void compileAttributeValidationCode(CompilerService compiler, String stringVar, SchemaType schemaType) {
        int n = compiler.getUniqueNumber();
        String schemaTypeVar = compiler.compileSchemaType(schemaType);
        String errVar = "err" + n;
        compiler.declare(ValidationFailure.class, errVar, schemaTypeVar + ".validateContent(" + stringVar + ", net.sf.saxon.expr.instruct.DummyNamespaceResolver.getInstance(), " + compiler.getContextVariableName() + ".getConfiguration().getNameChecker())", true);
        compiler.emit("if (" + errVar + " != null) {");
        String veVar = "ve" + n;
        String msgExp = "\"Attribute value does not match the required type: \" + " + errVar + ".getMessage()";
        compiler.declare(ValidationException.class, veVar, "new ValidationException(" + msgExp + ")", true);
        compiler.emit(veVar + ".setErrorCode(\"XTTE1540\");");
        compiler.emit("throw " + veVar + ";");
        compiler.emit("}");
    }

    protected static String compileAnnotationCode(CompilerService compiler, SchemaType schemaType) {
        if (schemaType == null) {
            return "631";
        }
        if (schemaType.getFingerprint() < 1024) {
            return "" + schemaType.getFingerprint();
        }
        String typeVar = compiler.compileSchemaType(schemaType);
        return typeVar + ".getFingerprint()";
    }
}

