/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollatingComparer;
import net.sf.saxon.expr.sort.ComparableAtomicValueComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.functions.Compare;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;

public class CompareCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        String jexp;
        boolean conditional;
        Compare exp = (Compare)expr;
        Expression[] operands = exp.getArguments();
        TypeHierarchy th = compiler.getTypeHierarchy();
        String op0var = compiler.compileToItem(operands[0]);
        String op1var = compiler.compileToItem(operands[1]);
        int n = compiler.getUniqueNumber();
        String resultVar = "comp" + n;
        compiler.declare(Int64Value.class, resultVar, null, false);
        boolean bl = conditional = Cardinality.allowsZero((int)operands[0].getCardinality()) || Cardinality.allowsZero((int)operands[1].getCardinality());
        if (conditional) {
            compiler.emit("if (" + op0var + " == null || " + op1var + " == null) {");
            compiler.emit(resultVar + " = null;");
            compiler.emit("} else {");
        }
        BuiltInAtomicType type0 = (BuiltInAtomicType)operands[0].getItemType(th).getPrimitiveItemType();
        BuiltInAtomicType type1 = (BuiltInAtomicType)operands[1].getItemType(th).getPrimitiveItemType();
        StringCollator sc = exp.getStringCollator();
        if (sc != null) {
            AtomicComparer comparer = GenericAtomicComparer.makeAtomicComparer((BuiltInAtomicType)type0, (BuiltInAtomicType)type1, (StringCollator)sc, (XPathContext)compiler.getConfiguration().getConversionContext());
            if (comparer instanceof CodepointCollatingComparer) {
                jexp = "CodepointCollatingComparer.getInstance().compareAtomicValues(" + op0var + ", " + op1var + ")";
            } else if (comparer instanceof ComparableAtomicValueComparer) {
                String cast0 = compiler.cast(op0var, Comparable.class);
                String cast1 = compiler.cast(op1var, Comparable.class);
                jexp = cast0 + ".compareTo(" + cast1 + ")";
            } else {
                String compVar = compiler.compileAtomicComparer(comparer);
                String cast0 = compiler.cast(op0var, AtomicValue.class);
                String cast1 = compiler.cast(op1var, AtomicValue.class);
                jexp = compVar + ".compareAtomicValues(" + cast0 + ", " + cast1 + ")";
            }
        } else {
            String collationVar = compiler.compileStringCollator((CollatingFunction)exp, 2);
            String comparerVar = "comparer" + n;
            compiler.declare(GenericAtomicComparer.class, comparerVar, "new GenericAtomicComparer(" + collationVar + ", " + compiler.getContextVariableName() + ")", true);
            String cast0 = compiler.cast(op0var, AtomicValue.class);
            String cast1 = compiler.cast(op1var, AtomicValue.class);
            jexp = comparerVar + ".compareAtomicValues(" + cast0 + ", " + cast1 + ")";
        }
        compiler.assign(resultVar, "Int64Value.signum(" + jexp + ")");
        if (conditional) {
            compiler.emit("}");
        }
        return resultVar;
    }
}

