/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ExpressionCompiler;
import com.saxonica.codegen.JavaAssignment;
import com.saxonica.codegen.ReturnAction;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class ChooseCompiler
extends ExpressionCompiler {
    private void compileFramework(CompilerService compiler, Expression expr, ChooseAction action) {
        Choose exp = (Choose)expr;
        String v = "b" + compiler.getUniqueNumber();
        Expression[] conditions = exp.getConditions();
        Expression[] actions = exp.getActions();
        compiler.declare(Boolean.TYPE, v, null, false);
        int closers = 0;
        for (int c = 0; c < conditions.length; ++c) {
            String vbl;
            if (c == 0) {
                vbl = compiler.compileToEffectiveBooleanValue(conditions[0], new JavaAssignment(Boolean.TYPE, v));
                compiler.emit("if (" + vbl + ") {");
                ++closers;
            } else if (c == conditions.length - 1 && Literal.isConstantBoolean((Expression)conditions[c], (boolean)true)) {
                compiler.emit("} else {");
            } else if (Literal.isConstantBoolean((Expression)conditions[c], (boolean)true)) {
                compiler.emit("} else if (true) {");
            } else {
                compiler.emit("} else {");
                vbl = compiler.compileToEffectiveBooleanValue(conditions[c], new JavaAssignment(Boolean.TYPE, v));
                compiler.emit("if (" + vbl + ") {");
                ++closers;
            }
            action.act(actions[c]);
        }
        for (int i = 0; i < closers; ++i) {
            compiler.emit("}");
        }
    }

    public void compilePush(final CompilerService compiler, Expression expr) {
        ChooseAction pushAction = new ChooseAction(){

            public void act(Expression action) {
                compiler.compilePush(action);
            }
        };
        this.compileFramework(compiler, expr, pushAction);
    }

    public String compileToIterator(final CompilerService compiler, Expression expr) {
        int n = compiler.getUniqueNumber();
        final String vblout = "seq" + n;
        compiler.declare(SequenceIterator.class, vblout, "EmptyIterator.getInstance()", false);
        ChooseAction iterateAction = new ChooseAction(){

            public void act(Expression action) {
                String vthen = compiler.compileToIterator(action);
                compiler.assign(vblout, vthen);
            }
        };
        this.compileFramework(compiler, expr, iterateAction);
        return vblout;
    }

    public String compileToItem(final CompilerService compiler, Expression expr) {
        int n = compiler.getUniqueNumber();
        final String vblout = "item" + n;
        compiler.declare(Item.class, vblout, "null", false);
        ChooseAction itemAction = new ChooseAction(){

            public void act(Expression action) {
                String vthen = compiler.compileToItem(action);
                compiler.assign(vblout, vthen);
            }
        };
        this.compileFramework(compiler, expr, itemAction);
        return vblout;
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction options) {
        ItemType type;
        TypeHierarchy th = compiler.getTypeHierarchy();
        if (th.isSubType(type = expr.getItemType(th), (ItemType)BuiltInAtomicType.BOOLEAN)) {
            String var = compiler.compileToItem(expr);
            String jexp = compiler.cast(var, BooleanValue.class) + ".getBooleanValue()";
            if (Cardinality.allowsZero((int)expr.getCardinality())) {
                jexp = "(" + var + "==null ? false : " + jexp + ")";
            }
            compiler.emit(options.output(compiler, jexp));
        } else if (th.isSubType(type, (ItemType)BuiltInAtomicType.NUMERIC)) {
            String var = compiler.compileToItem(expr);
            String jexp = compiler.cast(var, NumericValue.class) + ".effectiveBooleanValue()";
            if (Cardinality.allowsZero((int)expr.getCardinality())) {
                jexp = "(" + var + "==null ? false : " + jexp + ")";
            }
            compiler.emit(options.output(compiler, jexp));
        } else if (th.isSubType(type, (ItemType)BuiltInAtomicType.STRING) || th.isSubType(type, (ItemType)BuiltInAtomicType.ANY_URI) || th.isSubType(type, (ItemType)BuiltInAtomicType.UNTYPED_ATOMIC)) {
            String var = compiler.compileToItem(expr);
            String jexp = compiler.cast(var, StringValue.class) + ".getStringValueCS().length() > 0";
            if (Cardinality.allowsZero((int)expr.getCardinality())) {
                jexp = "(" + var + "==null ? false : " + jexp + ")";
            }
            compiler.emit(options.output(compiler, jexp));
        } else {
            String iterVar = this.compileToIterator(compiler, expr);
            compiler.emit(options.output(compiler, "ExpressionTool.effectiveBooleanValue(" + iterVar + ");"));
        }
        return options.getVariableName();
    }

    public String compileToCharSequence(final CompilerService compiler, Expression expr) {
        final String vblout = "chars" + compiler.getUniqueNumber();
        compiler.declare(CharSequence.class, vblout, "null", false);
        ChooseAction itemAction = new ChooseAction(){

            public void act(Expression action) {
                String vthen = compiler.compileToCharSequence(action);
                compiler.assign(vblout, vthen);
            }
        };
        this.compileFramework(compiler, expr, itemAction);
        return vblout;
    }

    private static interface ChooseAction {
        public void act(Expression var1);
    }
}

