/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.JavaAssignment;
import com.saxonica.codegen.JavaDeclaration;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ToBooleanCompiler;
import net.sf.saxon.expr.CastableExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;

public class CastableExpressionCompiler
extends ToBooleanCompiler {
    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction options) {
        CastableExpression exp = (CastableExpression)expr;
        Expression operand = exp.getBaseExpression();
        TypeHierarchy th = compiler.getTypeHierarchy();
        final int n = compiler.getUniqueNumber();
        ItemType inputType = operand.getItemType(th);
        final AtomicType targetType = exp.getTargetType();
        final boolean inputIsAtomic = th.isSubType(inputType, (ItemType)BuiltInAtomicType.ANY_ATOMIC);
        final boolean inputIsNode = th.isSubType(inputType, (ItemType)AnyNodeTest.getInstance());
        final int card = operand.getCardinality();
        ReturnAction options2 = options;
        if (options2 instanceof JavaDeclaration) {
            String tempVar = "castable" + compiler.getUniqueNumber();
            compiler.declare(Boolean.TYPE, tempVar, "true", false);
            options2 = new JavaAssignment(Boolean.TYPE, tempVar);
        }
        final ReturnAction options3 = options2;
        if (Cardinality.allowsMany((int)card) || !inputIsAtomic) {
            final String countVar = "count" + n;
            compiler.declare(Integer.TYPE, countVar, "0", false);
            LoopAction action = new LoopAction(){

                public void compileAction(CompilerService compiler, String itemVar) {
                    if (inputIsAtomic) {
                        CastableExpressionCompiler.this.compileAtomic(compiler, itemVar, card, countVar, options3, targetType);
                    } else if (inputIsNode) {
                        CastableExpressionCompiler.this.compileNode(compiler, itemVar, n, countVar, options3, targetType);
                    } else {
                        compiler.emit("if (" + itemVar + " instanceof AtomicValue) {");
                        CastableExpressionCompiler.this.compileAtomic(compiler, itemVar, card, countVar, options3, targetType);
                        compiler.emit("} else {");
                        CastableExpressionCompiler.this.compileNode(compiler, itemVar, n, countVar, options3, targetType);
                        compiler.emit("}");
                    }
                }
            };
            if (options instanceof JavaAssignment) {
                compiler.emit(options.output(compiler, "false"));
            }
            compiler.compileAsLoop(operand, action);
        } else {
            String itemVar = compiler.compileToItem(operand);
            this.compileAtomic(compiler, itemVar, card, null, options3, targetType);
        }
        if (options != options3) {
            compiler.emit(options.output(compiler, options3.getVariableName()));
        }
        return options.getVariableName();
    }

    private void compileNode(CompilerService compiler, String itemVar, int n, String countVar, ReturnAction options, AtomicType targetType) {
        String atomizedVar = "atomized" + n;
        compiler.declare(Value.class, atomizedVar, itemVar + ".atomize()", true);
        compiler.assign(countVar, countVar + "+" + atomizedVar + ".getLength()");
        compiler.emit("if (" + countVar + " > 1) {");
        compiler.emit(options.output(compiler, "false"));
        compiler.emit("break;");
        compiler.emit("} else if (" + countVar + " == 1) {");
        String resultExpr = "CastableExpression.isCastable((AtomicValue)" + atomizedVar + ".itemAt(0), " + compiler.compileItemType((ItemType)targetType) + ", " + compiler.getContextVariableName() + ")";
        compiler.emit(options.output(compiler, resultExpr));
        compiler.emit("}");
    }

    private void compileAtomic(CompilerService compiler, String itemVar, int card, String countVar, ReturnAction options, AtomicType targetType) {
        boolean close = false;
        if (card != 16384 && countVar != null) {
            compiler.assign(countVar, countVar + " + 1");
            if (Cardinality.allowsMany((int)card)) {
                compiler.emit("if (" + countVar + " > 1) {");
                compiler.emit(options.output(compiler, "false"));
                compiler.emit("} else {");
                close = true;
            }
        }
        String resultExpr = "CastableExpression.isCastable(" + compiler.cast(itemVar, AtomicValue.class) + ", " + compiler.compileItemType((ItemType)targetType) + ", " + compiler.getContextVariableName() + ")";
        compiler.emit(options.output(compiler, resultExpr));
        if (close) {
            compiler.emit("}");
        }
    }
}

