/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.Cardinality;

public class CardinalityCheckerCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        CardinalityChecker exp = (CardinalityChecker)expr;
        RoleLocator role = exp.getRoleLocator();
        int n = compiler.getUniqueNumber();
        String mfVar = "mf" + n;
        String countVar = "count" + n;
        String itemVar = "item" + n;
        String resultVar = "checked" + n;
        String baseVar = compiler.compileToIterator(exp.getBaseExpression());
        int card = exp.getRequiredCardinality();
        if (card == 16384) {
            compiler.declare(Item.class, itemVar, baseVar + ".next()", true);
            compiler.emit("if (" + itemVar + " == null) {");
            compiler.emitDynamicError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode());
            compiler.emit("}");
            compiler.emit("if (" + baseVar + ".next() != null) {");
            compiler.emitDynamicError("A sequence of more than one item is not allowed as the " + role.getMessage(), role.getErrorCode());
            compiler.emit("}");
            compiler.declare(SequenceIterator.class, resultVar, "SingletonIterator.makeIterator(" + itemVar + ")", true);
        } else {
            if (!Cardinality.allowsZero((int)card)) {
                String baseVarFinal = "base" + n;
                compiler.declare(SequenceIterator.class, baseVarFinal, baseVar, true);
                compiler.emit("SequenceIterator " + resultVar + " = new SequenceIterator() {    // check one-or-more");
                compiler.emit("private int position = 0;");
                compiler.emit("private Item current = null;");
                compiler.emit("public void close() {}");
                compiler.emit("public int getProperties() {return 0;}");
                compiler.emit("public int position() {return position;}");
                compiler.emit("public Item current() {return current;}");
                compiler.emit("public SequenceIterator getAnother() throws XPathException {return " + baseVarFinal + ".getAnother();}");
                compiler.emit("public Item next() throws XPathException {");
                compiler.emit("current = " + baseVarFinal + ".next();");
                compiler.emit("if (current == null) {");
                compiler.emit("if (position == 0) {");
                compiler.emitDynamicError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode());
                compiler.emit("} else {");
                compiler.emit("position = -1;");
                compiler.emit("return null;");
                compiler.emit("}");
                compiler.emit("}");
                compiler.emit("position++;");
                compiler.emit("return current;");
                compiler.emit("}");
                compiler.emit("};");
            }
            if (!Cardinality.allowsMany((int)card)) {
                compiler.emit("ItemMappingFunction " + mfVar + " = new ItemMappingFunction() {  // cardinality check");
                compiler.emit("private int " + countVar + " = 0;");
                compiler.emit("public Item mapItem(final Item " + itemVar + ") throws XPathException {");
                compiler.emit(countVar + "++;");
                compiler.emit("if (" + countVar + " == 2) {");
                compiler.emitDynamicError("A sequence of more than one item is not allowed as the " + role.getMessage(), role.getErrorCode());
                compiler.emit("}");
                compiler.emit("return " + itemVar + ";");
                compiler.emit("} // end of method mapItem");
                compiler.emit("}; // end of class ItemMappingFunction");
                compiler.declare(ItemMappingIterator.class, resultVar, "new ItemMappingIterator(" + baseVar + ", " + mfVar + ");", true);
            }
        }
        return resultVar;
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        final CardinalityChecker exp = (CardinalityChecker)expr;
        int n = compiler.getUniqueNumber();
        if (exp.getRequiredCardinality() == 24576) {
            final String resultVar = "m" + n;
            final String countVar = "count" + n;
            compiler.declare(Item.class, resultVar, "null", false);
            compiler.declare(Integer.TYPE, countVar, "0", false);
            LoopAction action = new LoopAction(){

                public void compileAction(CompilerService compiler, String itemVar) {
                    compiler.emit("if (++" + countVar + " == 2) {");
                    RoleLocator role = exp.getRoleLocator();
                    compiler.emitDynamicError("A sequence of more than one item is not allowed as the " + role.getMessage(), role.getErrorCode());
                    compiler.emit("}");
                    compiler.assign(resultVar, itemVar);
                }
            };
            compiler.compileAsLoop(exp.getBaseExpression(), action);
            return resultVar;
        }
        if (exp.getRequiredCardinality() == 16384) {
            if (Cardinality.allowsMany((int)exp.getBaseExpression().getCardinality())) {
                final String resultVar = "m" + n;
                final String countVar = "count" + n;
                compiler.declare(Item.class, resultVar, "null", false);
                compiler.declare(Integer.TYPE, countVar, "0", false);
                LoopAction action = new LoopAction(){

                    public void compileAction(CompilerService compiler, String itemVar) {
                        compiler.emit("if (++" + countVar + " == 2) {");
                        RoleLocator role = exp.getRoleLocator();
                        compiler.emitDynamicError("A sequence of more than one item is not allowed as the " + role.getMessage(), role.getErrorCode());
                        compiler.emit("}");
                        compiler.assign(resultVar, itemVar);
                    }
                };
                compiler.compileAsLoop(exp.getBaseExpression(), action);
                if (Cardinality.allowsZero((int)exp.getBaseExpression().getCardinality())) {
                    compiler.emit("if (" + countVar + " == 0) {");
                    RoleLocator role = exp.getRoleLocator();
                    compiler.emitDynamicError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode());
                    compiler.emit("}");
                }
                return resultVar;
            }
            String itemVar = compiler.compileToItem(exp.getBaseExpression());
            compiler.emit("if (" + itemVar + " == null) {");
            RoleLocator role = exp.getRoleLocator();
            compiler.emitDynamicError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode());
            compiler.emit("}");
            return itemVar;
        }
        if (exp.getRequiredCardinality() == 8192) {
            final String resultVar = "m" + n;
            compiler.emit("Item " + resultVar + " = null;");
            LoopAction action = new LoopAction(){

                public void compileAction(CompilerService compiler, String itemVar) {
                    RoleLocator role = exp.getRoleLocator();
                    compiler.emitDynamicError("A non-empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode());
                    compiler.assign(resultVar, itemVar);
                }
            };
            compiler.compileAsLoop(exp.getBaseExpression(), action);
            return resultVar;
        }
        throw new UnsupportedOperationException("Cardinality check not implemented");
    }
}

