/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.JavaDeclaration;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.BooleanFn;

public class BooleanFnCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        BooleanFn exp = (BooleanFn)expr;
        int operator = exp.getDetails().opcode;
        int n = compiler.getUniqueNumber();
        String varName = "b" + n;
        if (operator == 0) {
            String var = compiler.compileToEffectiveBooleanValue(exp.getArguments()[0], new JavaDeclaration(Boolean.TYPE, varName));
            return "BooleanValue.get(" + var + ")";
        }
        String var = compiler.compileToEffectiveBooleanValue(exp.getArguments()[0], new JavaDeclaration(Boolean.TYPE, varName));
        return "BooleanValue.get(!" + var + ")";
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction result) {
        BooleanFn exp = (BooleanFn)expr;
        int operator = exp.getDetails().opcode;
        if (operator == 0) {
            compiler.compileToEffectiveBooleanValue(exp.getArguments()[0], result);
            return result.getVariableName();
        }
        String var = compiler.compileToEffectiveBooleanValue(exp.getArguments()[0], new JavaDeclaration(Boolean.TYPE, "b" + compiler.getUniqueNumber()));
        compiler.emit(result.output(compiler, "!" + var));
        return result.getVariableName();
    }
}

