/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.JavaAssignment;
import com.saxonica.codegen.JavaDeclaration;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ToBooleanCompiler;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Expression;

public class BooleanExpressionCompiler
extends ToBooleanCompiler {
    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction result) {
        BooleanExpression exp = (BooleanExpression)expr;
        Expression[] operands = exp.getOperands();
        int operator = exp.getOperator();
        int n = compiler.getUniqueNumber();
        boolean doReturn = false;
        if (result instanceof JavaDeclaration) {
            compiler.declare(Boolean.TYPE, result.getVariableName(), null, false);
            result = new JavaAssignment(Boolean.TYPE, result.getVariableName());
        }
        if (operator == 10) {
            String op0var = compiler.compileToEffectiveBooleanValue(operands[0], result);
            compiler.emit("if (" + op0var + ") {");
            String op1var = compiler.compileToEffectiveBooleanValue(operands[1], result);
            if (!op1var.equals(result.getVariableName())) {
                compiler.emit(result.output(compiler, op1var));
            }
            if (op0var.equals(result.getVariableName())) {
                compiler.emit("}");
            } else {
                compiler.emit("} else {");
                compiler.emit(result.output(compiler, "false"));
                compiler.emit("}");
            }
        } else {
            String op0var = compiler.compileToEffectiveBooleanValue(operands[0], result);
            if (op0var.equals(result.getVariableName())) {
                compiler.emit("if (!" + op0var + ") {");
            } else {
                compiler.emit("if (" + op0var + ") {");
                compiler.emit(result.output(compiler, "true"));
                compiler.emit("} else {");
            }
            String op1var = compiler.compileToEffectiveBooleanValue(operands[1], result);
            if (!op1var.equals(result.getVariableName())) {
                compiler.emit(result.output(compiler, op1var));
            }
            compiler.emit("}");
        }
        if (doReturn) {
            compiler.emit("return " + result.getVariableName() + ";");
        }
        return result.getVariableName();
    }
}

