/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.PushExpressionCompiler;
import com.saxonica.codegen.ValueCompiler;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.BlockIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;

public class BlockCompiler
extends PushExpressionCompiler {
    public void compilePush(CompilerService compiler, Expression exp) {
        Expression[] kids = ((Block)exp).getChildren();
        for (int i = 0; i < kids.length; ++i) {
            compiler.compilePush(kids[i]);
        }
    }

    public String compileToValueRepresentation(CompilerService compiler, Expression expr) {
        int n = compiler.getUniqueNumber();
        final String listVar = "list" + n;
        compiler.declare(List.class, listVar, "new ArrayList(50)", true);
        LoopAction action = new LoopAction(){

            public void compileAction(CompilerService compiler, String itemVar) {
                compiler.emit(listVar + ".add(" + itemVar + ");");
            }
        };
        compiler.compileAsLoop(expr, action);
        return "new SequenceExtent(" + listVar + ")";
    }

    public String compileToIterator(CompilerService compiler, Expression expr) {
        int n = compiler.getUniqueNumber();
        Expression[] childExpressions = ((Block)expr).getChildren();
        String arrayVar = "block" + n;
        FastStringBuffer buff = this.makeIterableArray(childExpressions, compiler);
        compiler.declare(SequenceIterable[].class, arrayVar, buff.toString(), true);
        String iterVar = "blockIterator" + n;
        compiler.declare(BlockIterator.class, iterVar, "new BlockIterator(" + arrayVar + ", " + compiler.getContextVariableName() + ")", true);
        return iterVar;
    }

    private FastStringBuffer makeIterableArray(Expression[] childExpressions, CompilerService compiler) {
        TypeHierarchy th = compiler.getTypeHierarchy();
        ArrayList<String> vars = new ArrayList<String>(childExpressions.length);
        int n = compiler.getUniqueNumber();
        for (int i = 0; i < childExpressions.length; ++i) {
            Expression exp = childExpressions[i];
            if (Literal.isAtomic((Expression)exp)) {
                AtomicValue av = (AtomicValue)((Literal)exp).getValue();
                ValueCompiler avc = compiler.getValueCompiler((Value)av);
                vars.add(avc.compileToItem(compiler, av));
                continue;
            }
            if (exp.getCardinality() == 16384 && th.isSubType(exp.getItemType(th), (ItemType)BuiltInAtomicType.ANY_ATOMIC)) {
                vars.add(compiler.cast(compiler.compileToItem(exp), AtomicValue.class));
                continue;
            }
            if (!Cardinality.allowsMany((int)exp.getCardinality())) {
                vars.add("Value.fromItem(" + compiler.compileToItem(exp) + ")");
                continue;
            }
            String v = "seq" + n + "_" + i;
            String contextVar = "context" + n;
            vars.add(v);
            compiler.emit("SequenceIterable " + v + " = new SequenceIterable() {");
            compiler.emit("public SequenceIterator iterate(final XPathContext " + contextVar + ") throws XPathException {");
            compiler.pushContextVariable(contextVar);
            String s = compiler.compileToIterator(exp);
            compiler.emit("return " + s + ";");
            compiler.popContextVariable();
            compiler.emit("}");
            compiler.emit("};");
        }
        FastStringBuffer buff = new FastStringBuffer(256);
        buff.append("{");
        buff.append((String)vars.get(0));
        for (int i = 1; i < childExpressions.length; ++i) {
            buff.append(", ");
            buff.append((String)vars.get(i));
        }
        buff.append("}");
        return buff;
    }
}

