/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ValueCompiler;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.Value;

public class BigIntegerValueCompiler
extends ValueCompiler {
    public String compileToEffectiveBooleanValue(CompilerService compiler, Value value, ReturnAction result) {
        compiler.emit(result.output(compiler, ((BigIntegerValue)value).compareTo(0L) == 0 ? "false" : "true"));
        return result.getVariableName();
    }

    public String toJavaExpression(AtomicValue value, CompilerService compiler) {
        BigIntegerValue v = (BigIntegerValue)value;
        AtomicType t = v.getTypeLabel();
        if (t.equals(BuiltInAtomicType.INTEGER)) {
            return "new BigIntegerValue(new java.math.BigInteger(\"" + v.toString() + "\"))";
        }
        String typeVar = compiler.compileItemType((ItemType)t);
        return "new BigIntegerValue(new java.math.BigInteger(\"" + v.toString() + "\"), " + typeVar + ")";
    }
}

