/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ContextItemCompiler;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;

public class AxisExpressionCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        AxisExpression exp = (AxisExpression)expr;
        String origin = ContextItemCompiler.compileGetContextNode(compiler);
        return AxisExpressionCompiler.compileToIterator(compiler, exp, origin);
    }

    private static String compileToIterator(CompilerService compiler, AxisExpression exp, String origin) {
        String method;
        NodeTest test = exp.getNodeTest();
        String var = "s" + compiler.getUniqueNumber();
        compiler.emitComment("step " + Axis.axisName[exp.getAxis()] + "::" + (test == null ? "node()" : test.toString(compiler.getNamePool())));
        if (test == null) {
            method = ".iterateAxis(Axis." + Axis.axisJavaName[exp.getAxis()] + ")";
        } else {
            String testvar = compiler.compileNodeTest(test);
            method = ".iterateAxis(Axis." + Axis.axisJavaName[exp.getAxis()] + ", " + testvar + ")";
        }
        compiler.declare(AxisIterator.class, var, origin + method, true);
        return var;
    }

    public void compileAsLoop(CompilerService compiler, Expression expr, LoopAction action) {
        int n = compiler.getUniqueNumber();
        String iterVar = compiler.compileToIterator(expr);
        String itemVar = "node" + n;
        compiler.emit("while (true) {");
        compiler.declare(NodeInfo.class, itemVar, compiler.cast(iterVar + ".next()", NodeInfo.class), true);
        compiler.emit("if (" + itemVar + " == null) break;");
        action.compileAction(compiler, itemVar);
        compiler.emit("}");
    }
}

