/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Value;

public class AtomizerCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        Atomizer exp = (Atomizer)expr;
        String baseVar = compiler.compileToIterator(exp.getBaseExpression());
        int n = compiler.getUniqueNumber();
        String resultVar = "atomizer" + n;
        compiler.declare(SequenceIterator.class, resultVar, "Atomizer.getAtomizingIterator(" + baseVar + ")", true);
        return resultVar;
    }

    public void compileAsLoop(CompilerService compiler, Expression expr, final LoopAction action) {
        Atomizer exp = (Atomizer)expr;
        int n = compiler.getUniqueNumber();
        final String atomizedVar = "atomized" + n;
        final String indexVar = "i" + n;
        TypeHierarchy th = compiler.getTypeHierarchy();
        LoopAction outerAction = th.isSubType(exp.getBaseExpression().getItemType(th), Type.NODE_TYPE) ? new LoopAction(){

            public void compileAction(CompilerService compiler, String itemVar) {
                compiler.declare(Value.class, atomizedVar, compiler.cast(itemVar, NodeInfo.class) + ".atomize()", true);
                compiler.emit("for (int " + indexVar + "=0; " + indexVar + "<" + atomizedVar + ".getLength(); " + indexVar + "++) {");
                action.compileAction(compiler, atomizedVar + ".itemAt(" + indexVar + ")");
                compiler.emit("}");
            }
        } : new LoopAction(){

            public void compileAction(CompilerService compiler, String itemVar) {
                compiler.emit("if (" + itemVar + " instanceof NodeInfo) {");
                compiler.declare(Value.class, atomizedVar, compiler.cast(itemVar, NodeInfo.class) + ".atomize()", true);
                compiler.emit("for (int " + indexVar + "=0; " + indexVar + "<" + atomizedVar + ".getLength(); " + indexVar + "++) {");
                action.compileAction(compiler, atomizedVar + ".itemAt(" + indexVar + ")");
                compiler.emit("}");
                compiler.emit("} else {");
                action.compileAction(compiler, itemVar);
                compiler.emit("}");
            }
        };
        compiler.compileAsLoop(exp.getBaseExpression(), outerAction);
    }
}

