/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.YearMonthDurationValue;

public class ArithmeticCompiler
extends SingletonExpressionCompiler {
    private static String[] operatorName = new String[]{"Calculator.PLUS", "Calculator.MINUS", "Calculator.TIMES", "Calculator.DIV", "Calculator.MOD", "Calculator.IDIV"};

    public String compileToItem(CompilerService compiler, Expression expr) {
        int type1;
        ArithmeticExpression exp = (ArithmeticExpression)expr;
        Expression[] operands = exp.getOperands();
        int operator = exp.getOperator();
        int n = compiler.getUniqueNumber();
        String resultVar = "m" + n;
        TypeHierarchy th = compiler.getTypeHierarchy();
        AtomicType result = (AtomicType)exp.getItemType(th);
        Class resultClass = result.equals(BuiltInAtomicType.NUMERIC) ? NumericValue.class : (result.equals(BuiltInAtomicType.DOUBLE) ? DoubleValue.class : (result.equals(BuiltInAtomicType.FLOAT) ? FloatValue.class : (result.equals(BuiltInAtomicType.DECIMAL) ? NumericValue.class : (result.equals(BuiltInAtomicType.INTEGER) ? IntegerValue.class : (result.equals(BuiltInAtomicType.DAY_TIME_DURATION) ? DayTimeDurationValue.class : (result.equals(BuiltInAtomicType.YEAR_MONTH_DURATION) ? YearMonthDurationValue.class : (result.equals(BuiltInAtomicType.DATE_TIME) ? DateTimeValue.class : (result.equals(BuiltInAtomicType.DATE) ? DateValue.class : (result.equals(BuiltInAtomicType.TIME) ? TimeValue.class : AtomicValue.class)))))))));
        String op0var = compiler.compileToItem(operands[0]);
        String op1var = compiler.compileToItem(operands[1]);
        int type0 = operands[0].getItemType(th).getPrimitiveType();
        String calcName = Calculator.getCalculatorSetName((int)type0, (int)(type1 = operands[1].getItemType(th).getPrimitiveType()));
        if (calcName == null) {
            calcName = "ANY_ANY";
        }
        String jexp = "(" + compiler.getClassName(resultClass) + ")Calculator." + calcName + "[" + operatorName[ArithmeticExpression.mapOpCode((int)operator)] + "].compute(" + compiler.cast(op0var, AtomicValue.class) + ", " + compiler.cast(op1var, AtomicValue.class) + ", " + compiler.getContextVariableName() + ")";
        boolean emptiable0 = Cardinality.allowsZero((int)operands[0].getCardinality());
        boolean emptiable1 = Cardinality.allowsZero((int)operands[1].getCardinality());
        if (emptiable0 || emptiable1) {
            String condition;
            if (emptiable0) {
                condition = op0var + " == null";
                if (emptiable1) {
                    condition = condition + " || " + op1var + " == null";
                }
            } else {
                condition = op1var + " == null";
            }
            jexp = "( " + condition + " ? null : " + jexp + ")";
        }
        compiler.declare(resultClass, resultVar, jexp, true);
        return resultVar;
    }
}

