/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ValueCompiler;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class AnyURIValueCompiler
extends ValueCompiler {
    public String toJavaExpression(AtomicValue value, CompilerService compiler) {
        AtomicType type = value.getTypeLabel();
        String t = "";
        if (!type.equals(BuiltInAtomicType.ANY_URI)) {
            t = ", " + compiler.compileItemType((ItemType)type);
        }
        return "new AnyURIValue(" + CompilerService.javaEscape(((StringValue)value).getStringValue()) + ", " + compiler.compileItemType((ItemType)value.getTypeLabel()) + t + ")";
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Value expr, ReturnAction result) {
        compiler.emit(result.output(compiler, ((StringValue)expr).isZeroLength() ? "false" : "true"));
        return result.getVariableName();
    }
}

