/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.functions.Adjust;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DayTimeDurationValue;

public class AdjustCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        Adjust exp = (Adjust)expr;
        Expression baseArg = exp.getArguments()[0];
        String baseVar = compiler.compileToItem(baseArg);
        int n = compiler.getUniqueNumber();
        String resultVar = "adjusted" + n;
        boolean conditional = false;
        compiler.declare(CalendarValue.class, resultVar, "null", false);
        if (Cardinality.allowsZero((int)baseArg.getCardinality())) {
            conditional = true;
            compiler.emit("if (" + baseVar + " == null) {");
            compiler.emit(resultVar + " = null;");
            compiler.emit("} else {");
        }
        if (exp.getNumberOfArguments() == 1) {
            compiler.assign(resultVar, compiler.cast(baseVar, CalendarValue.class) + ".adjustTimezone(" + compiler.getContextVariableName() + ".getImplicitTimezone())");
        } else {
            Expression tzExp = exp.getArguments()[1];
            if (Literal.isEmptySequence((Expression)tzExp)) {
                compiler.assign(resultVar, compiler.cast(baseVar, CalendarValue.class) + ".removeTimezone()");
            } else {
                String tzVar = compiler.compileToItem(exp.getArguments()[1]);
                compiler.emit("if (" + tzVar + " == null) {");
                compiler.assign(resultVar, compiler.cast(baseVar, CalendarValue.class) + ".removeTimezone()");
                compiler.emit("} else {");
                compiler.assign(resultVar, compiler.cast(baseVar, CalendarValue.class) + ".adjustTimezone(" + compiler.cast(tzVar, DayTimeDurationValue.class) + ")");
                compiler.emit("}");
            }
        }
        if (conditional) {
            compiler.emit("}");
        }
        return resultVar;
    }
}

