/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.http.AbstractHttpSenderConnection;

public class JdkHttpClientConnection
extends AbstractHttpSenderConnection {
    private static final Log logger = LogFactory.getLog(JdkHttpClientConnection.class);
    private static final List<String> DISALLOWED_HEADERS = List.of("connection", "content-length", "expect", "host", "upgrade");
    private final HttpClient httpClient;
    private final URI uri;
    private final HttpRequest.Builder requestBuilder;
    private HttpRequest request;
    private ByteArrayOutputStream requestBuffer;
    private HttpResponse<InputStream> response;

    protected JdkHttpClientConnection(HttpClient httpClient, URI uri, Duration requestTimeout) {
        Assert.notNull((Object)httpClient, (String)"httpClient must not be null");
        Assert.notNull((Object)uri, (String)"uri must not be null");
        Assert.notNull((Object)requestTimeout, (String)"requestTimeout must not be null");
        this.httpClient = httpClient;
        this.uri = uri;
        this.requestBuilder = HttpRequest.newBuilder(uri).timeout(requestTimeout);
    }

    @Override
    protected OutputStream getRequestOutputStream() throws IOException {
        return this.requestBuffer;
    }

    @Override
    public Iterator<String> getResponseHeaderNames() throws IOException {
        return this.response.headers().map().keySet().iterator();
    }

    @Override
    public Iterator<String> getResponseHeaders(String name) throws IOException {
        return this.response.headers().allValues(name).iterator();
    }

    @Override
    public void addRequestHeader(String name, String value) throws IOException {
        if (DISALLOWED_HEADERS.contains(name.toLowerCase())) {
            logger.trace((Object)("HttpClient doesn't allow setting the '" + name + "' header, ignoring!"));
            return;
        }
        this.requestBuilder.header(name, value);
    }

    @Override
    public URI getUri() throws URISyntaxException {
        return this.uri;
    }

    @Override
    protected int getResponseCode() throws IOException {
        return this.response != null ? this.response.statusCode() : 0;
    }

    @Override
    protected String getResponseMessage() throws IOException {
        HttpStatus status = HttpStatus.resolve((int)this.getResponseCode());
        return status != null ? status.getReasonPhrase() : "";
    }

    @Override
    protected long getResponseContentLength() throws IOException {
        if (this.response != null) {
            return this.response.headers().firstValueAsLong("Content-Length").orElse(-1L);
        }
        return 0L;
    }

    @Override
    protected InputStream getRawResponseInputStream() throws IOException {
        return this.response.body();
    }

    @Override
    protected void onSendBeforeWrite(WebServiceMessage message) throws IOException {
        this.requestBuffer = new ByteArrayOutputStream();
    }

    @Override
    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        byte[] body = this.requestBuffer.toByteArray();
        this.request = this.requestBuilder.POST(HttpRequest.BodyPublishers.ofByteArray(body)).build();
        try {
            this.response = this.httpClient.send(this.request, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
    }

    @Override
    protected void onClose() throws IOException {
        if (this.response != null) {
            this.response.body().close();
        }
    }
}

