/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint.interceptor;

import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.endpoint.support.PayloadRootUtils;
import org.springframework.ws.soap.server.endpoint.interceptor.DelegatingSmartSoapEndpointInterceptor;
import org.springframework.xml.transform.TransformerHelper;

public class PayloadRootSmartSoapEndpointInterceptor
extends DelegatingSmartSoapEndpointInterceptor {
    private TransformerHelper transformerHelper = new TransformerHelper();
    private final String namespaceUri;
    private final String localPart;

    public PayloadRootSmartSoapEndpointInterceptor(EndpointInterceptor delegate, String namespaceUri, String localPart) {
        super(delegate);
        Assert.hasLength((String)namespaceUri, (String)"namespaceUri can not be empty");
        this.namespaceUri = namespaceUri;
        this.localPart = localPart;
    }

    public void setTransformerHelper(TransformerHelper transformerHelper) {
        this.transformerHelper = transformerHelper;
    }

    @Override
    protected boolean shouldIntercept(WebServiceMessage request, Object endpoint) {
        try {
            QName payloadRootName = PayloadRootUtils.getPayloadRootQName(request.getPayloadSource(), this.transformerHelper);
            if (payloadRootName == null || !this.namespaceUri.equals(payloadRootName.getNamespaceURI())) {
                return false;
            }
            return !StringUtils.hasLength((String)this.localPart) || this.localPart.equals(payloadRootName.getLocalPart());
        }
        catch (TransformerException ex) {
            return false;
        }
    }
}

