/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.EndpointInvocationChain;
import org.springframework.ws.server.SmartEndpointInterceptor;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.messageid.MessageIdStrategy;
import org.springframework.ws.soap.addressing.messageid.UuidMessageIdStrategy;
import org.springframework.ws.soap.addressing.server.AddressingEndpointInterceptor;
import org.springframework.ws.soap.addressing.version.Addressing10;
import org.springframework.ws.soap.addressing.version.Addressing200408;
import org.springframework.ws.soap.addressing.version.AddressingVersion;
import org.springframework.ws.soap.server.SoapEndpointInvocationChain;
import org.springframework.ws.soap.server.SoapEndpointMapping;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.xml.transform.TransformerObjectSupport;

public abstract class AbstractAddressingEndpointMapping
extends TransformerObjectSupport
implements SoapEndpointMapping,
ApplicationContextAware,
InitializingBean,
Ordered {
    private String[] actorsOrRoles;
    private boolean isUltimateReceiver = true;
    private MessageIdStrategy messageIdStrategy;
    private WebServiceMessageSender[] messageSenders = new WebServiceMessageSender[0];
    private AddressingVersion[] versions;
    private EndpointInterceptor[] preInterceptors = new EndpointInterceptor[0];
    private EndpointInterceptor[] postInterceptors = new EndpointInterceptor[0];
    private SmartEndpointInterceptor[] smartInterceptors = new SmartEndpointInterceptor[0];
    private ApplicationContext applicationContext;
    private int order = Integer.MAX_VALUE;

    protected AbstractAddressingEndpointMapping() {
        this.initDefaultStrategies();
    }

    protected void initDefaultStrategies() {
        this.versions = new AddressingVersion[]{new Addressing200408(), new Addressing10()};
        this.messageIdStrategy = new UuidMessageIdStrategy();
    }

    @Override
    public final void setActorOrRole(String actorOrRole) {
        Assert.notNull((Object)actorOrRole, (String)"actorOrRole must not be null");
        this.actorsOrRoles = new String[]{actorOrRole};
    }

    @Override
    public final void setActorsOrRoles(String[] actorsOrRoles) {
        Assert.notEmpty((Object[])actorsOrRoles, (String)"actorsOrRoles must not be empty");
        this.actorsOrRoles = actorsOrRoles;
    }

    @Override
    public final void setUltimateReceiver(boolean ultimateReceiver) {
        this.isUltimateReceiver = ultimateReceiver;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public final int getOrder() {
        return this.order;
    }

    public final void setOrder(int order) {
        this.order = order;
    }

    public final void setPreInterceptors(EndpointInterceptor[] preInterceptors) {
        Assert.notNull((Object)preInterceptors, (String)"'preInterceptors' must not be null");
        this.preInterceptors = preInterceptors;
    }

    public final void setPostInterceptors(EndpointInterceptor[] postInterceptors) {
        Assert.notNull((Object)postInterceptors, (String)"'postInterceptors' must not be null");
        this.postInterceptors = postInterceptors;
    }

    public final void setMessageIdStrategy(MessageIdStrategy messageIdStrategy) {
        Assert.notNull((Object)messageIdStrategy, (String)"'messageIdStrategy' must not be null");
        this.messageIdStrategy = messageIdStrategy;
    }

    public MessageIdStrategy getMessageIdStrategy() {
        return this.messageIdStrategy;
    }

    public final void setMessageSender(WebServiceMessageSender messageSender) {
        Assert.notNull((Object)messageSender, (String)"'messageSender' must not be null");
        this.setMessageSenders(new WebServiceMessageSender[]{messageSender});
    }

    public final void setMessageSenders(WebServiceMessageSender[] messageSenders) {
        Assert.notNull((Object)messageSenders, (String)"'messageSenders' must not be null");
        this.messageSenders = messageSenders;
    }

    public final WebServiceMessageSender[] getMessageSenders() {
        return this.messageSenders;
    }

    public final void setVersions(AddressingVersion[] versions) {
        this.versions = versions;
    }

    public void afterPropertiesSet() throws Exception {
        Map smartInterceptors;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Supporting " + String.valueOf(Arrays.asList(this.versions))));
        }
        if (this.getApplicationContext() != null && !(smartInterceptors = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), SmartEndpointInterceptor.class, (boolean)true, (boolean)false)).isEmpty()) {
            this.smartInterceptors = smartInterceptors.values().toArray(new SmartEndpointInterceptor[0]);
        }
    }

    @Override
    public final EndpointInvocationChain getEndpoint(MessageContext messageContext) throws TransformerException {
        Assert.isInstanceOf(SoapMessage.class, (Object)messageContext.getRequest());
        SoapMessage request = (SoapMessage)messageContext.getRequest();
        for (AddressingVersion version : this.versions) {
            MessageAddressingProperties requestMap;
            if (!this.supports(version, request)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Request [" + String.valueOf(request) + "] uses [" + String.valueOf(version) + "]"));
            }
            if ((requestMap = version.getMessageAddressingProperties(request)) == null) {
                return null;
            }
            Object endpoint = this.getEndpointInternal(requestMap);
            if (endpoint == null) {
                return null;
            }
            return this.getEndpointInvocationChain(endpoint, version, requestMap, messageContext);
        }
        return null;
    }

    private EndpointInvocationChain getEndpointInvocationChain(Object endpoint, AddressingVersion version, MessageAddressingProperties requestMap, MessageContext messageContext) {
        URI responseAction = this.getResponseAction(endpoint, requestMap);
        URI faultAction = this.getFaultAction(endpoint, requestMap);
        WebServiceMessageSender[] messageSenders = this.getMessageSenders(endpoint);
        MessageIdStrategy messageIdStrategy = this.getMessageIdStrategy(endpoint);
        ArrayList<EndpointInterceptor> interceptors = new ArrayList<EndpointInterceptor>(Arrays.asList(this.preInterceptors));
        AddressingEndpointInterceptor addressingInterceptor = new AddressingEndpointInterceptor(version, messageIdStrategy, messageSenders, responseAction, faultAction);
        interceptors.add(addressingInterceptor);
        interceptors.addAll(Arrays.asList(this.postInterceptors));
        if (this.smartInterceptors != null) {
            for (SmartEndpointInterceptor smartInterceptor : this.smartInterceptors) {
                if (!smartInterceptor.shouldIntercept(messageContext, endpoint)) continue;
                interceptors.add(smartInterceptor);
            }
        }
        return new SoapEndpointInvocationChain(endpoint, interceptors.toArray(new EndpointInterceptor[0]), this.actorsOrRoles, this.isUltimateReceiver);
    }

    private boolean supports(AddressingVersion version, SoapMessage request) {
        SoapHeader header = request.getSoapHeader();
        if (header != null) {
            Iterator<SoapHeaderElement> iterator = header.examineAllHeaderElements();
            while (iterator.hasNext()) {
                SoapHeaderElement headerElement = iterator.next();
                if (!version.understands(headerElement)) continue;
                return true;
            }
        }
        return false;
    }

    protected WebServiceMessageSender[] getMessageSenders(Object endpoint) {
        return this.getMessageSenders();
    }

    protected MessageIdStrategy getMessageIdStrategy(Object endpoint) {
        return this.getMessageIdStrategy();
    }

    protected abstract Object getEndpointInternal(MessageAddressingProperties var1);

    protected abstract URI getResponseAction(Object var1, MessageAddressingProperties var2);

    protected abstract URI getFaultAction(Object var1, MessageAddressingProperties var2);
}

