/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.config.annotation;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.ws.config.annotation.WsConfigurationSupport;
import org.springframework.ws.config.annotation.WsConfigurer;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.endpoint.adapter.method.MethodArgumentResolver;
import org.springframework.ws.server.endpoint.adapter.method.MethodReturnValueHandler;

@Configuration
public class DelegatingWsConfiguration
extends WsConfigurationSupport {
    private WsConfigurers configurers = new WsConfigurers(Collections.emptyList());

    @Deprecated(since="4.0.12", forRemoval=true)
    public void setConfigurers(List<WsConfigurer> configurers) {
        if (configurers != null && !configurers.isEmpty()) {
            this.configurers = new WsConfigurers(configurers);
        }
    }

    @Autowired
    public void setConfigurers(ObjectProvider<WsConfigurer> configurers) {
        this.configurers = new WsConfigurers(configurers);
    }

    @Override
    protected void addInterceptors(List<EndpointInterceptor> interceptors) {
        this.configurers.addInterceptors(interceptors);
    }

    @Override
    protected void addArgumentResolvers(List<MethodArgumentResolver> argumentResolvers) {
        this.configurers.addArgumentResolvers(argumentResolvers);
    }

    @Override
    protected void addReturnValueHandlers(List<MethodReturnValueHandler> returnValueHandlers) {
        this.configurers.addReturnValueHandlers(returnValueHandlers);
    }

    private static final class WsConfigurers
    implements WsConfigurer {
        private final Supplier<Stream<WsConfigurer>> delegates;

        WsConfigurers(ObjectProvider<WsConfigurer> wsConfigurers) {
            this.delegates = () -> wsConfigurers.stream();
        }

        WsConfigurers(List<WsConfigurer> wsConfigurers) {
            this.delegates = wsConfigurers::stream;
        }

        @Override
        public void addInterceptors(List<EndpointInterceptor> interceptors) {
            this.delegates.get().forEach(configurer -> configurer.addInterceptors(interceptors));
        }

        @Override
        public void addArgumentResolvers(List<MethodArgumentResolver> argumentResolvers) {
            this.delegates.get().forEach(configurer -> configurer.addArgumentResolvers(argumentResolvers));
        }

        @Override
        public void addReturnValueHandlers(List<MethodReturnValueHandler> returnValueHandlers) {
            this.delegates.get().forEach(configurer -> configurer.addReturnValueHandlers(returnValueHandlers));
        }
    }
}

