/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.client.support.destination;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.ws.client.WebServiceIOException;
import org.springframework.ws.client.WebServiceTransformerException;
import org.springframework.ws.client.support.destination.AbstractCachingDestinationProvider;
import org.springframework.xml.transform.ResourceSource;
import org.springframework.xml.transform.TransformerFactoryUtils;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Wsdl11DestinationProvider
extends AbstractCachingDestinationProvider {
    public static final String DEFAULT_WSDL_LOCATION_EXPRESSION = "/wsdl:definitions/wsdl:service/wsdl:port/soap:address/@location";
    private static final TransformerFactory transformerFactory = TransformerFactoryUtils.newInstance();
    private final Map<String, String> expressionNamespaces = new HashMap<String, String>();
    private XPathExpression locationXPathExpression;
    private Resource wsdlResource;

    public Wsdl11DestinationProvider() {
        this.expressionNamespaces.put("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.expressionNamespaces.put("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.expressionNamespaces.put("soap12", "http://schemas.xmlsoap.org/wsdl/soap12/");
        this.locationXPathExpression = XPathExpressionFactory.createXPathExpression((String)DEFAULT_WSDL_LOCATION_EXPRESSION, this.expressionNamespaces);
    }

    public void setWsdl(Resource wsdlResource) {
        Assert.notNull((Object)wsdlResource, (String)"'wsdl' must not be null");
        Assert.isTrue((boolean)wsdlResource.exists(), (String)(String.valueOf(wsdlResource) + " does not exist"));
        this.wsdlResource = wsdlResource;
    }

    public void setLocationExpression(String expression) {
        Assert.hasText((String)expression, (String)"'expression' must not be empty");
        this.locationXPathExpression = XPathExpressionFactory.createXPathExpression((String)expression, this.expressionNamespaces);
    }

    @Override
    protected URI lookupDestination() {
        try {
            DOMResult result = new DOMResult();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform((Source)new ResourceSource(this.wsdlResource), result);
            Document definitionDocument = (Document)result.getNode();
            String location = this.locationXPathExpression.evaluateAsString((Node)definitionDocument);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found location [" + location + "] in " + String.valueOf(this.wsdlResource)));
            }
            return location != null ? URI.create(location) : null;
        }
        catch (IOException ex) {
            throw new WebServiceIOException("Error extracting location from WSDL [" + String.valueOf(this.wsdlResource) + "]", ex);
        }
        catch (TransformerException ex) {
            throw new WebServiceTransformerException("Error extracting location from WSDL [" + String.valueOf(this.wsdlResource) + "]", ex);
        }
    }
}

