/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.io.ChainedIOException;
import com.sas.io.InputStreamAdapter;
import com.sas.io.ReaderAdapter;
import com.sas.io.RemoteInputStream;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.io.RemoteReader;
import com.sas.io.RemoteReaderInterface;
import com.sas.services.TransportException;
import com.sas.services.publish.ViewerEntryInterface;
import com.sas.services.publish.webdav.DAVEntry;
import com.sas.services.publish.webdav.DAVTransport;
import com.sas.services.publish.webdav.RB;
import com.sas.services.webdav.DAVException;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;

@SASScope
class DAVViewerEntry
extends DAVEntry
implements ViewerEntryInterface {
    private String _encoding = null;
    private int _viewerType = -1;
    private String _filename = null;
    private String _mimeType = null;
    private static final CharArrayReader DUMMY_READER = new CharArrayReader(new char[1]);
    private static final ByteArrayInputStream DUMMY_INPUTSTREAM = new ByteArrayInputStream(new byte[1]);

    DAVViewerEntry(DAVTransport transport, String url, int version, String filename, int viewerType) throws RemoteException {
        this(transport, url, version, filename, viewerType, DAVViewerEntry.class);
    }

    private DAVViewerEntry(DAVTransport transport, String url, int version, String filename, int viewerType, Class theClass) throws RemoteException {
        super(transport, url, version, theClass);
        this._filename = filename;
        this._viewerType = viewerType;
    }

    protected void setMaximumLineLength(int maxLineLength) {
    }

    @Override
    public String getEncoding() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._encoding;
    }

    @Override
    public void setEncoding(String encoding) throws IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.entryReadOnly.ex.txt"));
        }
        this._encoding = encoding;
    }

    @Override
    public int getViewerType() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._viewerType;
    }

    @Override
    public String getName() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._filename;
    }

    @Override
    public String getMIMEType() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._mimeType;
    }

    @Override
    public void setMIMEType(String mimeType) throws IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.entryReadOnly.ex.txt"));
        }
        this._mimeType = mimeType;
    }

    @Override
    public Reader getReader() throws IOException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 30) {
            throw new ChainedIOException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        InputStreamReader reader = null;
        try {
            reader = this._encoding == null ? new InputStreamReader(this.getResource().getContents()) : new InputStreamReader(this.getResource().getContents(), this._encoding);
        }
        catch (DAVException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        catch (TransportException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        return new ReaderAdapter((Reader)reader);
    }

    @Override
    public InputStream getInputStream() throws IOException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 30) {
            throw new ChainedIOException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        InputStream stream = null;
        try {
            stream = this.getResource().getContents();
        }
        catch (DAVException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        catch (TransportException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        return new InputStreamAdapter(stream);
    }

    @Override
    public Reader getReader(Object streamId) throws ChainedIOException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 30) {
            throw new ChainedIOException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        InputStreamReader reader = null;
        try {
            reader = this._encoding == null ? new InputStreamReader(this.getResource().getContents()) : new InputStreamReader(this.getResource().getContents(), this._encoding);
        }
        catch (DAVException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        catch (TransportException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        return reader;
    }

    @Override
    public RemoteReaderInterface getRemoteReader(Object streamId) throws ChainedIOException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 30) {
            throw new ChainedIOException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        InputStreamReader reader = null;
        try {
            reader = this._encoding == null ? new InputStreamReader(this.getResource().getContents()) : new InputStreamReader(this.getResource().getContents(), this._encoding);
        }
        catch (DAVException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteReaderIOError.ex.txt"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteReaderIOError.ex.txt"));
        }
        catch (TransportException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteReaderIOError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteReaderIOError.ex.txt"));
        }
        return new RemoteReader((Reader)reader);
    }

    @Override
    public InputStream getInputStream(Object streamId) throws ChainedIOException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 30) {
            throw new ChainedIOException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        InputStream stream = null;
        try {
            stream = this.getResource().getContents();
        }
        catch (DAVException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        catch (TransportException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        return stream;
    }

    @Override
    public RemoteInputStreamInterface getRemoteInputStream(Object streamId) throws ChainedIOException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 30) {
            throw new ChainedIOException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        InputStream stream = null;
        RemoteInputStream remoteInputStream = null;
        try {
            stream = this.getResource().getContents();
            remoteInputStream = new RemoteInputStream(stream);
        }
        catch (DAVException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteStreamIOError.ex.txt"));
        }
        catch (TransportException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteStreamIOError.ex.txt"));
        }
        return remoteInputStream;
    }

    @Override
    public Object hasInputStream() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return DUMMY_INPUTSTREAM;
    }

    @Override
    public Object hasReader() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return DUMMY_READER;
    }
}

