/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.io.ChainedIOException;
import com.sas.io.ReaderAdapter;
import com.sas.io.RemoteReader;
import com.sas.io.RemoteReaderInterface;
import com.sas.services.TransportException;
import com.sas.services.publish.TextFileEntryInterface;
import com.sas.services.publish.webdav.DAVEntry;
import com.sas.services.publish.webdav.DAVTransport;
import com.sas.services.publish.webdav.RB;
import com.sas.services.webdav.DAVException;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;

@SASScope
class DAVTextFileEntry
extends DAVEntry
implements TextFileEntryInterface {
    private String _mimeType;
    private String _filename;
    private String _encoding = null;
    private static final CharArrayReader DUMMY_READER = new CharArrayReader(new char[1]);

    DAVTextFileEntry(DAVTransport transport, String url, int version, String filename) throws RemoteException {
        this(transport, url, version, filename, DAVTextFileEntry.class);
    }

    private DAVTextFileEntry(DAVTransport transport, String url, int version, String filename, Class theClass) throws RemoteException {
        super(transport, url, version, theClass);
        this._filename = filename;
    }

    protected void setMaximumLineLength(int maxLineLength) {
    }

    @Override
    public void setEncoding(String encoding) throws IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.entryReadOnly.ex.txt"));
        }
        this._encoding = encoding;
    }

    @Override
    public void setMIMEType(String mimeType) throws IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.entryReadOnly.ex.txt"));
        }
        this._mimeType = mimeType;
    }

    @Override
    public String getMIMEType() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._mimeType;
    }

    @Override
    public String getName() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._filename;
    }

    @Override
    public Reader getReader() throws IOException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 15) {
            throw new ChainedIOException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        InputStreamReader reader = null;
        try {
            reader = this._encoding == null ? new InputStreamReader(this.getResource().getContents()) : new InputStreamReader(this.getResource().getContents(), this._encoding);
        }
        catch (DAVException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        catch (TransportException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        return new ReaderAdapter((Reader)reader);
    }

    @Override
    public Reader getReader(int maxLineLength) throws IOException, RemoteException, IllegalStateException {
        return this.getReader();
    }

    @Override
    public Reader getReader(Object streamId) throws ChainedIOException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 15) {
            throw new ChainedIOException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        InputStreamReader reader = null;
        try {
            reader = this._encoding == null ? new InputStreamReader(this.getResource().getContents()) : new InputStreamReader(this.getResource().getContents(), this._encoding);
        }
        catch (DAVException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        catch (TransportException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.readerIOError.ex.txt"));
        }
        return reader;
    }

    @Override
    public RemoteReaderInterface getRemoteReader(Object streamId) throws ChainedIOException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 15) {
            throw new ChainedIOException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        InputStreamReader reader = null;
        try {
            reader = this._encoding == null ? new InputStreamReader(this.getResource().getContents()) : new InputStreamReader(this.getResource().getContents(), this._encoding);
        }
        catch (DAVException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteReaderIOError.ex.txt"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteReaderIOError.ex.txt"));
        }
        catch (TransportException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteReaderIOError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteReaderIOError.ex.txt"));
        }
        return new RemoteReader((Reader)reader);
    }

    @Override
    public Object hasReader() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return DUMMY_READER;
    }
}

