/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.io.ChainedIOException;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.services.TransportException;
import com.sas.services.publish.EntryInterface;
import com.sas.services.publish.EventDataInterface;
import com.sas.services.publish.ResultPackageEventBuilder;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.TransportInterface;
import com.sas.services.publish.webdav.DAVEntry;
import com.sas.services.publish.webdav.DAVTransport;
import com.sas.services.publish.webdav.RB;
import com.sas.services.session.RemoteSessionContextStateChangedListener;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionContextStateChangedEvent;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.ResourceInterface;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
class DAVResultPackage
extends DAVEntry
implements ResultPackageInterface,
RemoteSessionContextStateChangedListener {
    private long _creationDateTime;
    private String _abstract = null;
    private long _expirationDateTime;
    private ArrayList _entries = new ArrayList();
    private String _encoding = null;
    private boolean _isNested = false;
    TransportInterface _transport = null;
    private String _uniqueId = new VMID().toString();
    private Logger logger = LogManager.getLogger(DAVResultPackage.class);
    private SessionContextInterface _sessionContext = null;
    private Map _loose = null;
    private Map _allMyEntries = new HashMap();
    static ByteArrayInputStream dummyInputStream = new ByteArrayInputStream(new byte[1]);

    DAVResultPackage(DAVTransport transport, String url, int version) throws RemoteException {
        this(transport, url, version, (ResourceInterface)null);
    }

    DAVResultPackage(DAVTransport transport, String url, int version, ResourceInterface resource) throws RemoteException {
        this(transport, url, version, resource, DAVResultPackage.class);
    }

    private DAVResultPackage(DAVTransport transport, String url, int version, ResourceInterface resource, Class theClass) throws RemoteException {
        super(transport, url, version, resource, theClass);
        this._encoding = version <= 1 ? "ISO-8859-1" : "UTF-8";
        this._transport = transport;
        this._sessionContext = transport.getSessionContext();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.throwExceptionIfClosed();
        if (this.isNested()) {
            throw new IllegalStateException(RB.getStringResource("DAVResultPackage.streamNested.ex.txt"));
        }
        return null;
    }

    @Override
    public Object hasInputStream() throws UnmarshalException, IllegalStateException {
        this.throwExceptionIfClosed();
        return dummyInputStream;
    }

    @Override
    public InputStream getInputStream(Object streamID) throws ChainedIOException {
        this.throwExceptionIfClosed();
        if (this.isNested()) {
            throw new IllegalStateException(RB.getStringResource("DAVResultPackage.streamNested.ex.txt"));
        }
        return null;
    }

    @Override
    public RemoteInputStreamInterface getRemoteInputStream(Object streamID) throws IOException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isNested()) {
            throw new IllegalStateException(RB.getStringResource("DAVResultPackage.streamNested.ex.txt"));
        }
        return null;
    }

    @Override
    public String getAbstract() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        return this._abstract;
    }

    protected String getTextEncoding() {
        return this._encoding;
    }

    protected void setIsNested(boolean isNested) {
        this._isNested = isNested;
    }

    protected String getUniqueId() {
        return this._uniqueId;
    }

    protected void setUniqueId(String uniqueId) {
        this._uniqueId = uniqueId;
    }

    @Override
    public String getName() throws IllegalStateException, TransportException {
        this.throwExceptionIfClosed();
        String name = null;
        if (this.isNested()) {
            try {
                name = this.getResource().getName();
            }
            catch (RemoteException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("DAVCommon.error.ex.txt"));
            }
            catch (DAVException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("DAVCommon.error.ex.txt"));
            }
        } else {
            name = this.getURL();
        }
        return name;
    }

    @Override
    public void setName(String name) {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVResultPackage.readOnlyIllegalStateException.ex.txt"));
        }
    }

    @Override
    public void setAbstract(String pkgAbstract) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVResultPackage.readOnlyIllegalStateException.ex.txt"));
        }
        this._abstract = pkgAbstract;
    }

    @Override
    public long getExpirationDateTime() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        return this._expirationDateTime;
    }

    @Override
    public void setExpirationDateTime(long expirationDateTime) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVResultPackage.readOnlyIllegalStateException.ex.txt"));
        }
        this._expirationDateTime = expirationDateTime;
    }

    @Override
    public long getCreationDateTime() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        if (!this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVResultPackage.noCreationIllegalStateException.ex.txt"));
        }
        return this._creationDateTime;
    }

    protected void setCreationDateTime(long creationDateTime) throws IllegalStateException {
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVResultPackage.readOnlyIllegalStateException.ex.txt"));
        }
        this._creationDateTime = creationDateTime;
    }

    @Override
    public EntryInterface getEntry(int index) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        return (EntryInterface)this._entries.get(index);
    }

    @Override
    public EntryInterface getEntry(String uniqueId) throws IllegalStateException, RemoteException, TransportException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        return this.findEntry(uniqueId);
    }

    EntryInterface findEntry(String uniqueId) throws TransportException, RemoteException {
        EntryInterface[] entryList = null;
        EntryInterface foundEntry = null;
        foundEntry = (EntryInterface)this._allMyEntries.get(uniqueId);
        if (foundEntry == null) {
            entryList = this.getEntries();
            for (int i = 0; i < entryList.length && foundEntry == null; ++i) {
                EntryInterface entry = entryList[i];
                if (!(entry instanceof ResultPackageInterface)) continue;
                DAVResultPackage davPkg = (DAVResultPackage)entry;
                foundEntry = davPkg.findEntry(uniqueId);
            }
        }
        return foundEntry;
    }

    @Override
    public EntryInterface[] getEntries() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        EntryInterface[] entries = new EntryInterface[this._entries.size()];
        Iterator itor = this._entries.iterator();
        int i = 0;
        while (itor.hasNext()) {
            entries[i++] = (EntryInterface)itor.next();
        }
        return entries;
    }

    @Override
    public void addEntry(EntryInterface entry) throws IllegalStateException, RemoteException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVResultPackage.readOnlyIllegalStateException.ex.txt"));
        }
        if (entry instanceof DAVEntry) {
            boolean inserted = false;
            int thisPosition = ((DAVEntry)entry).getPosition();
            if (this._entries.size() > 0 && thisPosition != -1) {
                for (int i = 0; i < this._entries.size(); ++i) {
                    DAVEntry de = (DAVEntry)this._entries.get(i);
                    if (thisPosition >= de.getPosition()) continue;
                    this._entries.add(i, entry);
                    inserted = true;
                    break;
                }
            }
            if (!inserted) {
                this._entries.add(entry);
            }
        } else {
            this._entries.add(entry);
        }
        this._allMyEntries.put(entry.getEntityKey(), entry);
    }

    @Override
    public boolean isNested() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        return this._isNested;
    }

    @Override
    public void close() throws IllegalStateException, TransportException, RemoteException {
        block10: {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResultPackage.closeIt.fmt.txt", (Object)this.getEntityKey()));
            }
            if (this.isClosed()) {
                throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
            }
            if (this.isNested()) {
                throw new TransportException(RB.getStringResource("DAVResultPackage.closeNestedTransportException.ex.txt"));
            }
            for (DAVEntry e : this._entries) {
                e.closeEntry(false);
            }
            this.closeEntry(true);
            if (this._sessionContext != null) {
                try {
                    this._sessionContext.removeAttribute("com.sas.services.publish." + this._uniqueId);
                }
                catch (IllegalStateException e) {
                    if (this.logger != null) {
                        this.logger.warn(RB.getStringResource("DAVResultPackage.errorRemovingFromSession.txt"), (Throwable)e);
                    }
                }
                catch (RemoteException e) {
                    if (this.logger == null) break block10;
                    this.logger.warn(RB.getStringResource("DAVResultPackage.errorRemovingFromSession.txt"), (Throwable)e);
                }
            }
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResultPackage.closeDone.fmt.txt", (Object)this.getEntityKey()));
        }
    }

    @Override
    public void delete() throws IllegalStateException, TransportException, IllegalStateException, RemoteException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        if (this._isNested) {
            throw new IllegalStateException(RB.getStringResource("DAVResultPackage.deleteIllegalStateException.ex.txt"));
        }
        try {
            this.getResource().delete();
        }
        catch (DAVException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DAVResultPackage.deleteTransportException.ex.txt"));
        }
        finally {
            block12: {
                try {
                    this.close();
                }
                catch (RemoteException e) {
                    if (this.logger == null) break block12;
                    this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResultPackage.closeErr.fmt.txt", (Object)this.getEntityKey()));
                }
            }
        }
    }

    @Override
    public EventDataInterface getEventData() throws TransportException, RemoteException {
        EventDataInterface eventData = null;
        ResultPackageEventBuilder builder = new ResultPackageEventBuilder();
        eventData = builder.buildEvent(this, this.getName(), null, "webdav", this.getTransport().getNamespaces());
        return eventData;
    }

    public void contextStateChanged(SessionContextStateChangedEvent event) throws RemoteException {
        block8: {
            int state = event.getStateChange();
            if (state == 2) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(RB.getStringResource("DAVResultPackage.sessionDestroyed.txt"));
                }
                try {
                    this._sessionContext = null;
                    this.close();
                }
                catch (IllegalStateException e) {
                    if (this.logger != null) {
                        this.logger.warn(RB.getStringResource("DAVResultPackage.unexpectedDestroyError.txt"), (Throwable)e);
                    }
                    break block8;
                }
                catch (TransportException e) {
                    if (this.logger != null) {
                        this.logger.warn(RB.getStringResource("DAVResultPackage.unexpectedDestroyError.txt"), (Throwable)e);
                    }
                    break block8;
                }
            }
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(RB.getStringResource("DAVResultPackage.removedFromSession.txt"));
            }
        }
    }

    Map getLooseMap() {
        return this._loose;
    }

    void setLooseMap(Map loose) {
        this._loose = loose;
    }

    protected void finalize() throws Throwable {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResultPackage.finalize.fmt.txt", (Object)this.getEntityKey()));
        }
        if (!this.isClosed() && !this.isNested()) {
            this.close();
        }
        super.finalize();
    }
}

