/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.services.TransportException;
import com.sas.services.publish.ReferenceEntryInterface;
import com.sas.services.publish.webdav.DAVEntry;
import com.sas.services.publish.webdav.DAVTransport;
import com.sas.services.publish.webdav.RB;
import com.sas.services.webdav.DAVException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;

@SASScope
class DAVReferenceEntry
extends DAVEntry
implements ReferenceEntryInterface {
    private String _reference;
    private String _referenceType;
    private String _encoding;

    DAVReferenceEntry(DAVTransport transport, String url, int version, String referenceType, String encoding) throws RemoteException {
        this(transport, url, version, referenceType, encoding, DAVReferenceEntry.class);
    }

    private DAVReferenceEntry(DAVTransport transport, String url, int version, String referenceType, String encoding, Class theClass) throws RemoteException {
        super(transport, url, version, theClass);
        this._referenceType = referenceType;
        this._encoding = encoding;
    }

    protected void setLength(int length) {
    }

    @Override
    public void setReferenceType(String referenceType) throws IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.entryReadOnly.ex.txt"));
        }
        this._referenceType = referenceType;
    }

    @Override
    public void setReference(String reference) throws IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.entryReadOnly.ex.txt"));
        }
        this._reference = reference;
    }

    @Override
    public String getReferenceType() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._referenceType;
    }

    @Override
    public String getReference() throws TransportException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 15) {
            throw new TransportException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        if (this._reference == null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(this.getResource().getContents(), this._encoding));
                this._reference = reader.readLine();
            }
            catch (DAVException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("DAVReferenceEntry.transportException.ex.txt"));
            }
            catch (UnsupportedEncodingException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("DAVReferenceEntry.transportException.ex.txt"));
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("DAVReferenceEntry.transportException.ex.txt"));
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this._reference;
    }
}

