/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.entities.EntityKeyInterface;
import com.sas.io.ChainedIOException;
import com.sas.io.InputStreamAdapter;
import com.sas.io.RemoteInputStream;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.DefaultEntityKeyImpl;
import com.sas.services.TransportException;
import com.sas.services.publish.HTMLFileInterface;
import com.sas.services.publish.webdav.DAVTransport;
import com.sas.services.publish.webdav.RB;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.ResourceInterface;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

@SASScope
class DAVHTMLFile
extends UnicastRemoteObject
implements HTMLFileInterface {
    private String _encoding = null;
    private boolean _isReadOnly = false;
    private ResourceInterface _resource = null;
    private String _filename;
    private String _mimeType;
    private int _role;
    private String _url = null;
    private DAVTransport _transport = null;
    private boolean _closed = false;
    private EntityKeyInterface _entityKeyIf = new DefaultEntityKeyImpl();
    private int _position = -1;
    private static final ByteArrayInputStream DUMMY_INPUTSTREAM = new ByteArrayInputStream(new byte[1]);

    DAVHTMLFile(DAVTransport transport, String url, int role, String filename) throws RemoteException {
        this(transport, url, role, filename, DAVHTMLFile.class);
    }

    private DAVHTMLFile(DAVTransport transport, String url, int role, String filename, Class theClass) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, theClass), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(theClass), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(theClass));
        this._role = role;
        this._filename = filename;
        this._transport = transport;
        this._url = url;
    }

    protected final void setIsReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    protected final ResourceInterface getResource() throws TransportException {
        if (this._resource == null) {
            try {
                this._resource = this._transport.bindToServer(this._url);
            }
            catch (DAVException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("DAVCommon.bindFailure.ex.txt"));
            }
        }
        return this._resource;
    }

    protected final void setResource(ResourceInterface resource) {
        this._resource = resource;
    }

    protected final void setRole(int role) {
        this._role = role;
    }

    protected boolean isClosed() {
        return this._closed;
    }

    protected void setClosed(boolean closed) {
        this._closed = closed;
    }

    protected void closeEntry() {
        this._resource = null;
        this._transport = null;
        this.setClosed(true);
    }

    @Override
    public String getURL() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        return this._filename;
    }

    @Override
    public void setURL(String url) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        if (this._isReadOnly) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.entryReadOnly.ex.txt"));
        }
        this._filename = url;
    }

    @Override
    public String getEncoding() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        return this._encoding;
    }

    @Override
    public void setEncoding(String encoding) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        if (this._isReadOnly) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.entryReadOnly.ex.txt"));
        }
        this._encoding = encoding;
    }

    public boolean isReadOnly() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        return this._isReadOnly;
    }

    @Override
    public String getName() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        return this._filename;
    }

    @Override
    public String getMIMEType() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        return this._mimeType;
    }

    @Override
    public void setMIMEType(String mimeType) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        if (this._isReadOnly) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.entryReadOnly.ex.txt"));
        }
        this._mimeType = mimeType;
    }

    @Override
    public int getRole() throws RemoteException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        return this._role;
    }

    @Override
    public InputStream getInputStream() throws IOException, IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        InputStream stream = null;
        try {
            stream = this.getResource().getContents();
        }
        catch (DAVException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        catch (TransportException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        return new InputStreamAdapter(stream);
    }

    @Override
    public InputStream getInputStream(Object streamId) throws ChainedIOException, IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        InputStream stream = null;
        try {
            stream = this.getResource().getContents();
        }
        catch (DAVException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        catch (TransportException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        return stream;
    }

    @Override
    public RemoteInputStreamInterface getRemoteInputStream(Object streamId) throws ChainedIOException, RemoteException, IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        InputStream stream = null;
        RemoteInputStream remoteInputStream = null;
        try {
            stream = this.getResource().getContents();
            remoteInputStream = new RemoteInputStream(stream);
        }
        catch (DAVException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteStreamIOError.ex.txt"));
        }
        catch (TransportException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteStreamIOError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteStreamIOError.ex.txt"));
        }
        return remoteInputStream;
    }

    @Override
    public Object hasInputStream() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.alreadyClosed.ex.txt"));
        }
        return DUMMY_INPUTSTREAM;
    }

    public String getEntityKey() throws IllegalStateException, RemoteException {
        return this._entityKeyIf.getEntityKey();
    }

    public boolean sameEntity(EntityKeyInterface entity) throws RemoteException {
        return this._entityKeyIf.sameEntity(entity);
    }

    public void setEntityKey(String entityKey) throws RemoteException, IllegalStateException {
        this._entityKeyIf.setEntityKey(entityKey);
    }

    protected void setPosition(int position) {
        this._position = position;
    }

    protected int getPosition() {
        return this._position;
    }
}

