/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.services.TransportException;
import com.sas.services.publish.HTMLEntryInterface;
import com.sas.services.publish.HTMLFileInterface;
import com.sas.services.publish.webdav.DAVEntry;
import com.sas.services.publish.webdav.DAVHTMLFile;
import com.sas.services.publish.webdav.DAVTransport;
import com.sas.services.publish.webdav.RB;
import com.sas.services.webdav.DAVException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;

@SASScope
class DAVHTMLEntry
extends DAVEntry
implements HTMLEntryInterface {
    private HTMLFileInterface _mainFile = null;
    private ArrayList _companionFiles = new ArrayList();

    DAVHTMLEntry(DAVTransport transport, String url, int version) throws RemoteException {
        this(transport, url, version, DAVHTMLEntry.class);
    }

    private DAVHTMLEntry(DAVTransport transport, String url, int version, Class theClass) throws RemoteException {
        super(transport, url, version, theClass);
    }

    @Override
    public HTMLFileInterface getFile() throws IllegalStateException, TransportException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 32) {
            throw new TransportException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        return this._mainFile;
    }

    @Override
    public void setFile(HTMLFileInterface mainFile) throws IllegalArgumentException, IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.entryReadOnly.ex.txt"));
        }
        if (mainFile.getRole() != 7 && mainFile.getRole() != 1) {
            throw new IllegalArgumentException(RB.getStringResource("DAVHTMLEntry.setFileIllegalArgumentException.ex.txt"));
        }
        this._mainFile = mainFile;
    }

    @Override
    public HTMLFileInterface getFile(String uniqueId) throws IllegalStateException, RemoteException, TransportException {
        HTMLFileInterface foundFile = null;
        if (this._mainFile != null && uniqueId.equals(this._mainFile.getEntityKey())) {
            foundFile = this._mainFile;
        }
        if (foundFile == null) {
            for (HTMLFileInterface f : this._companionFiles) {
                if (!uniqueId.equals(f.getEntityKey())) continue;
                foundFile = f;
                break;
            }
        }
        return foundFile;
    }

    @Override
    public HTMLFileInterface[] getCompanionFiles() throws IllegalStateException, RemoteException, TransportException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 32) {
            throw new TransportException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        HTMLFileInterface[] files = new HTMLFileInterface[this._companionFiles.size()];
        Iterator itor = this._companionFiles.iterator();
        int i = 0;
        while (itor.hasNext()) {
            files[i++] = (HTMLFileInterface)itor.next();
        }
        return files;
    }

    @Override
    public void addCompanionFile(HTMLFileInterface companion) throws IllegalArgumentException, IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.entryReadOnly.ex.txt"));
        }
        int ftype = companion.getRole();
        if (ftype == 1 || ftype == 7) {
            throw new IllegalArgumentException(RB.getStringResource("DAVHTMLEntry.addCompIllegalArgumentException.ex.txt"));
        }
        int thisPosition = ((DAVHTMLFile)companion).getPosition();
        boolean inserted = false;
        if (this._companionFiles.size() > 0 && thisPosition != -1) {
            for (int i = 0; i < this._companionFiles.size(); ++i) {
                DAVHTMLFile df = (DAVHTMLFile)this._companionFiles.get(i);
                if (thisPosition >= df.getPosition()) continue;
                this._companionFiles.add(i, companion);
                inserted = true;
                break;
            }
            if (!inserted) {
                this._companionFiles.add(companion);
            }
        } else {
            this._companionFiles.add(companion);
        }
    }

    @Override
    public void setCompanionFiles(HTMLFileInterface[] companions) throws IllegalArgumentException, IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.entryReadOnly.ex.txt"));
        }
        ArrayList<HTMLFileInterface> newList = new ArrayList<HTMLFileInterface>();
        for (int i = 0; i < companions.length; ++i) {
            HTMLFileInterface companion = companions[i];
            if (companion == null) continue;
            int ftype = companion.getRole();
            if (ftype == 1 || ftype == 7) {
                throw new IllegalArgumentException(RB.getStringResource("DAVHTMLEntry.addCompIllegalArgumentException.ex.txt"));
            }
            newList.add(companion);
        }
        this._companionFiles.clear();
        this._companionFiles = newList;
    }

    @Override
    public String getURL() throws IllegalStateException, TransportException {
        String url = null;
        try {
            url = this.getResource().getURL();
        }
        catch (DAVException e) {
            throw new TransportException(RB.getStringResource("DAVCommon.error.ex.txt"));
        }
        catch (RemoteException e) {
            throw new TransportException(RB.getStringResource("DAVCommon.error.ex.txt"));
        }
        return url;
    }
}

