/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.io.ChainedIOException;
import com.sas.io.InputStreamAdapter;
import com.sas.io.RemoteInputStream;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.services.TransportException;
import com.sas.services.publish.BinaryFileEntryInterface;
import com.sas.services.publish.webdav.DAVEntry;
import com.sas.services.publish.webdav.DAVTransport;
import com.sas.services.publish.webdav.RB;
import com.sas.services.webdav.DAVException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;

@SASScope
class DAVBinaryFileEntry
extends DAVEntry
implements BinaryFileEntryInterface {
    private static final ByteArrayInputStream DUMMY_INPUTSTREAM = new ByteArrayInputStream(new byte[1]);
    private String _mimeType = null;
    private String _filename;

    DAVBinaryFileEntry(DAVTransport transport, String url, int version, String filename) throws RemoteException {
        this(transport, url, version, filename, DAVBinaryFileEntry.class);
    }

    private DAVBinaryFileEntry(DAVTransport transport, String url, int version, String filename, Class theClass) throws RemoteException {
        super(transport, url, version, theClass);
        this._filename = filename;
    }

    @Override
    public String getMIMEType() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._mimeType;
    }

    @Override
    public void setMIMEType(String mimeType) throws IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("DAVCommon.entryReadOnly.ex.txt"));
        }
        this._mimeType = mimeType;
    }

    @Override
    public String getName() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._filename;
    }

    @Override
    public InputStream getInputStream() throws IOException, IllegalStateException {
        InputStream stream = null;
        this.throwExceptionIfClosed();
        if (this.getVersion() > 15) {
            throw new ChainedIOException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        try {
            stream = this.getResource().getContents();
        }
        catch (DAVException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        catch (TransportException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        return new InputStreamAdapter(stream);
    }

    @Override
    public InputStream getInputStream(Object streamId) throws UnmarshalException, IOException, RemoteException, IllegalStateException {
        InputStream stream = null;
        this.throwExceptionIfClosed();
        if (this.getVersion() > 15) {
            throw new ChainedIOException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        try {
            stream = this.getResource().getContents();
        }
        catch (DAVException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        catch (TransportException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.streamIOError.ex.txt"));
        }
        return stream;
    }

    @Override
    public RemoteInputStreamInterface getRemoteInputStream(Object streamId) throws IOException, RemoteException, IllegalStateException {
        InputStream stream = null;
        RemoteInputStream remoteInputStream = null;
        this.throwExceptionIfClosed();
        if (this.getVersion() > 15) {
            throw new ChainedIOException(RB.getStringResource("DAVCommon.compat.ex.txt"));
        }
        try {
            stream = this.getResource().getContents();
            remoteInputStream = new RemoteInputStream(stream);
        }
        catch (DAVException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteStreamIOError.ex.txt"));
        }
        catch (TransportException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteStreamIOError.ex.txt"));
        }
        catch (RemoteException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("DAVCommon.remoteStreamIOError.ex.txt"));
        }
        return remoteInputStream;
    }

    @Override
    public Object hasInputStream() throws UnmarshalException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return DUMMY_INPUTSTREAM;
    }
}

