/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.tools;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.deployment.MetadataSourceFactory;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.ServiceLoader;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.DAVRepository;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.ChannelFilter;
import com.sas.services.information.metadata.ChannelInterface;
import com.sas.services.publish.metadata.PackageFilter;
import com.sas.services.publish.metadata.PackageInterface;
import com.sas.services.publish.tools.RB;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import com.sas.text.Message;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class PackageCleanup {
    private static final String DEFAULT_DATE_FORMAT = "yyyyy.MM.dd 'at' hh:mm a";
    private DiscoveryServiceInterface _discoveryService;
    private boolean _isDeleteNoDate = false;
    private String _channelName;
    private Date _userSpecifiedDeleteDate;
    private Date _userSpecifiedAfterDeleteDate;
    private String _userSpecifiedDeleteDateAsStr;
    private String _userSpecifiedAfterDeleteDateAsStr;
    private boolean _prompt = true;
    private boolean _listOption = false;
    private SimpleDateFormat _df;
    private int _persistentStore = -1;
    private static final int PROMPT_ALL = 1;
    private static final int PROMPT_EACH = 2;
    private int _promptType = 1;
    private String _packageName;
    private String _url;
    private String _davUsername;
    private String _davPassword;
    private String _domain;
    private String _metauser;
    private String _metapass;
    private Properties _properties;
    private String _propertiesFilename;
    private Logger _logger = LogManager.getLogger(this.getClass());
    private Logger _serviceLogger = LogManager.getLogger((String)"com.sas.services");

    private void execute(String[] args) {
        String textDate = null;
        String afterTextDate = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-metauser")) {
                if (i + 1 == args.length) {
                    this.exitWithNoValueError(args[i]);
                }
                this._metauser = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-metapass")) {
                if (i + 1 == args.length) {
                    this.exitWithNoValueError(args[i]);
                }
                this._metapass = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-domain")) {
                if (i + 1 == args.length) {
                    this.exitWithNoValueError(args[i]);
                }
                this._domain = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-prop") || args[i].equalsIgnoreCase("-propertiesfile")) {
                if (i + 1 == args.length) {
                    this.exitWithNoValueError(args[i]);
                }
                this._propertiesFilename = args[++i];
                continue;
            }
            if (!args[i].equalsIgnoreCase("-help")) continue;
            this.writeHelp();
            this.exit();
        }
        if (this._metauser == null || this._metapass == null || this._domain == null) {
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.noUser.fmt.txt", (Object)"-metauser", (Object)"-metapass", (Object)"-domain"));
            this.exitWithError();
        }
        try {
            this._properties = this.getProperties();
            this.deployTheServices();
        }
        catch (Exception e) {
            if (this._logger != null) {
                this._logger.fatal((Object)e);
                this._logger.fatal(RB.getStringResource("PackageCleanup.deployError.txt"));
            } else {
                System.err.println(e);
                System.err.println(RB.getStringResource("PackageCleanup.deployError.txt"));
            }
            this.exitWithError();
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-channel") || args[i].equalsIgnoreCase("-ch")) {
                if (i + 1 == args.length) {
                    this.exitWithNoValueError(args[i]);
                }
                this._channelName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-package") || args[i].equalsIgnoreCase("-pkg")) {
                if (i + 1 == args.length) {
                    this.exitWithNoValueError(args[i]);
                }
                this._packageName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-deletionDate") || args[i].equalsIgnoreCase("-d")) {
                if (i + 1 == args.length) {
                    this.exitWithNoValueError(args[i]);
                }
                textDate = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-afterDate") || args[i].equalsIgnoreCase("-a")) {
                if (i + 1 == args.length) {
                    this.exitWithNoValueError(args[i]);
                }
                afterTextDate = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-deletenodate")) {
                this._isDeleteNoDate = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-noprompt")) {
                this._prompt = false;
                this._promptType = 1;
                continue;
            }
            if (args[i].equalsIgnoreCase("-prompteach")) {
                this._prompt = true;
                this._promptType = 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
                Configuration config = lc.getConfiguration();
                LoggerConfig loggerConfig = config.getLoggerConfig(this._serviceLogger.getName());
                loggerConfig.setLevel(Level.DEBUG);
                loggerConfig = config.getLoggerConfig(this._logger.getName());
                loggerConfig.setLevel(Level.DEBUG);
                lc.updateLoggers();
                continue;
            }
            if (args[i].equalsIgnoreCase("-logfile") || args[i].equalsIgnoreCase("-log")) {
                if (i + 1 == args.length) {
                    this.exitWithNoValueError(args[i]);
                }
                String logFileName = args[++i];
                LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
                Configuration config = lc.getConfiguration();
                PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern("%d [%t] %-5p %c - %m%n").build();
                FileAppender fp1 = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName("com.sas.services")).withFileName(logFileName).setLayout((Layout)layout)).setConfiguration(config)).build();
                fp1.start();
                config.addAppender((Appender)fp1);
                lc.getLogger(this._logger.getName()).addAppender(config.getAppender(fp1.getName()));
                lc.getLogger(this._serviceLogger.getName()).addAppender(config.getAppender(fp1.getName()));
                lc.updateLoggers();
                continue;
            }
            if (args[i].equalsIgnoreCase("-list")) {
                this._listOption = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-url")) {
                this._url = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-username")) {
                this._davUsername = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-password")) {
                this._davPassword = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-domain")) {
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-prop") || args[i].equalsIgnoreCase("-propertiesfile")) {
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-date.format")) {
                String format;
                if ((format = args[++i]) == null) {
                    this._logger.info(RB.getStringResource("PackageCleanup.dateFormat.txt"));
                    format = DEFAULT_DATE_FORMAT;
                }
                try {
                    this._df = new SimpleDateFormat(format);
                }
                catch (Exception e) {
                    this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.invDateFormat.fmt.txt", (Object)format, (Object)e));
                    this.exitWithError();
                }
                continue;
            }
            if (args[i].equalsIgnoreCase("-metauser")) {
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-metapass")) {
                ++i;
                continue;
            }
            this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.invalidArg.fmt.txt", (Object)args[i]));
            this.writeHelp();
            this.exitWithError();
        }
        if (this._channelName != null && this._url != null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.chUrlErr.fmt.txt", (Object)"channel", (Object)"url", (Object)"url"));
            } else {
                System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.chUrlErr.fmt.txt", (Object)"channel", (Object)"url", (Object)"url"));
            }
        } else if (this._url != null) {
            this._persistentStore = 3;
        }
        if (null == textDate && null == afterTextDate && !this._listOption) {
            this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.noDate.fmt.txt", (Object)"-d"));
            this.exitWithError();
        }
        if (this._df == null) {
            try {
                this._df = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
            }
            catch (Exception e) {
                this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.invDateFormat.fmt.txt", (Object)DEFAULT_DATE_FORMAT, (Object)e));
                this.exitWithError();
            }
        }
        if (null != textDate) {
            try {
                this._userSpecifiedDeleteDate = this._df.parse(textDate);
                SimpleDateFormat s = new SimpleDateFormat("ddMMMyyyy:hh:mm:ss a");
                this._userSpecifiedDeleteDateAsStr = s.format(this._userSpecifiedDeleteDate);
            }
            catch (Exception e) {
                this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.parseError.fmt.txt", textDate, (Object)e));
                this.exitWithError();
            }
        }
        if (null != afterTextDate) {
            try {
                this._userSpecifiedAfterDeleteDate = this._df.parse(afterTextDate);
                SimpleDateFormat s = new SimpleDateFormat("ddMMMyyyy:hh:mm:ss a");
                this._userSpecifiedAfterDeleteDateAsStr = s.format(this._userSpecifiedAfterDeleteDate);
            }
            catch (Exception e) {
                this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.parseError.fmt.txt", afterTextDate, (Object)e));
                this.exitWithError();
            }
        }
        List<PackageInterface> pkgs = null;
        pkgs = null != this._channelName ? this.getPackagesFromChannel() : (null != this._url ? this.getPackagesFromDAV() : this.getOrphanPackages());
        if (this._listOption) {
            this.listPackages(pkgs);
        } else {
            this.delete(pkgs);
        }
        this.destroyServices();
    }

    private void deployTheServices() throws ServiceException, InitializationException, RemoteException {
        if (!this._properties.containsKey("omr_user")) {
            this._properties.setProperty("omr_user", this._metauser);
        }
        if (!this._properties.containsKey("omr_password")) {
            this._properties.setProperty("omr_password", this._metapass);
        }
        MetadataSourceInterface metadataSource = MetadataSourceFactory.newMetadataSource((Properties)this._properties);
        this._discoveryService = DiscoveryService.defaultInstance();
        ServiceLoader.deployServices((MetadataSourceInterface)metadataSource, (DiscoveryServiceInterface)this._discoveryService);
    }

    private void destroyServices() {
        if (this._discoveryService != null) {
            try {
                this._discoveryService.destroy();
                this._discoveryService = null;
            }
            catch (Exception e) {
                this._discoveryService = null;
            }
        }
    }

    private void delete(List<PackageInterface> pkgList) {
        PackageInterface pkg;
        Iterator<PackageInterface> itor;
        boolean answer;
        ArrayList<PackageInterface> newList = new ArrayList<PackageInterface>(pkgList.size());
        this._logger.info(RB.getStringResource("PackageCleanup.deleteMsg.txt"));
        this.printCommonInfo();
        if (this._prompt && !(answer = this.promptUser(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.proceed.fmt.txt", (Object)RB.getStringResource("PackageCleanup.yesno.txt"))))) {
            this._logger.warn(RB.getStringResource("PackageCleanup.cancel.txt"));
            this.exit();
        }
        if (!(itor = pkgList.iterator()).hasNext()) {
            this._logger.info(RB.getStringResource("PackageCleanup.noMatches.txt"));
            this.exitWithError();
        }
        if (this._prompt && this._promptType == 2) {
            this._logger.info(" ");
        }
        String name = null;
        while (itor.hasNext()) {
            name = null;
            pkg = itor.next();
            try {
                boolean meetsFilteringCriteria;
                if (this._prompt && this._promptType == 2) {
                    String string = name = this._persistentStore == 3 ? pkg.getEntityURL() : pkg.getName() + ".spk";
                }
                if (!(meetsFilteringCriteria = this.evaluatePackage(pkg))) continue;
                if (this._prompt && this._promptType == 2) {
                    this._logger.info(" ");
                    this.printPkgInfo(pkg, name);
                    boolean answer2 = this.promptUser(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.deleteThisPkg.fmt.txt", (Object)RB.getStringResource("PackageCleanup.yesno.txt")));
                    if (!answer2) continue;
                    newList.add(pkg);
                    continue;
                }
                newList.add(pkg);
            }
            catch (RemoteException e) {
                if (name == null) {
                    this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgError.fmt.txt", (Object)e));
                } else {
                    this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgErrorWithName.fmt.txt", name, (Object)e));
                }
                this.exitWithError();
            }
            catch (ServiceException e) {
                if (name == null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgErrorCont.fmt.txt", (Object)((Object)e)));
                    continue;
                }
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgErrorContWithName.fmt.txt", name, (Object)((Object)e)));
            }
        }
        if (newList.size() == 0) {
            this._logger.info(RB.getStringResource("PackageCleanup.noMatches.txt"));
            this.exit();
        }
        itor = newList.iterator();
        this._logger.info(" ");
        this._logger.info(" ");
        this._logger.info(RB.getStringResource("PackageCleanup.deleted.txt"));
        this._logger.info(" ");
        while (itor.hasNext()) {
            try {
                name = null;
                pkg = itor.next();
                name = this._persistentStore == 3 ? pkg.getEntityURL() : pkg.getName() + ".spk";
                this.printPkgInfo(pkg, name);
            }
            catch (RemoteException e) {
                if (name == null) {
                    this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgError.fmt.txt", (Object)e));
                } else {
                    this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgErrorWithName.fmt.txt", (Object)name, (Object)e));
                }
                this.exitWithError();
            }
            catch (ServiceException e) {
                if (name == null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgErrorCont.fmt.txt", (Object)((Object)e)));
                    continue;
                }
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgErrorContWithName.fmt.txt", (Object)name, (Object)((Object)e)));
            }
        }
        if (this._prompt) {
            try {
                this._logger.info(" ");
                boolean answer3 = this.promptUser(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.proceedWithDel.fmt.txt", (Object)RB.getStringResource("PackageCleanup.yesno.txt")));
                if (!answer3) {
                    this._logger.info(RB.getStringResource("PackageCleanup.cancel.txt"));
                    this.exit();
                }
            }
            catch (Exception e) {
                this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.badChar.fmt.txt", (Object)e));
                this.exit();
            }
        }
        itor = newList.iterator();
        if (this._persistentStore == 3) {
            String url = null;
            while (itor.hasNext()) {
                PackageInterface pkg2 = itor.next();
                try {
                    url = pkg2.getEntityURL();
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkg.fmt.txt", (Object)url));
                    pkg2.delete();
                    pkg2 = null;
                }
                catch (ServiceException e) {
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgDelError.fmt.txt", (Object)url, (Object)((Object)e)));
                }
                catch (RemoteException e) {
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgDelError.fmt.txt", (Object)url, (Object)e));
                }
            }
        } else {
            name = null;
            while (itor.hasNext()) {
                PackageInterface pkg3 = itor.next();
                try {
                    String key = pkg3.getEntityKey();
                    name = pkg3.getName() + ".spk";
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkg.fmt.txt", (Object)name));
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.metadata.fmt.txt", (Object)key));
                    pkg3.delete();
                }
                catch (ServiceException e) {
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgDelError.fmt.txt", (Object)name, (Object)((Object)e)));
                }
                catch (RemoteException e) {
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgDelError.fmt.txt", (Object)name, (Object)e));
                }
            }
        }
        this._logger.info(RB.getStringResource("PackageCleanup.complete.txt"));
        if (newList != null) {
            newList.clear();
            newList = null;
        }
    }

    private UserContextInterface initUser() {
        UserContextInterface uc = null;
        try {
            Class[] desiredUserCapabilities = new Class[]{UserServiceInterface.class};
            UserServiceInterface userService = (UserServiceInterface)this._discoveryService.findService(new ServiceTemplate(desiredUserCapabilities, null));
            uc = userService.newUser(this._metauser, this._metapass, this._domain);
        }
        catch (UserInitializationException e) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.userInitWarn.fmt.txt", (Object)this._metauser, (Object)((Object)e)));
            uc = e.getUser();
        }
        catch (Exception e) {
            this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.userInitError.fmt.txt", (Object)this._metauser, (Object)e));
            this.exitWithError();
        }
        return uc;
    }

    private void printPkgInfo(PackageInterface pkg, String name) throws RemoteException, ServiceException {
        Calendar calendar;
        SimpleDateFormat s = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss");
        String desc = null;
        String formattedCreationDate = null;
        String formattedExpirationDate = null;
        if (name == null) {
            name = RB.getStringResource("PackageCleanup.notSpec.txt");
        }
        if ((desc = pkg.getDescription()) == null) {
            desc = RB.getStringResource("PackageCleanup.notSpec.txt");
        }
        formattedCreationDate = RB.getStringResource("PackageCleanup.notSpec.txt");
        formattedExpirationDate = RB.getStringResource("PackageCleanup.notSpec.txt");
        long l = pkg.getCreationDate();
        if (l != -1L) {
            calendar = Calendar.getInstance();
            calendar.setTime(new Date(pkg.getCreationDate()));
            formattedCreationDate = s.format(calendar.getTime());
        }
        if ((l = pkg.getExpirationDate()) != -1L) {
            calendar = Calendar.getInstance();
            calendar.setTime(new Date(pkg.getExpirationDate()));
            formattedExpirationDate = s.format(calendar.getTime());
        }
        this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgInfo.fmt.txt", (Object)name, (Object)desc, (Object)formattedCreationDate, (Object)formattedExpirationDate));
    }

    private ChannelInterface findChannel(UserContextInterface uc) {
        ChannelInterface channel = null;
        try {
            Class[] desiredInfoCapabilities = new Class[]{InformationServiceInterface.class};
            InformationServiceInterface infoService = (InformationServiceInterface)this._discoveryService.findService(new ServiceTemplate(desiredInfoCapabilities, null));
            if (infoService == null) {
                this._logger.fatal(RB.getStringResource("PackageCleanup.infoinit.txt"));
                this.exitWithError();
            }
            ChannelFilter filter = new ChannelFilter();
            filter.setName(this._channelName);
            Iterator it = infoService.search(uc, (FilterInterface)filter).iterator();
            if (it.hasNext()) {
                channel = (ChannelInterface)it.next();
            }
            if (null == channel) {
                this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.noChannel.fmt.txt", (Object)this._channelName));
                this.exitWithError();
            }
            this._persistentStore = channel.getDeliveryTransport();
        }
        catch (Exception e) {
            this._logger.fatal((Object)e);
            this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.channelError.fmt.txt", (Object)this._channelName));
            this.exitWithError();
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean promptUser(String prompt) {
        BufferedReader in = null;
        boolean answer = true;
        try {
            this._logger.info(prompt);
            in = new BufferedReader(new InputStreamReader(System.in));
            boolean done = false;
            while (!done) {
                String response = in.readLine();
                if (response.length() > 0) {
                    if (response.charAt(0) == 'n' || response.charAt(0) == 'N') {
                        answer = false;
                        done = true;
                        continue;
                    }
                    if (response.charAt(0) == 'y' || response.charAt(0) == 'Y') {
                        answer = true;
                        done = true;
                        continue;
                    }
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.invalidChar.fmt.txt", (Object)"y", (Object)"n"));
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.proceed.fmt.txt", (Object)RB.getStringResource("PackageCleanup.yesno.txt")));
                    continue;
                }
                System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.invalidChar.fmt.txt", (Object)"y", (Object)"n"));
                System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.proceed.fmt.txt", (Object)RB.getStringResource("PackageCleanup.yesno.txt")));
            }
        }
        catch (Exception e) {
            System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.badChar.fmt.txt", (Object)e));
            this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.badChar.fmt.txt", (Object)e));
            this.exitWithError();
        }
        return answer;
    }

    private void writeHelp() {
        System.out.println(RB.getStringResource("PackageCleanup.help1.txt"));
        System.out.println(RB.getStringResource("PackageCleanup.help1More.txt"));
        System.out.println(RB.getStringResource("PackageCleanup.help2.txt"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpCmd.fmt.txt", (Object)"java", (Object)PackageCleanup.class.getName()));
        System.out.println(RB.getStringResource("PackageCleanup.help4.txt"));
        System.out.println(RB.getStringResource("PackageCleanup.help5.txt"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpChannel.fmt.txt", (Object)"-channel", (Object)"-ch"));
        System.out.println(RB.getStringResource("PackageCleanup.help7.txt"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpDelDate.fmt.txt", (Object)"-deletionDate", (Object)"-d"));
        System.out.println(RB.getStringResource("PackageCleanup.help9.txt"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.help10.fmt.txt", (Object)"java.text.SimpleDateFormat"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpList.fmt.txt", (Object)"-list"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpMetauser.fmt.txt", (Object)"-metauser"));
        System.out.println(RB.getStringResource("PackageCleanup.helpmetauser.txt"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpMetapass.fmt.txt", (Object)"-metapass"));
        System.out.println(RB.getStringResource("PackageCleanup.helpmetapass.txt"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpDomain.fmt.txt", (Object)"-domain"));
        System.out.println(RB.getStringResource("PackageCleanup.helpdomain.txt"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgHelp.fmt.txt", (Object)"-package", (Object)"-pkg"));
        System.out.println(RB.getStringResource("PackageCleanup.pkgHelp.txt"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpUrl.fmt.txt", (Object)"-url"));
        System.out.println(RB.getStringResource("PackageCleanup.helpUrl2.txt"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpUsername.fmt.txt", (Object)"-username"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpUsername2.fmt.txt", (Object)"url"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpPassword.fmt.txt", (Object)"-password"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpPassword2.fmt.txt", (Object)"url"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpPropFile.fmt.txt", (Object)"-propertiesfile", (Object)"-prop"));
        System.out.println(RB.getStringResource("PackageCleanup.help12.txt"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpLogFile.fmt.txt", (Object)"-logfile", (Object)"-log"));
        System.out.println(RB.getStringResource("PackageCleanup.help14.txt"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpNoPrompt.fmt.txt", (Object)"-noprompt"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpDelNoDate.fmt.txt", (Object)"-deletenodate"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.prompt.fmt.txt", (Object)"-prompteach"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.debug.fmt.txt", (Object)"-debug"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.helpAfterDelDate.fmt.txt", (Object)"-afterDate", (Object)"-a"));
        System.out.println(RB.getStringResource("PackageCleanup.helpAfterDelDateDesc.txt"));
        System.out.println(RB.getStringResource("PackageCleanup.help9.txt"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.help10.fmt.txt", (Object)"java.text.SimpleDateFormat"));
        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.help.fmt.txt", (Object)"-help"));
    }

    private void exitWithNoValueError(String arg) {
        this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.noValue.fmt.txt", (Object)arg));
        this.exitWithError();
    }

    private void exitWithError() {
        this.destroyServices();
        System.exit(1);
    }

    private void exit() {
        this.destroyServices();
        System.exit(0);
    }

    private void listPackages(List<PackageInterface> pkgList) {
        this._logger.info(RB.getStringResource("PackageCleanup.listGeneralMsg.txt"));
        this._logger.info(RB.getStringResource("PackageCleanup.listMsg.txt"));
        this.printCommonInfo();
        if (0 == pkgList.size()) {
            this._logger.info(RB.getStringResource("PackageCleanup.noMatchesList.txt"));
            this.exit();
        }
        Iterator<PackageInterface> itor = pkgList.iterator();
        this._logger.info(" ");
        while (itor.hasNext()) {
            String pkgname = null;
            try {
                PackageInterface pkg = itor.next();
                pkgname = this._persistentStore == 3 ? pkg.getEntityURL() : pkg.getName() + ".spk";
                this.printPkgInfo(pkg, pkgname);
            }
            catch (RemoteException e) {
                if (pkgname == null) {
                    this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgError.fmt.txt", (Object)e));
                } else {
                    this._logger.fatal(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgErrorWithName.fmt.txt", pkgname, (Object)e));
                }
                this.exitWithError();
            }
            catch (ServiceException e) {
                if (pkgname == null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgErrorCont.fmt.txt", (Object)((Object)e)));
                    continue;
                }
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgErrorContWithName.fmt.txt", pkgname, (Object)((Object)e)));
            }
        }
    }

    private void printCommonInfo() {
        if (this._channelName != null) {
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.definedToChannel.fmt.txt", (Object)this._channelName));
        } else if (this._url != null) {
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.urlPkgs.fmt.txt", (Object)this._url));
        } else {
            this._logger.info(RB.getStringResource("PackageCleanup.notChannel.txt"));
        }
        if (null == this._userSpecifiedDeleteDate && null == this._userSpecifiedAfterDeleteDate) {
            if (this._isDeleteNoDate) {
                this._logger.info(RB.getStringResource("PackageCleanup.anyDates.txt"));
            } else {
                this._logger.info(RB.getStringResource("PackageCleanup.anyExpDate.txt"));
            }
        } else if (null != this._userSpecifiedDeleteDate && null != this._userSpecifiedAfterDeleteDate) {
            if (this._isDeleteNoDate) {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.allDates.fmt.txt", (Object)this._userSpecifiedAfterDeleteDateAsStr, (Object)this._userSpecifiedDeleteDateAsStr));
            } else {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.beforeAndAfterExpDate.fmt.txt", (Object)this._userSpecifiedAfterDeleteDateAsStr, (Object)this._userSpecifiedDeleteDateAsStr));
            }
        } else if (null != this._userSpecifiedDeleteDate) {
            if (this._isDeleteNoDate) {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.bothDates.fmt.txt", (Object)this._userSpecifiedDeleteDateAsStr));
            } else {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.beforeExpDate.fmt.txt", (Object)this._userSpecifiedDeleteDateAsStr));
            }
        } else if (null != this._userSpecifiedAfterDeleteDate) {
            if (this._isDeleteNoDate) {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.afterBothDates.fmt.txt", (Object)this._userSpecifiedAfterDeleteDateAsStr));
            } else {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.afterExpDate.fmt.txt", (Object)this._userSpecifiedAfterDeleteDateAsStr));
            }
        }
        if (null != this._packageName) {
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.infoPkgName.fmt.txt", (Object)this._packageName));
        }
    }

    private List<PackageInterface> getOrphanPackages() {
        ArrayList<PackageInterface> pkgList = new ArrayList<PackageInterface>();
        UserContextInterface uc = this.initUser();
        try {
            RepositoryInterface repos = (RepositoryInterface)uc.getRepositories().get(0);
            PackageFilter filter = new PackageFilter();
            if (this._packageName != null) {
                if (this._packageName.endsWith(".spk")) {
                    String tmpStr = this._packageName;
                    filter.setName(tmpStr.substring(0, tmpStr.length() - 4));
                } else {
                    filter.setName(this._packageName);
                }
            }
            Iterator itor = repos.search((FilterInterface)filter).iterator();
            while (itor.hasNext()) {
                PackageInterface pkg = null;
                try {
                    pkg = (PackageInterface)itor.next();
                    ChannelInterface ch = pkg.getChannel();
                    if (ch != null && ch.getRepositoryEntity() != null || !this.evaluatePackage(pkg)) continue;
                    pkgList.add(pkg);
                }
                catch (RemoteException e) {
                    this._logger.fatal(RB.getStringResource("PackageCleanup.pkgListError.txt"), (Throwable)e);
                    this.exitWithError();
                }
                catch (ServiceException e) {
                    String pkgname;
                    String string = pkgname = this._persistentStore == 3 ? pkg.getEntityURL() : pkg.getName() + ".spk";
                    if (pkgname == null) {
                        this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgErrorCont.fmt.txt", (Object)((Object)e)));
                        continue;
                    }
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgErrorContWithName.fmt.txt", (Object)pkgname, (Object)((Object)e)));
                }
            }
        }
        catch (RemoteException e) {
            this._logger.fatal(RB.getStringResource("PackageCleanup.pkgListError.txt"), (Throwable)e);
            this.exitWithError();
        }
        catch (ServiceException e) {
            this._logger.fatal(RB.getStringResource("PackageCleanup.pkgListError.txt"), (Throwable)e);
            this.exitWithError();
        }
        return pkgList;
    }

    private List<PackageInterface> getPackagesFromChannel() {
        UserContextInterface uc = this.initUser();
        ChannelInterface channel = null;
        ArrayList<PackageInterface> pkgList = new ArrayList<PackageInterface>();
        Iterator itor = null;
        channel = this.findChannel(uc);
        try {
            itor = channel.packageList().iterator();
        }
        catch (ServiceException e) {
            this._logger.fatal(RB.getStringResource("PackageCleanup.pkgListError.txt"), (Throwable)e);
            this.exitWithError();
        }
        catch (RemoteException e) {
            this._logger.fatal(RB.getStringResource("PackageCleanup.pkgListError.txt"), (Throwable)e);
            this.exitWithError();
        }
        while (itor.hasNext()) {
            PackageInterface pkg = null;
            try {
                pkg = (PackageInterface)itor.next();
            }
            catch (ClassCastException e) {
                continue;
            }
            String pkgname = null;
            try {
                String name;
                String string = pkgname = this._persistentStore == 3 ? pkg.getEntityURL() : pkg.getName() + ".spk";
                if (this._packageName != null && (this._persistentStore != 3 ? !this._packageName.equals(pkgname) : !this._packageName.equals(name = pkg.getName()) && !this._packageName.equals(pkgname))) continue;
                if (!this.evaluatePackage(pkg)) continue;
                pkgList.add(pkg);
            }
            catch (RemoteException e) {
                this._logger.fatal(RB.getStringResource("PackageCleanup.pkgListError.txt"), (Throwable)e);
                this.exitWithError();
            }
            catch (ServiceException e) {
                if (null == pkgname) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgErrorCont.fmt.txt", (Object)((Object)e)));
                    continue;
                }
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PackageCleanup.pkgErrorContWithName.fmt.txt", (Object)pkgname, (Object)((Object)e)));
            }
        }
        return pkgList;
    }

    private List<PackageInterface> getPackagesFromDAV() {
        UserContextInterface uc = this.initUser();
        ArrayList<PackageInterface> pkgList = new ArrayList<PackageInterface>();
        DAVRepository repos = null;
        String relpath = null;
        URL url = null;
        try {
            repos = new DAVRepository();
            url = new URL(this._url);
            relpath = url.getPath();
            boolean b = repos.connect(url.getHost(), url.getPort(), this._davUsername, this._davPassword, relpath);
            if (!b) {
                this._logger.fatal(RB.getStringResource("PackageCleanup.connectFailure.txt"));
                this.exitWithError();
            }
            repos.setUserContext(uc);
            uc.addRepository((Object)repos);
            PackageFilter filter = new PackageFilter();
            filter.setDAVScope(1);
            filter.setDAVBase("");
            for (Object o : repos.search((FilterInterface)filter)) {
                String name;
                if (!(o instanceof PackageInterface)) continue;
                PackageInterface pkg = (PackageInterface)o;
                String pkgname = pkg.getEntityURL();
                if (null != this._packageName && !this._packageName.equals(name = pkg.getName()) && !this._packageName.equals(pkgname) || !this.evaluatePackage(pkg)) continue;
                pkgList.add(pkg);
            }
        }
        catch (MalformedURLException e) {
            this._logger.fatal(RB.getStringResource("PackageCleanup.urlError.txt"), (Throwable)e);
            this.exitWithError();
        }
        catch (Exception e) {
            this._logger.fatal(RB.getStringResource("PackageCleanup.davPkgListError.txt"), (Throwable)e);
            this.exitWithError();
        }
        return pkgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties() throws IOException {
        FileInputStream fis = null;
        Properties properties = null;
        String name = null;
        try {
            name = this._propertiesFilename == null ? "./jps.properties" : this._propertiesFilename;
            fis = new FileInputStream(name);
            properties = new Properties();
            if (name.endsWith(".xml")) {
                properties.loadFromXML(fis);
            } else {
                properties.load(fis);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
                fis = null;
            }
        }
        return properties;
    }

    private boolean evaluatePackage(PackageInterface pkg) throws RemoteException, ServiceException {
        boolean meetsCriteria = false;
        long pkgExpDateL = pkg.getExpirationDate();
        if (-1L == pkgExpDateL) {
            if (this._isDeleteNoDate) {
                meetsCriteria = true;
            }
        } else if (null == this._userSpecifiedDeleteDate && null == this._userSpecifiedAfterDeleteDate) {
            meetsCriteria = true;
        } else if (null != this._userSpecifiedDeleteDate) {
            Date thePkgExpDate = new Date(pkgExpDateL);
            if (null == this._userSpecifiedAfterDeleteDate) {
                if (thePkgExpDate.before(this._userSpecifiedDeleteDate)) {
                    meetsCriteria = true;
                }
            } else if (thePkgExpDate.before(this._userSpecifiedDeleteDate) && thePkgExpDate.after(this._userSpecifiedAfterDeleteDate)) {
                meetsCriteria = true;
            }
        } else {
            Date thePkgExpDate = new Date(pkgExpDateL);
            if (thePkgExpDate.after(this._userSpecifiedAfterDeleteDate)) {
                meetsCriteria = true;
            }
        }
        return meetsCriteria;
    }

    public static void main(String[] args) {
        PackageCleanup pc = new PackageCleanup();
        pc.execute(args);
        System.exit(0);
    }
}

