/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.requester;

import com.sas.codepolicy.SASScope;
import com.sas.io.ChainedIOException;
import com.sas.io.InputStreamAdapter;
import com.sas.io.ReaderAdapter;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.io.RemoteReaderInterface;
import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IBinaryStreamHelper;
import com.sas.iom.SAS.IResultPackageViewerEntry;
import com.sas.iom.SAS.IResultPackageViewerEntryHelper;
import com.sas.iom.SAS.ITextStream;
import com.sas.iom.SAS.ITextStreamHelper;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.services.TransportException;
import com.sas.services.publish.ViewerEntryInterface;
import com.sas.services.publish.requester.RB;
import com.sas.services.publish.requester.RequesterAbstractEntry;
import com.sas.services.publish.requester.RequesterBinaryFileSupport;
import com.sas.services.publish.requester.RequesterIOMInputStream;
import com.sas.services.publish.requester.RequesterIOMReader;
import com.sas.services.publish.requester.RequesterTextFileSupport;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

@SASScope
class RequesterViewerEntry
extends RequesterAbstractEntry
implements ViewerEntryInterface {
    static ByteArrayInputStream dummyInputStream = new ByteArrayInputStream(new byte[1]);
    static CharArrayReader dummyReader = new CharArrayReader(new char[1]);
    private IResultPackageViewerEntry _iomEntry;
    private String _MIMEType;
    private String _encoding;
    private boolean _hasViewerType;
    private boolean _hasStream;
    private int _viewerType;
    ITextStream _tStream;
    IBinaryStream _bStream;

    RequesterViewerEntry(Object iomEntry) throws RemoteException {
        super(RequesterViewerEntry.class);
        this._iomEntry = IResultPackageViewerEntryHelper.narrow((Object)iomEntry);
    }

    @Override
    void subSetNameValuePairs() throws TransportException, RemoteException {
        try {
            VariableArray2dOfStringHolder holder = new VariableArray2dOfStringHolder();
            this._iomEntry.GetNameValuePairs(holder);
            this.setNameValuePairs(holder);
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new TransportException((Throwable)e, msg);
        }
    }

    @Override
    public String getEncoding() throws TransportException {
        this.throwExceptionIfClosed();
        if (this._encoding == null) {
            try {
                this._encoding = this._iomEntry.MIMEType();
            }
            catch (SystemException e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
                throw new TransportException((Throwable)e, msg);
            }
        }
        return this._encoding;
    }

    @Override
    public void setEncoding(String encoding) throws IllegalStateException {
        this.throwExceptionIfClosed();
        throw new IllegalStateException(RB.getStringResource("COM.browseOnly.ex.txt"));
    }

    @Override
    public String getName() {
        this.throwExceptionIfClosed();
        return null;
    }

    @Override
    public int getViewerType() throws TransportException {
        this.throwExceptionIfClosed();
        if (!this._hasViewerType) {
            Object fo;
            try {
                fo = this._iomEntry.OpenViewer(4096, "");
            }
            catch (GenericError e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
                throw new TransportException((Throwable)e, msg);
            }
            this._tStream = ITextStreamHelper.narrow((Object)fo);
            if (this._tStream != null) {
                this._viewerType = 2;
            } else {
                this._bStream = IBinaryStreamHelper.narrow((Object)fo);
                if (this._bStream == null) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (java.lang.Object)"Not HTML or TEXT.");
                    throw new IllegalStateException(msg);
                }
                this._viewerType = 1;
            }
            this._hasViewerType = true;
            this._hasStream = true;
        }
        return this._viewerType;
    }

    @Override
    public java.lang.Object hasInputStream() {
        return dummyInputStream;
    }

    @Override
    public InputStream getInputStream(java.lang.Object streamID) throws ChainedIOException {
        this.throwExceptionIfClosed();
        try {
            if (this.getViewerType() == 2) {
                throw new IllegalStateException(RB.getStringResource("RVE.noStr.ex.fmt.txt"));
            }
        }
        catch (TransportException e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.recast.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
        if (this._hasStream) {
            this._hasStream = false;
            return new RequesterIOMInputStream(this._bStream);
        }
        try {
            Object fo = this._iomEntry.OpenViewer(0, "");
            IBinaryStream inStream = IBinaryStreamHelper.narrow((Object)fo);
            return new RequesterIOMInputStream(inStream);
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.recast.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
    }

    @Override
    public RemoteInputStreamInterface getRemoteInputStream(java.lang.Object streamID) throws IOException, RemoteException {
        this.throwExceptionIfClosed();
        return RequesterBinaryFileSupport.getRemoteInputStream(this);
    }

    @Override
    public InputStream getInputStream() throws ChainedIOException, RemoteException {
        this.throwExceptionIfClosed();
        try {
            if (this.getViewerType() == 2) {
                throw new IllegalStateException(RB.getStringResource("RVE.noStr.ex.fmt.txt"));
            }
        }
        catch (TransportException e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.recast.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
        if (this._hasStream) {
            this._hasStream = false;
            return new InputStreamAdapter((InputStream)new RequesterIOMInputStream(this._bStream));
        }
        try {
            Object fo = this._iomEntry.OpenViewer(0, "");
            IBinaryStream inStream = IBinaryStreamHelper.narrow((Object)fo);
            return new InputStreamAdapter((InputStream)new RequesterIOMInputStream(inStream));
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.recast.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
    }

    @Override
    public java.lang.Object hasReader() {
        return dummyReader;
    }

    @Override
    public Reader getReader(java.lang.Object streamID) throws ChainedIOException {
        this.throwExceptionIfClosed();
        try {
            if (this.getViewerType() == 1) {
                throw new IllegalStateException(RB.getStringResource("RVE.noRdr.ex.fmt.txt"));
            }
        }
        catch (TransportException e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.recast.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
        if (this._hasStream) {
            this._hasStream = false;
            return new RequesterIOMReader(this._tStream);
        }
        try {
            Object fo = this._iomEntry.OpenViewer(4096, "");
            ITextStream inStream = ITextStreamHelper.narrow((Object)fo);
            return new RequesterIOMReader(inStream);
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.recast.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
    }

    @Override
    public RemoteReaderInterface getRemoteReader(java.lang.Object streamID) throws IOException, RemoteException {
        this.throwExceptionIfClosed();
        return RequesterTextFileSupport.getRemoteReader(this);
    }

    @Override
    public Reader getReader() throws ChainedIOException, RemoteException {
        this.throwExceptionIfClosed();
        try {
            if (this.getViewerType() == 1) {
                throw new IllegalStateException(RB.getStringResource("RVE.noRdr.ex.fmt.txt"));
            }
        }
        catch (TransportException e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.recast.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
        if (this._hasStream) {
            this._hasStream = false;
            RequesterIOMReader r = new RequesterIOMReader(this._tStream);
            return new ReaderAdapter((Reader)r);
        }
        try {
            Object fo = this._iomEntry.OpenViewer(4096, "");
            ITextStream inStream = ITextStreamHelper.narrow((Object)fo);
            RequesterIOMReader r = new RequesterIOMReader(inStream);
            return new ReaderAdapter((Reader)r);
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.recast.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
    }

    @Override
    public String getMIMEType() throws TransportException {
        this.throwExceptionIfClosed();
        if (this._MIMEType == null) {
            try {
                this._MIMEType = this._iomEntry.MIMEType();
            }
            catch (SystemException e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
                throw new TransportException((Throwable)e, msg);
            }
        }
        return this._MIMEType;
    }

    @Override
    public void setMIMEType(String mimeType) throws IllegalStateException {
        this.throwExceptionIfClosed();
        throw new IllegalStateException(RB.getStringResource("COM.browseOnly.ex.txt"));
    }

    @Override
    protected void closeEntry() {
        super.closeEntry();
        this._iomEntry = null;
        this._MIMEType = null;
        this._encoding = null;
    }
}

