/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.requester;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.ITextStream;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.services.publish.requester.RB;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import java.io.IOException;
import java.io.Reader;
import java.security.AccessController;
import java.util.ResourceBundle;

@SASScope
class RequesterIOMReader
extends Reader {
    private int NUMBER_OF_LINES_TO_READ = 20;
    private int _truncationLength;
    private char[] buffer;
    private int boffset;
    private int blen;
    private boolean eof;
    private ITextStream _inStream;
    private String _newLine;

    public RequesterIOMReader(ITextStream inStream) {
        this._inStream = inStream;
        this._truncationLength = this._inStream.TruncationLength();
        this.boffset = 0;
        this.blen = 0;
        this.eof = false;
        this.buffer = null;
        this._newLine = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }

    @Override
    public long skip(long n) throws IOException {
        return this.read(null, 0, (int)n);
    }

    @Override
    public int read() throws IOException {
        char[] b = new char[1];
        if (this.read(b, 0, 1) > 0) {
            return b[0] & 0xFFFF;
        }
        return -1;
    }

    @Override
    public int read(char[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(char[] b, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        int i = 0;
        for (i = 0; i < len; ++i) {
            if (this.boffset >= this.blen) {
                this.getMore();
                if (this.blen <= 0) {
                    this.eof = true;
                    return i;
                }
            }
            if (b != null) {
                b[i + off] = this.buffer[this.boffset];
            }
            ++this.boffset;
        }
        return i;
    }

    public int available() throws IOException {
        if (this.buffer == null) {
            this.getMore();
        }
        return this.blen - this.boffset;
    }

    @Override
    public void close() throws IOException {
        try {
            this._inStream.Close();
        }
        catch (GenericError e) {
            throw new IOException(e.getMessage());
        }
    }

    private void getMore() throws IOException {
        StringBuffer strBuf = new StringBuffer();
        LongSeqHolder truncLines = new LongSeqHolder();
        StringSeqHolder textLines = new StringSeqHolder();
        if (this.eof) {
            this.blen = 0;
            this.boffset = 0;
            return;
        }
        try {
            this._inStream.ReadLines(this.NUMBER_OF_LINES_TO_READ, truncLines, textLines);
        }
        catch (GenericError e) {
            throw new IOException(e.getMessage());
        }
        if (truncLines.value.length > 0) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"RIR.longLn.ex.fmt.txt", (Object)this._truncationLength);
            throw new IOException(msg);
        }
        String[] lines = textLines.value;
        for (int i = 0; i < lines.length; ++i) {
            strBuf.append(lines[i]);
            strBuf.append(this._newLine);
        }
        this.blen = strBuf.length();
        this.buffer = new char[this.blen];
        strBuf.getChars(0, this.blen, this.buffer, 0);
        this.boffset = 0;
    }
}

