/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.requester;

import com.sas.codepolicy.SASScope;
import com.sas.entities.EntityKeyInterface;
import com.sas.io.ChainedIOException;
import com.sas.io.InputStreamAdapter;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IResultPackageHTMLEntry;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.DefaultEntityKeyImpl;
import com.sas.services.publish.HTMLFileInterface;
import com.sas.services.publish.requester.RB;
import com.sas.services.publish.requester.RequesterBinaryFileSupport;
import com.sas.services.publish.requester.RequesterIOMInputStream;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ResourceBundle;

@SASScope
class RequesterHTMLFile
extends UnicastRemoteObject
implements HTMLFileInterface {
    static ByteArrayInputStream dummyInputStream = new ByteArrayInputStream(new byte[1]);
    private String _encoding;
    private int _role;
    private String _url;
    private int _index;
    private boolean _closed;
    IResultPackageHTMLEntry _iomEntry;
    private EntityKeyInterface _entityKeyIf = new DefaultEntityKeyImpl();

    RequesterHTMLFile(IResultPackageHTMLEntry iomEntry, int role, String url, String encoding, int index) throws RemoteException {
        this(iomEntry, role, url, encoding, index, RequesterHTMLFile.class);
    }

    private RequesterHTMLFile(IResultPackageHTMLEntry iomEntry, int role, String url, String encoding, int index, Class theClass) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, theClass), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(theClass), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(theClass));
        this._encoding = encoding;
        this._role = role;
        this._url = url;
        this._index = index;
        this._iomEntry = iomEntry;
    }

    @Override
    public String getEncoding() {
        if (this._closed) {
            throw new IllegalStateException(RB.getStringResource("COM.binClosd.ex.txt"));
        }
        return this._encoding;
    }

    @Override
    public void setEncoding(String encoding) throws IllegalStateException {
        if (this._closed) {
            throw new IllegalStateException(RB.getStringResource("COM.binClosd.ex.txt"));
        }
        throw new IllegalStateException(RB.getStringResource("COM.browseOnly.ex.txt"));
    }

    @Override
    public String getURL() {
        if (this._closed) {
            throw new IllegalStateException(RB.getStringResource("COM.binClosd.ex.txt"));
        }
        return this._url;
    }

    @Override
    public void setURL(String url) throws IllegalStateException {
        if (this._closed) {
            throw new IllegalStateException(RB.getStringResource("COM.binClosd.ex.txt"));
        }
        throw new IllegalStateException(RB.getStringResource("COM.browseOnly.ex.txt"));
    }

    @Override
    public String getName() {
        if (this._closed) {
            throw new IllegalStateException(RB.getStringResource("COM.binClosd.ex.txt"));
        }
        return null;
    }

    @Override
    public int getRole() {
        if (this._closed) {
            throw new IllegalStateException(RB.getStringResource("COM.binClosd.ex.txt"));
        }
        return this._role;
    }

    @Override
    public String getMIMEType() {
        if (this._closed) {
            throw new IllegalStateException(RB.getStringResource("COM.binClosd.ex.txt"));
        }
        return this._role != 6 ? "text/html" : null;
    }

    @Override
    public void setMIMEType(String mimeType) throws IllegalStateException {
        if (this._closed) {
            throw new IllegalStateException(RB.getStringResource("COM.binClosd.ex.txt"));
        }
        throw new IllegalStateException(RB.getStringResource("COM.browseOnly.ex.txt"));
    }

    @Override
    public Object hasInputStream() {
        return dummyInputStream;
    }

    @Override
    public InputStream getInputStream(Object streamID) throws IOException {
        IBinaryStream ibs;
        if (this._closed) {
            throw new IllegalStateException(RB.getStringResource("COM.binClosd.ex.txt"));
        }
        try {
            switch (this._role) {
                case 7: {
                    ibs = this._iomEntry.OpenFrame(StreamOpenMode.StreamOpenModeForReading, "");
                    break;
                }
                case 1: {
                    ibs = this._iomEntry.OpenBodyItem(0, StreamOpenMode.StreamOpenModeForReading, "");
                    break;
                }
                case 2: {
                    ibs = this._iomEntry.OpenBodyItem(this._index, StreamOpenMode.StreamOpenModeForReading, "");
                    break;
                }
                case 4: {
                    ibs = this._iomEntry.OpenContents(StreamOpenMode.StreamOpenModeForReading, "");
                    break;
                }
                case 6: {
                    ibs = this._iomEntry.OpenCompanion(this._index, StreamOpenMode.StreamOpenModeForReading, "");
                    break;
                }
                case 5: {
                    ibs = this._iomEntry.OpenPage(StreamOpenMode.StreamOpenModeForReading, "");
                    break;
                }
                default: {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (Object)Integer.toString(this._role));
                    throw new IllegalStateException(msg);
                }
            }
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
        return new RequesterIOMInputStream(ibs);
    }

    @Override
    public RemoteInputStreamInterface getRemoteInputStream(Object streamID) throws IOException, RemoteException {
        if (this._closed) {
            throw new IllegalStateException(RB.getStringResource("COM.binClosd.ex.txt"));
        }
        return RequesterBinaryFileSupport.getRemoteInputStream(this);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        RequesterIOMInputStream is;
        if (this._closed) {
            throw new IllegalStateException(RB.getStringResource("COM.binClosd.ex.txt"));
        }
        try {
            IBinaryStream ibs;
            switch (this._role) {
                case 7: {
                    ibs = this._iomEntry.OpenFrame(StreamOpenMode.StreamOpenModeForReading, "");
                    break;
                }
                case 1: {
                    ibs = this._iomEntry.OpenBodyItem(0, StreamOpenMode.StreamOpenModeForReading, "");
                    break;
                }
                case 2: {
                    ibs = this._iomEntry.OpenBodyItem(this._index, StreamOpenMode.StreamOpenModeForReading, "");
                    break;
                }
                case 4: {
                    ibs = this._iomEntry.OpenContents(StreamOpenMode.StreamOpenModeForReading, "");
                    break;
                }
                case 6: {
                    ibs = this._iomEntry.OpenCompanion(this._index, StreamOpenMode.StreamOpenModeForReading, "");
                    break;
                }
                case 5: {
                    ibs = this._iomEntry.OpenPage(StreamOpenMode.StreamOpenModeForReading, "");
                    break;
                }
                default: {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (Object)Integer.toString(this._role));
                    throw new IllegalStateException(msg);
                }
            }
            is = new RequesterIOMInputStream(ibs);
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
        return new InputStreamAdapter((InputStream)is);
    }

    void close() {
        this._closed = true;
        this._encoding = null;
        this._url = null;
    }

    public String getEntityKey() throws RemoteException {
        return this._entityKeyIf.getEntityKey();
    }

    public boolean sameEntity(EntityKeyInterface entity) throws RemoteException {
        return this._entityKeyIf.sameEntity(entity);
    }

    public void setEntityKey(String entityKey) throws RemoteException, IllegalStateException {
        this._entityKeyIf.setEntityKey(entityKey);
    }
}

