/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.requester;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IResultPackageHTMLEntry;
import com.sas.iom.SAS.IResultPackageHTMLEntryHelper;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.services.TransportException;
import com.sas.services.publish.HTMLEntryInterface;
import com.sas.services.publish.HTMLFileInterface;
import com.sas.services.publish.requester.RB;
import com.sas.services.publish.requester.RequesterAbstractEntry;
import com.sas.services.publish.requester.RequesterHTMLFile;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

@SASScope
class RequesterHTMLEntry
extends RequesterAbstractEntry
implements HTMLEntryInterface {
    private IResultPackageHTMLEntry _iomEntry;
    boolean _gotAllFileRelatedStuff;
    private RequesterHTMLFile _mainFile;
    private RequesterHTMLFile[] _companionFiles;

    RequesterHTMLEntry(Object iomEntry) throws RemoteException {
        this(iomEntry, RequesterHTMLEntry.class);
    }

    private RequesterHTMLEntry(Object iomEntry, Class theClass) throws RemoteException {
        super(theClass);
        this._iomEntry = IResultPackageHTMLEntryHelper.narrow((Object)iomEntry);
    }

    @Override
    public HTMLFileInterface getFile() throws TransportException, RemoteException {
        this.throwExceptionIfClosed();
        if (!this._gotAllFileRelatedStuff) {
            this.getAllFileRelatedStuff();
        }
        return this._mainFile;
    }

    @Override
    public HTMLFileInterface getFile(String uniqueId) throws RemoteException {
        RequesterHTMLFile foundFile = null;
        if (this._mainFile != null && uniqueId.equals(this._mainFile.getEntityKey())) {
            foundFile = this._mainFile;
        }
        if (foundFile == null) {
            for (int i = 0; i < this._companionFiles.length; ++i) {
                RequesterHTMLFile f = this._companionFiles[i];
                if (!uniqueId.equals(f.getEntityKey())) continue;
                foundFile = f;
                break;
            }
        }
        return foundFile;
    }

    @Override
    public void setFile(HTMLFileInterface mainFile) throws IllegalStateException {
        this.throwExceptionIfClosed();
        throw new IllegalStateException(RB.getStringResource("COM.browseOnly.ex.txt"));
    }

    @Override
    public HTMLFileInterface[] getCompanionFiles() throws TransportException, RemoteException {
        this.throwExceptionIfClosed();
        if (!this._gotAllFileRelatedStuff) {
            this.getAllFileRelatedStuff();
        }
        HTMLFileInterface[] retFiles = new HTMLFileInterface[this._companionFiles.length];
        System.arraycopy(this._companionFiles, 0, retFiles, 0, this._companionFiles.length);
        return retFiles;
    }

    @Override
    public void addCompanionFile(HTMLFileInterface companion) throws IllegalStateException {
        this.throwExceptionIfClosed();
        throw new IllegalStateException(RB.getStringResource("COM.browseOnly.ex.txt"));
    }

    @Override
    public void setCompanionFiles(HTMLFileInterface[] companions) throws IllegalStateException {
        this.throwExceptionIfClosed();
        throw new IllegalStateException(RB.getStringResource("COM.browseOnly.ex.txt"));
    }

    @Override
    void subSetNameValuePairs() throws TransportException, RemoteException {
        try {
            VariableArray2dOfStringHolder holder = new VariableArray2dOfStringHolder();
            this._iomEntry.GetNameValuePairs(holder);
            this.setNameValuePairs(holder);
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new TransportException((Throwable)e, msg);
        }
    }

    private void getAllFileRelatedStuff() throws TransportException, RemoteException {
        RequesterHTMLFile file;
        StringSeqHolder urls = new StringSeqHolder();
        StringSeqHolder encodings = new StringSeqHolder();
        ArrayList<RequesterHTMLFile> compFiles = new ArrayList<RequesterHTMLFile>();
        this._gotAllFileRelatedStuff = true;
        try {
            String url;
            String encoding;
            if (this._iomEntry.FrameIncluded()) {
                encoding = this._iomEntry.FrameEncoding();
                url = this._iomEntry.FrameURL();
                this._mainFile = new RequesterHTMLFile(this._iomEntry, 7, url, encoding, 0);
            }
            if (this._iomEntry.ContentsIncluded()) {
                encoding = this._iomEntry.ContentsEncoding();
                url = this._iomEntry.ContentsURL();
                file = new RequesterHTMLFile(this._iomEntry, 4, url, encoding, 0);
                compFiles.add(file);
            }
            if (this._iomEntry.PageIncluded()) {
                encoding = this._iomEntry.PageEncoding();
                url = this._iomEntry.PageURL();
                file = new RequesterHTMLFile(this._iomEntry, 5, url, encoding, 0);
                compFiles.add(file);
            }
        }
        catch (SystemException e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new TransportException((Throwable)e, msg);
        }
        try {
            this._iomEntry.ListBodyItems(urls, encodings);
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new TransportException((Throwable)e, msg);
        }
        if (urls.value != null && urls.value.length > 0) {
            int startIndex;
            if (this._mainFile == null) {
                this._mainFile = new RequesterHTMLFile(this._iomEntry, 1, urls.value[0], encodings.value[0], 0);
                startIndex = 1;
            } else {
                startIndex = 0;
            }
            for (int i = startIndex; i < urls.value.length; ++i) {
                file = new RequesterHTMLFile(this._iomEntry, 2, urls.value[i], encodings.value[i], i);
                compFiles.add(file);
            }
        }
        try {
            this._iomEntry.ListCompanions(urls, encodings);
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new TransportException((Throwable)e, msg);
        }
        if (urls.value != null && urls.value.length > 0) {
            for (int i = 0; i < urls.value.length; ++i) {
                file = new RequesterHTMLFile(this._iomEntry, 6, urls.value[i], encodings.value[i], i);
                compFiles.add(file);
            }
        }
        this._companionFiles = compFiles.toArray(new RequesterHTMLFile[0]);
    }

    @Override
    protected void closeEntry() {
        super.closeEntry();
        this._iomEntry = null;
        if (this._mainFile != null) {
            this._mainFile.close();
            this._mainFile = null;
        }
        if (this._companionFiles != null) {
            for (int i = 0; i < this._companionFiles.length; ++i) {
                this._companionFiles[i].close();
            }
            this._companionFiles = null;
        }
    }
}

