/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.requester;

import com.sas.codepolicy.SASScope;
import com.sas.io.ChainedIOException;
import com.sas.io.InputStreamAdapter;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IBinaryStreamHelper;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.services.publish.BinaryFileEntryInterface;
import com.sas.services.publish.requester.RB;
import com.sas.services.publish.requester.RequesterBinaryFileSupport;
import com.sas.services.publish.requester.RequesterFileEntry;
import com.sas.services.publish.requester.RequesterIOMInputStream;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.omg.CORBA.Object;

@SASScope
class RequesterBinaryFileEntry
extends RequesterFileEntry
implements BinaryFileEntryInterface {
    static ByteArrayInputStream dummyInputStream = new ByteArrayInputStream(new byte[1]);

    private RequesterBinaryFileEntry() throws RemoteException {
        super(RequesterBinaryFileEntry.class);
    }

    RequesterBinaryFileEntry(Object iomEntry) throws RemoteException {
        super(iomEntry, RequesterBinaryFileEntry.class);
    }

    @Override
    public java.lang.Object hasInputStream() {
        return dummyInputStream;
    }

    @Override
    public InputStream getInputStream(java.lang.Object streamID) throws ChainedIOException {
        this.throwExceptionIfClosed();
        try {
            StreamOpenMode readmode = StreamOpenMode.StreamOpenModeForReading;
            Object fo = this._iomEntry.Open(readmode, 0);
            IBinaryStream inStream = IBinaryStreamHelper.narrow((Object)fo);
            return new RequesterIOMInputStream(inStream);
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
    }

    @Override
    public InputStream getInputStream() throws ChainedIOException, RemoteException {
        this.throwExceptionIfClosed();
        try {
            StreamOpenMode readmode = StreamOpenMode.StreamOpenModeForReading;
            Object fo = this._iomEntry.Open(readmode, 0);
            IBinaryStream inStream = IBinaryStreamHelper.narrow((Object)fo);
            RequesterIOMInputStream is = new RequesterIOMInputStream(inStream);
            return new InputStreamAdapter((InputStream)is);
        }
        catch (GenericError e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.tran.ex.fmt.txt", (java.lang.Object)e.toString());
            throw new ChainedIOException((Throwable)e, msg);
        }
    }

    @Override
    public RemoteInputStreamInterface getRemoteInputStream(java.lang.Object streamID) throws IOException, RemoteException {
        this.throwExceptionIfClosed();
        return RequesterBinaryFileSupport.getRemoteInputStream(this);
    }
}

