/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.requester;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.services.TransportException;
import com.sas.services.publish.AbstractEntry;
import com.sas.services.publish.requester.RB;
import com.sas.services.util.AttributeMap;
import com.sas.services.util.AttributeMapInterface;
import com.sas.text.Message;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

@SASScope
abstract class RequesterAbstractEntry
extends AbstractEntry {
    boolean _readOnly = true;
    boolean _nameValuePairsPreviouslyGot;

    RequesterAbstractEntry() throws RemoteException {
        this(RequesterAbstractEntry.class);
    }

    protected RequesterAbstractEntry(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected void setDescriptionEvenThoughItsBrowseOnly(String description) {
        this._readOnly = false;
        try {
            this.setDescription(description);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this._readOnly = true;
    }

    @Override
    public boolean isReadOnly() {
        return this._readOnly;
    }

    @Override
    public AttributeMapInterface getNameValuePairs() throws TransportException, RemoteException {
        AttributeMapInterface nv = super.getNameValuePairs();
        if (nv == null && !this._nameValuePairsPreviouslyGot) {
            this._readOnly = false;
            this.subSetNameValuePairs();
            this._readOnly = true;
            nv = super.getNameValuePairs();
            this._nameValuePairsPreviouslyGot = true;
        }
        return nv;
    }

    void setNameValuePairs(VariableArray2dOfStringHolder holder) throws RemoteException {
        AttributeMap nv;
        String[][] nameValueArray = holder.value;
        int count = nameValueArray.length;
        if (count == 0) {
            nv = null;
        } else {
            nv = new AttributeMap();
            String lastNonBlankName = "";
            for (int i = 0; i < count; ++i) {
                if (nameValueArray[i][0].length() > 0) {
                    lastNonBlankName = nameValueArray[i][0];
                }
                try {
                    nv.addAttribute(lastNonBlankName, nameValueArray[i][1]);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"RAE.invNV.ex.fmt.txt", (Object)e.getMessage());
                    throw new IllegalArgumentException(msg);
                }
            }
        }
        this.setNameValuePairs((AttributeMapInterface)nv);
    }

    protected void closeEntry() {
        this.setClosed(true);
        try {
            RequesterAbstractEntry.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    abstract void subSetNameValuePairs() throws TransportException, RemoteException;
}

