/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.Directory;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.publish.metadata.OMRPublishDirectory;
import com.sas.services.publish.metadata.PublishDirectoryInterface;
import com.sas.services.publish.metadata.RB;
import java.rmi.RemoteException;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class PublishDirectoryFactory {
    public static PublishDirectoryInterface newPublishDirectory(DirectoryInterface dir) throws ServiceException {
        try {
            RepositoryInterface repos = dir.getRepository();
            if (repos instanceof OMIRepositoryInterface) {
                Directory cDir = (Directory)dir.getRepositoryEntity();
                OMRPublishDirectory opd = new OMRPublishDirectory(cDir);
                opd.setRepository(dir.getRepository());
                return opd;
            }
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("PublishDirectoryFactory.ex.txt"));
        }
        return null;
    }
}

