/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.services.ParseException;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.ChannelInterface;
import com.sas.services.information.metadata.ContentDestination;
import com.sas.services.information.metadata.ContentSubscriberInterface;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.publish.metadata.PackageInterface;
import com.sas.services.publish.metadata.RB;
import com.sas.services.util.AttributeMap;
import com.sas.services.util.AttributeMapInterface;
import com.sas.services.util.URIUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@SASScope
public class PackageUtil {
    public static final String URLKEY = "URL";
    public static final String DOMAINKEY = "DOMAIN";
    public static final String PROTKEY = "PROTOCOL";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map getDirectoryURL(PackageInterface pkgSmartObject) throws ServiceException {
        ServerInterface server;
        String relPath;
        ContentDestination adest;
        boolean isFile = false;
        URL u = null;
        String filename = null;
        String domain = null;
        HashMap<String, Object> map = null;
        try {
            adest = pkgSmartObject.getContentDestination();
            if (adest == null) {
                throw new ServiceException(RB.getStringResource("PackageUtil.noApath.ex.txt"));
            }
            relPath = adest.getPath();
            server = adest.getServer();
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("PackageUtil.metadata.ex.txt"));
        }
        if (relPath != null && !relPath.equals("") && server == null) {
            try {
                u = new URL(relPath);
                if (u.getProtocol().equalsIgnoreCase("file")) {
                    isFile = true;
                    filename = PackageUtil.getFilename(pkgSmartObject, u);
                } else if (!u.getProtocol().equalsIgnoreCase("http") && !u.getProtocol().equalsIgnoreCase("ftp")) {
                    throw new ServiceException(RB.getStringResource("PackageUtil.badUrl.ex.txt"));
                }
            }
            catch (MalformedURLException e) {
                isFile = true;
                filename = PackageUtil.getFilename(pkgSmartObject);
            }
        } else {
            if (server == null) throw new ServiceException(RB.getStringResource("PackageUtil.noApath.ex.txt"));
            try {
                u = PackageUtil.getServerURL(adest);
                Iterator domainIt = server.getDomains().iterator();
                if (domainIt.hasNext()) {
                    domain = (String)domainIt.next();
                }
            }
            catch (RemoteException e) {
                throw new ServiceException((Throwable)e, RB.getStringResource("PackageUtil.apathErr.ex.txt"));
            }
        }
        if (isFile) {
            map = new HashMap<String, Object>();
            map.put(PROTKEY, "FILE");
            map.put(URLKEY, filename);
            return map;
        } else {
            map = new HashMap();
            if (u.getProtocol().equalsIgnoreCase("http")) {
                map.put(PROTKEY, "HTTP");
            } else {
                map.put(PROTKEY, "FTP");
            }
            map.put(URLKEY, u);
            if (domain == null) return map;
            map.put(DOMAINKEY, domain);
        }
        return map;
    }

    private static String getFilename(PackageInterface pkgSmartObject, URL u) throws ServiceException {
        String filename = null;
        try {
            URL u2 = new URL(u, pkgSmartObject.getName());
            StringBuffer b = new StringBuffer();
            b.append(u2.getFile());
            b.append(".spk");
            filename = b.toString();
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("PackageUtil.metadata.ex.txt"));
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("PackageUtil.metadata.ex.txt"));
        }
        return filename;
    }

    private static String getFilename(PackageInterface pkgSmartObject) throws ServiceException {
        String filename = null;
        try {
            DirectoryInterface dir = pkgSmartObject.getContentDestination().getDirectory();
            String path = dir.getFilePath();
            String name = pkgSmartObject.getName() + ".spk";
            filename = path != null ? URIUtil.addSegment((String)path, (String)name) : name;
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("PackageUtil.metadata.ex.txt"));
        }
        return filename;
    }

    public static URL getServerURL(ContentDestination content) throws ServiceException {
        String relPath = null;
        String basePath = null;
        ServerInterface server = null;
        String thepath = null;
        URL url = null;
        try {
            String host;
            String protocol;
            relPath = content.getPath();
            basePath = content.getBasePath();
            server = content.getServer();
            if (server == null) {
                throw new ServiceException(RB.getStringResource("PackageUtil.noServer.ex.txt"));
            }
            if (relPath == null) {
                thepath = basePath;
            } else {
                String string = thepath = basePath == null ? relPath : URIUtil.addSegment((String)basePath, (String)relPath);
            }
            if (thepath == null) {
                thepath = "";
            }
            if ((protocol = server.getApplicationProtocol()) == null) {
                protocol = "";
            }
            if ((host = server.getHost()) == null) {
                host = "";
            }
            if (!server.getClassIdentifier().equals("DAC0D7F0-10DA-11D6-8816-AA0004006D06") && !server.getClassIdentifier().equals("CBA26437-1577-4FF8-93F6-9B68B4DD8D2E")) {
                throw new ServiceException(RB.getStringResource("PackageUtil.invalidServer.ex.txt"));
            }
            url = new URL(protocol, host, server.getTcpPort(), thepath);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("PackageUtil.urlErr.ex.txt"));
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("PackageUtil.urlErr.ex.txt"));
        }
        return url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static List filterPackages(ContentSubscriberInterface sub, List pkgList) throws RemoteException, ParseException {
        ArrayList<PackageInterface> returnList = new ArrayList<PackageInterface>();
        AttributeMapInterface pkgNameValuePairs = null;
        Iterator pkgItor = pkgList.iterator();
        try {
            block2: while (pkgItor.hasNext()) {
                Iterator itor;
                boolean match;
                PackageInterface pkg = (PackageInterface)pkgItor.next();
                pkgNameValuePairs = pkg.getProperties();
                List filters = sub.nameValueInclusionFilters();
                if (filters.size() != 0) {
                    if (pkgNameValuePairs == null) continue;
                    match = false;
                    itor = filters.iterator();
                    do {
                        if (!itor.hasNext()) continue block2;
                    } while (!(match = AttributeMap.applyFilter((String)((String)itor.next()), (AttributeMapInterface)pkgNameValuePairs)));
                    returnList.add(pkg);
                    continue;
                }
                filters = sub.nameValueExclusionFilters();
                if (filters.size() == 0) {
                    returnList.add(pkg);
                    continue;
                }
                match = false;
                if (pkgNameValuePairs == null) {
                    match = false;
                } else {
                    itor = filters.iterator();
                    while (itor.hasNext() && !(match = AttributeMap.applyFilter((String)((String)itor.next()), (AttributeMapInterface)pkgNameValuePairs))) {
                    }
                }
                if (match) continue;
                returnList.add(pkg);
            }
            return returnList;
        }
        catch (ServiceException ex) {
            throw new ParseException((Throwable)ex, ex.getMessage());
        }
    }

    public static int getDAVPackageCount(FolderInterface folder) throws RemoteException, ServiceException {
        int numPkgs = 0;
        if (folder != null) {
            Object o2 = null;
            for (Object o2 : folder.getItems()) {
                ChannelInterface ch;
                if (!(o2 instanceof ChannelInterface) || (ch = (ChannelInterface)o2).getDeliveryTransport() != 3) continue;
                numPkgs += ch.packageList().size();
            }
            o2 = null;
            for (Object o2 : folder.getSubfolders()) {
                if (!(o2 instanceof FolderInterface)) continue;
                numPkgs += PackageUtil.getDAVPackageCount(o2);
            }
        }
        return numPkgs;
    }

    public static List getDAVChannels(FolderInterface folder) throws RemoteException, ServiceException {
        ArrayList<ChannelInterface> l = new ArrayList<ChannelInterface>();
        if (folder != null) {
            Object o2 = null;
            for (Object o2 : folder.getItems()) {
                ChannelInterface ch;
                if (!(o2 instanceof ChannelInterface) || (ch = (ChannelInterface)o2).getDeliveryTransport() != 3) continue;
                l.add(ch);
            }
            o2 = null;
            for (Object o2 : folder.getSubfolders()) {
                if (!(o2 instanceof FolderInterface)) continue;
                l.addAll(PackageUtil.getDAVChannels(o2));
            }
        }
        return l;
    }

    public static List filterPackages(List subList, List pkgList) throws RemoteException, ParseException {
        ArrayList returnList = new ArrayList();
        boolean pkgAddedToList = false;
        Iterator itor = null;
        Iterator subItor = subList.iterator();
        while (subItor.hasNext() && !pkgAddedToList) {
            ContentSubscriberInterface sub = (ContentSubscriberInterface)subItor.next();
            List l = PackageUtil.filterPackages(sub, pkgList);
            for (Object o : l) {
                if (returnList.contains(o)) continue;
                returnList.add(o);
            }
        }
        return returnList;
    }

    static boolean isExpired(long expirationDateTime) throws RemoteException, ServiceException {
        if (expirationDateTime == -1L) {
            return false;
        }
        boolean expired = false;
        long current = new Date().getTime();
        if (current >= expirationDateTime) {
            expired = true;
        }
        return expired;
    }
}

