/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.CMetadata;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.metadata.ChannelInterface;
import com.sas.services.information.metadata.KeywordFilter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class PackageFilter
extends KeywordFilter {
    private static final long serialVersionUID = 270614048776249134L;
    private String _description;
    private int _descriptionOperator;
    private List _abstract;
    private int _abstractOperator;
    private ChannelInterface _channel;
    private List _nvpairs;

    public PackageFilter() {
        this.setType("Package");
        this._channel = null;
    }

    public PackageFilter(String key, int relation, String value) {
        super(key, relation, value);
        this.setType("Package");
        this._channel = null;
    }

    public void includeNameValuePair(String name, String value) {
        if (this._nvpairs == null) {
            this._nvpairs = new ArrayList();
        }
        this._nvpairs.add(new NvPair(name, value, true));
    }

    public void excludeNameValuePair(String name, String value) {
        if (this._nvpairs == null) {
            this._nvpairs = new ArrayList();
        }
        this._nvpairs.add(new NvPair(name, value, false));
    }

    public void clearNameValuePairs() {
        if (this._nvpairs == null) {
            return;
        }
        this._nvpairs.clear();
        this._nvpairs = null;
    }

    public String getOMRType() {
        return "ArchiveFile";
    }

    public String getLDAPType() {
        return "sasarchive";
    }

    public String getDAVType() {
        return "package|binarypackage";
    }

    public ChannelInterface getChannel() {
        return this._channel;
    }

    public void setChannel(ChannelInterface channel) {
        this._channel = channel;
    }

    public void setDescription(String description, int operation) {
        this._description = description;
        this._descriptionOperator = operation;
    }

    public void setAbstract(String abstractString, int operation) {
        this._abstract = new ArrayList(1);
        this._abstract.add(abstractString);
        this._abstractOperator = operation;
    }

    public void setAbstract(List abstracts) {
        if (abstracts == null) {
            return;
        }
        this._abstract = new ArrayList(abstracts.size());
        this._abstract.addAll(abstracts);
        this._abstractOperator = 1;
    }

    public String getXMLSelectString() {
        String name = this.getName();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<XMLSelect Search=\"*");
        boolean need_select = false;
        if (name != null || this._description != null) {
            buffer.append("[");
            if (name != null) {
                buffer.append("@Name='" + name + '\'');
                if (this._description != null) {
                    buffer.append(" and ");
                }
            }
            if (this._description != null) {
                buffer.append("@Desc");
                if (this._descriptionOperator == 0) {
                    buffer.append("=");
                }
                if (this._descriptionOperator == 1) {
                    buffer.append("?");
                }
                buffer.append('\'' + this._description + '\'');
            }
            buffer.append("]");
            need_select = true;
        } else if (this._keywords.size() > 0) {
            buffer.append("[");
            for (int i = 0; i < this._keywords.size(); ++i) {
                if (i != 0) {
                    buffer.append(" or ");
                }
                buffer.append("(@Desc?");
                String nextKey = (String)this._keywords.get(i);
                buffer.append('\'' + nextKey + '\'');
                buffer.append(")");
                buffer.append("or (@Name?");
                buffer.append('\'' + nextKey + '\'');
                buffer.append(")");
            }
            buffer.append("]");
            need_select = true;
        }
        if (this._channel != null) {
            block22: {
                try {
                    Object o = this._channel.getRepositoryEntity();
                    if (!(o instanceof CMetadata)) break block22;
                    String channelName = null;
                    try {
                        channelName = this._channel.getName();
                    }
                    catch (RemoteException rex) {
                        channelName = "RemoteException";
                    }
                    buffer.append("[OwningChannel/ITChannel[@Name='" + channelName + "']]");
                }
                catch (RemoteException o) {
                    // empty catch block
                }
            }
            need_select = true;
        }
        if (this._nvpairs != null && this._nvpairs.size() > 0) {
            StringBuffer pairBuffer = new StringBuffer();
            pairBuffer.append("[Properties/Property[");
            int pairSize = this._nvpairs.size();
            boolean first_value = true;
            for (int i = 0; i < pairSize; ++i) {
                NvPair pair = (NvPair)this._nvpairs.get(i);
                if (!pair.include) continue;
                if (!first_value) {
                    pairBuffer.append(" or ");
                }
                pairBuffer.append("(@Name='" + pair.name + "' and @DefaultValue='" + pair.value + "')");
                first_value = false;
            }
            pairBuffer.append("]]");
            if (!first_value) {
                buffer.append(pairBuffer);
                need_select = true;
            }
        }
        if (this._abstract != null && this._abstract.size() > 0) {
            buffer.append("[Notes/TextStore[");
            String compStr = null;
            compStr = this._abstractOperator == 0 ? "=" : "?";
            for (int i = 0; i < this._abstract.size(); ++i) {
                if (i != 0) {
                    buffer.append(" or ");
                }
                buffer.append("(@StoredText");
                buffer.append(compStr);
                buffer.append('\'' + (String)this._abstract.get(i) + '\'' + ")");
            }
            buffer.append("]]");
            need_select = true;
        }
        buffer.append("\" />\n");
        return need_select ? buffer.toString() : "";
    }

    public String getDAVBasicSearchString() {
        String name = this.getName();
        FilterComponent compy = this._component;
        FilterComponent nameComp = new FilterComponent();
        FilterComponent descComp = null;
        FilterComponent abstractComp = null;
        FilterComponent keywordComp = null;
        FilterComponent nvpairComp = null;
        if (this._channel != null) {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><d:searchrequest xmlns:d=\"DAV:\"><d:basicsearch/></d:searchrequest>";
        }
        if (name != null) {
            nameComp.setFilter("{http://www.sas.com/xml/namespace/services.webdav-1.1}name", 0, name);
        }
        if (this._description != null) {
            descComp = new FilterComponent();
            if (this._descriptionOperator == 0) {
                StringBuffer b = new StringBuffer();
                b.append("\"");
                b.append(this._description);
                b.append("\"");
                descComp.setFilter("{http://www.sas.com/rnd/itech/WebDAV}description", this._descriptionOperator, b.toString());
            } else {
                descComp.setFilter("{http://www.sas.com/rnd/itech/WebDAV}description", this._descriptionOperator, this._description);
            }
        }
        if (this._abstract != null && this._abstract.size() > 0) {
            abstractComp = new FilterComponent();
            Iterator itor = this._abstract.iterator();
            while (itor.hasNext()) {
                if (this._abstractOperator == 0) {
                    StringBuffer b = new StringBuffer();
                    b.append("\"");
                    b.append((String)itor.next());
                    b.append("\"");
                    abstractComp.setFilter("{http://www.sas.com/rnd/itech/WebDAV}abstract", this._abstractOperator, b.toString());
                    continue;
                }
                abstractComp.setFilter("{http://www.sas.com/rnd/itech/WebDAV}abstract", this._abstractOperator, (String)itor.next());
            }
        }
        if (this._keywords.size() > 0) {
            keywordComp = new FilterComponent();
            for (String keyword : this._keywords) {
                keywordComp.addComponent(new FilterComponent("{http://www.sas.com/rnd/itech/WebDAV}saskeyword", 1, keyword));
                keywordComp.addComponent(new FilterComponent("{http://www.sas.com/rnd/itech/WebDAV}description", 1, keyword));
                keywordComp.addComponent(new FilterComponent("{http://www.sas.com/rnd/itech/WebDAV}abstract", 1, keyword));
            }
            keywordComp.setAggregation(1);
        }
        if (this._nvpairs != null && this._nvpairs.size() > 0) {
            FilterComponent nvpairIncComp = new FilterComponent();
            nvpairIncComp.setAggregation(1);
            int pairSize = this._nvpairs.size();
            for (int i = 0; i < pairSize; ++i) {
                NvPair pair = (NvPair)this._nvpairs.get(i);
                if (!pair.include) continue;
                nvpairIncComp.addComponent(new FilterComponent(pair.name, 0, pair.value));
            }
            nvpairComp = nvpairIncComp;
        }
        if (keywordComp != null) {
            nameComp.addComponent(keywordComp);
            nameComp.setAggregation(0);
        }
        if (descComp != null) {
            nameComp.addComponent(descComp);
            nameComp.setAggregation(0);
        }
        if (abstractComp != null) {
            nameComp.addComponent(abstractComp);
            nameComp.setAggregation(0);
        }
        if (compy != null) {
            nameComp.addComponent(compy);
            nameComp.setAggregation(0);
        }
        if (nvpairComp != null) {
            nameComp.addComponent(nvpairComp);
            nameComp.setAggregation(0);
        }
        this.setFilterComponent(nameComp);
        String result = super.getDAVBasicSearchString();
        this.setFilterComponent(compy);
        return result;
    }

    public String getDAVSQLString() {
        String name = this.getName();
        FilterComponent compy = this._component;
        FilterComponent nameComp = new FilterComponent();
        FilterComponent descComp = null;
        FilterComponent abstractComp = null;
        FilterComponent keywordComp = null;
        FilterComponent nvpairComp = null;
        if (this._channel != null) {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><d:searchrequest xmlns:d=\"DAV:\"><d:sql/></d:searchrequest>";
        }
        if (name != null) {
            nameComp.setFilter("{http://www.sas.com/xml/namespace/services.webdav-1.1}name", 0, name);
        }
        if (this._description != null) {
            descComp = new FilterComponent();
            descComp.setFilter("{http://www.sas.com/rnd/itech/WebDAV}description", this._descriptionOperator, this._description);
        }
        if (this._abstract != null && this._abstract.size() > 0) {
            abstractComp = new FilterComponent();
            Iterator itor = this._abstract.iterator();
            while (itor.hasNext()) {
                abstractComp.setFilter("{http://www.sas.com/rnd/itech/WebDAV}abstract", this._abstractOperator, (String)itor.next());
            }
        }
        if (this._keywords.size() > 0) {
            keywordComp = new FilterComponent();
            for (String keyword : this._keywords) {
                keywordComp.addComponent(new FilterComponent("{http://www.sas.com/rnd/itech/WebDAV}saskeyword", 1, keyword));
                keywordComp.addComponent(new FilterComponent("{http://www.sas.com/rnd/itech/WebDAV}description", 1, keyword));
                keywordComp.addComponent(new FilterComponent("{http://www.sas.com/rnd/itech/WebDAV}abstract", 1, keyword));
            }
            keywordComp.setAggregation(1);
        }
        if (this._nvpairs != null && this._nvpairs.size() > 0) {
            FilterComponent nvpairIncComp = new FilterComponent();
            nvpairIncComp.setAggregation(1);
            int pairSize = this._nvpairs.size();
            for (int i = 0; i < pairSize; ++i) {
                NvPair pair = (NvPair)this._nvpairs.get(i);
                if (!pair.include) continue;
                nvpairIncComp.addComponent(new FilterComponent(pair.name, 0, pair.value));
            }
            nvpairComp = nvpairIncComp;
        }
        if (keywordComp != null) {
            nameComp.addComponent(keywordComp);
            nameComp.setAggregation(0);
        }
        if (descComp != null) {
            nameComp.addComponent(descComp);
            nameComp.setAggregation(0);
        }
        if (abstractComp != null) {
            nameComp.addComponent(abstractComp);
            nameComp.setAggregation(0);
        }
        if (compy != null) {
            nameComp.addComponent(compy);
            nameComp.setAggregation(0);
        }
        if (nvpairComp != null) {
            nameComp.addComponent(nvpairComp);
            nameComp.setAggregation(0);
        }
        this.setFilterComponent(nameComp);
        String result = super.getDAVSQLString();
        this.setFilterComponent(compy);
        return result;
    }

    @SASScope
    class NvPair
    implements Serializable {
        static final long serialVersionUID = -7027592304907729121L;
        public String name;
        public String value;
        public boolean include;

        public NvPair(String name, String value, boolean include) {
            this.name = name;
            this.value = value;
            this.include = include;
        }
    }
}

