/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.services.ParseException;
import com.sas.services.ServiceException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.metadata.ChannelInterface;
import com.sas.services.information.metadata.ContentDestination;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.dav.DAVPackage;
import com.sas.services.publish.TransportFactory;
import com.sas.services.publish.metadata.PackageInterface;
import com.sas.services.publish.metadata.PackageUtil;
import com.sas.services.publish.metadata.RB;
import com.sas.services.publish.webdav.DAVTransportInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.util.AttributeMap;
import com.sas.services.util.AttributeMapInterface;
import com.sas.services.util.DateUtil;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class DavPackage
extends Metadata
implements PackageInterface {
    public DavPackage() throws RemoteException {
        super(DavPackage.class);
    }

    public DavPackage(DAVPackage o) throws RemoteException {
        super((Object)o, DavPackage.class);
    }

    public String getType() throws RemoteException {
        return "Package";
    }

    public void setName(String name) throws RemoteException {
    }

    public void setDescription(String description) throws RemoteException {
    }

    @Override
    public long getCreationDate() throws RemoteException {
        long l = 0L;
        DAVPackage d = (DAVPackage)this._repositoryObject;
        String dateString = d.getCreationDateNumeric();
        if (dateString != null) {
            double creation = Double.valueOf(dateString);
            l = DateUtil.SASDateTimeToJavaDate((double)creation, (TimeZone)TimeZone.getTimeZone("GMT"));
        } else {
            dateString = d.getCreationDate();
            if (dateString != null) {
                SimpleDateFormat simple = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.US);
                simple.setTimeZone(TimeZone.getTimeZone("GMT"));
                Date theDateTime = null;
                try {
                    theDateTime = simple.parse(dateString);
                }
                catch (java.text.ParseException ex) {
                    ex.printStackTrace();
                }
                if (theDateTime != null) {
                    l = theDateTime.getTime();
                }
            }
        }
        return l;
    }

    @Override
    public String getCreationDateString() throws RemoteException {
        long creat = this.getCreationDate();
        if (creat < 0L) {
            return null;
        }
        Date date = new Date(creat);
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd:HH:mm:ss");
        TimeZone tz = TimeZone.getTimeZone("GMT");
        format.setTimeZone(tz);
        String dateString = format.format(date);
        return dateString;
    }

    @Override
    public long getExpirationDate() throws RemoteException {
        long l = 253402318799000L;
        DAVPackage d = (DAVPackage)this._repositoryObject;
        String dateString = d.getExpirationDateNumeric();
        if (dateString != null) {
            double expiration = Double.valueOf(dateString);
            l = DateUtil.SASDateTimeToJavaDate((double)expiration, (TimeZone)TimeZone.getTimeZone("GMT"));
        } else {
            dateString = d.getExpirationDate();
            if (dateString != null) {
                SimpleDateFormat simple = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.US);
                simple.setTimeZone(TimeZone.getTimeZone("GMT"));
                Date theDateTime = null;
                try {
                    theDateTime = simple.parse(dateString);
                }
                catch (java.text.ParseException ex) {
                    ex.printStackTrace();
                }
                if (theDateTime != null) {
                    l = theDateTime.getTime();
                }
            }
        }
        return l;
    }

    @Override
    public String getExpirationDateString() throws RemoteException {
        long expir = this.getExpirationDate();
        if (expir < 0L) {
            return null;
        }
        Date date = new Date(expir);
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd:HH:mm:ss");
        TimeZone tz = TimeZone.getTimeZone("GMT");
        format.setTimeZone(tz);
        String dateString = format.format(date);
        return dateString;
    }

    @Override
    public String getAbstract() throws RemoteException {
        DAVPackage d = (DAVPackage)this._repositoryObject;
        String abs = d.getAbstract();
        if (abs != null && abs.length() > 0 && abs.charAt(0) == '\"' && abs.charAt(abs.length() - 1) == '\"') {
            abs = abs.substring(1, abs.length() - 1);
        }
        return abs;
    }

    @Override
    public AttributeMapInterface getProperties() throws RemoteException {
        AttributeMap result = null;
        DAVPackage d = (DAVPackage)this._repositoryObject;
        Map values = d.getUserProperties();
        Iterator valueIt = values.entrySet().iterator();
        if (valueIt.hasNext()) {
            result = new AttributeMap();
        }
        while (valueIt.hasNext()) {
            Map.Entry next = valueIt.next();
            String key = (String)next.getKey();
            if (key.startsWith("{}")) {
                key = key.substring(2);
            }
            String value = (String)next.getValue();
            try {
                result = (AttributeMap)AttributeMap.parseValues((AttributeMapInterface)result, (String)key, (String)value);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public ChannelInterface getChannel() throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public PersonInterface getPublisher() throws RemoteException {
        block4: {
            DAVPackage d = (DAVPackage)this._repositoryObject;
            UserContextInterface uc = this._repository.getUserContext();
            try {
                MetadataInterface m = null;
                InformationServiceInterface infoService = Metadata.getInformationService();
                String urlStr = d.getPublisherURI();
                if (urlStr != null) {
                    m = infoService.fetchEntityByUrl(uc, urlStr, null);
                }
                if (m != null) {
                    return (PersonInterface)m;
                }
            }
            catch (ServiceException e) {
                Logger logger = LogManager.getLogger(DavPackage.class);
                if (logger == null || !logger.isInfoEnabled()) break block4;
                logger.info(RB.getStringResource("Metadata.accessexcept.msg.txt"), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String getPublisherAlias() throws RemoteException {
        DAVPackage d = (DAVPackage)this._repositoryObject;
        return d.getPublisherAlias();
    }

    @Override
    public ContentDestination getContentDestination() throws RemoteException {
        return new ContentDestination(null, null, null, null, null);
    }

    public Object newServiceObject() throws ServiceException, RemoteException {
        DAVPackage d = (DAVPackage)this._repositoryObject;
        final UserContextInterface uc = this._repository.getUserContext();
        TransportFactory factory = new TransportFactory();
        DAVTransportInterface transport = null;
        if (uc != null) {
            SessionContextInterface sc = uc.getSessionContext();
            if (sc != null) {
                transport = factory.getDAVTransport(d.getURL(), this._repository.getDomain(), sc);
            } else {
                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return uc.getIdentityByDomain(DavPackage.this._repository.getDomain());
                    }
                };
                UserIdentityInterface identity = null;
                try {
                    identity = (UserIdentityInterface)AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException pae) {
                    Throwable t = pae.getCause();
                    if (t instanceof RemoteException) {
                        throw (RemoteException)t;
                    }
                    throw new ServiceException(t, "");
                }
                String username = null;
                String password = null;
                if (identity != null) {
                    username = (String)identity.getPrincipal();
                    password = (String)identity.getCredential();
                }
                transport = factory.getDAVTransportWithCredentials(d.getURL(), username, password, null);
            }
        } else {
            transport = factory.getDAVTransport(d.getURL(), this._repository.getDomain(), null);
        }
        return transport.getResultPackage();
    }

    public String getDescription() {
        DAVPackage d = (DAVPackage)this._repositoryObject;
        String desc = d.getDescription();
        if (desc != null && desc.length() > 0 && desc.charAt(0) == '\"' && desc.charAt(desc.length() - 1) == '\"') {
            desc = desc.substring(1, desc.length() - 1);
        }
        return desc;
    }

    @Override
    public String getDisplayName() throws ServiceException, RemoteException {
        String name = null;
        String desc = this.getDescription();
        name = desc == null || desc.equals("") ? this.getName() : desc;
        return name;
    }

    @Override
    public String getDisplayDescription() throws ServiceException, RemoteException {
        return this.getAbstract();
    }

    @Override
    public boolean isExpired() throws RemoteException, ServiceException {
        return PackageUtil.isExpired(this.getExpirationDate());
    }
}

