/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ParseException;
import com.sas.services.ServiceException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.metadata.ChannelInterface;
import com.sas.services.information.metadata.Content;
import com.sas.services.information.metadata.ContentDestination;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.dav.DAVBinarypackage;
import com.sas.services.publish.EventDataInterface;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.TransportFactory;
import com.sas.services.publish.metadata.DavBinaryPackageInterface;
import com.sas.services.publish.metadata.PackageUtil;
import com.sas.services.publish.metadata.RB;
import com.sas.services.publish.webdav.DAVTransport;
import com.sas.services.publish.webdav.DAVTransportInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.util.AttributeMap;
import com.sas.services.util.AttributeMapInterface;
import com.sas.services.util.DateUtil;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DavBinaryPackage
extends Content
implements DavBinaryPackageInterface {
    public DavBinaryPackage() throws RemoteException {
        super(DavBinaryPackage.class);
    }

    public DavBinaryPackage(DAVBinarypackage o) throws RemoteException {
        super((Object)o, DavBinaryPackage.class);
    }

    public String getType() throws RemoteException {
        return "Package";
    }

    public void setName(String name) throws RemoteException {
    }

    public void setDescription(String description) throws RemoteException {
    }

    @Override
    public long getCreationDate() throws RemoteException {
        long l = 0L;
        DAVBinarypackage d = (DAVBinarypackage)this._repositoryObject;
        String dateString = d.getCreationDateNumeric();
        if (dateString != null) {
            double creation = Double.valueOf(dateString);
            l = DateUtil.SASDateTimeToJavaDate((double)creation, (TimeZone)TimeZone.getTimeZone("GMT"));
        } else {
            dateString = d.getCreationDate();
            if (dateString != null) {
                SimpleDateFormat simple = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.US);
                simple.setTimeZone(TimeZone.getTimeZone("GMT"));
                Date theDateTime = null;
                try {
                    theDateTime = simple.parse(dateString);
                }
                catch (java.text.ParseException ex) {
                    ex.printStackTrace();
                }
                if (theDateTime != null) {
                    l = theDateTime.getTime();
                }
            }
        }
        return l;
    }

    @Override
    public String getCreationDateString() throws RemoteException {
        long creat = this.getCreationDate();
        if (creat < 0L) {
            return null;
        }
        Date date = new Date(creat);
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd:HH:mm:ss");
        TimeZone tz = TimeZone.getTimeZone("GMT");
        format.setTimeZone(tz);
        String dateString = format.format(date);
        return dateString;
    }

    @Override
    public long getExpirationDate() throws RemoteException {
        long l = 253402318799000L;
        DAVBinarypackage d = (DAVBinarypackage)this._repositoryObject;
        String dateString = d.getExpirationDateNumeric();
        if (dateString != null) {
            double expiration = Double.valueOf(dateString);
            l = DateUtil.SASDateTimeToJavaDate((double)expiration, (TimeZone)TimeZone.getTimeZone("GMT"));
        } else {
            dateString = d.getExpirationDate();
            if (dateString != null) {
                SimpleDateFormat simple = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.US);
                simple.setTimeZone(TimeZone.getTimeZone("GMT"));
                Date theDateTime = null;
                try {
                    theDateTime = simple.parse(dateString);
                }
                catch (java.text.ParseException ex) {
                    ex.printStackTrace();
                }
                if (theDateTime != null) {
                    l = theDateTime.getTime();
                }
            }
        }
        return l;
    }

    @Override
    public String getExpirationDateString() throws RemoteException {
        long expir = this.getExpirationDate();
        if (expir < 0L) {
            return null;
        }
        Date date = new Date(expir);
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd:HH:mm:ss");
        TimeZone tz = TimeZone.getTimeZone("GMT");
        format.setTimeZone(tz);
        String dateString = format.format(date);
        return dateString;
    }

    @Override
    public String getAbstract() throws RemoteException {
        DAVBinarypackage d = (DAVBinarypackage)this._repositoryObject;
        String abs = d.getAbstract();
        if (abs != null && abs.length() > 0 && abs.charAt(0) == '\"' && abs.charAt(abs.length() - 1) == '\"') {
            abs = abs.substring(1, abs.length() - 1);
        }
        return abs;
    }

    @Override
    public AttributeMapInterface getProperties() throws RemoteException {
        AttributeMap result = null;
        DAVBinarypackage d = (DAVBinarypackage)this._repositoryObject;
        Map values = d.getUserProperties();
        Iterator valueIt = values.entrySet().iterator();
        if (valueIt.hasNext()) {
            result = new AttributeMap();
        }
        while (valueIt.hasNext()) {
            Map.Entry next = valueIt.next();
            String key = (String)next.getKey();
            if (key.startsWith("{}")) {
                key = key.substring(2);
            }
            String value = (String)next.getValue();
            try {
                result = (AttributeMap)AttributeMap.parseValues((AttributeMapInterface)result, (String)key, (String)value);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public ChannelInterface getChannel() throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public PersonInterface getPublisher() throws RemoteException {
        DAVBinarypackage d = (DAVBinarypackage)this._repositoryObject;
        UserContextInterface uc = this._repository.getUserContext();
        try {
            MetadataInterface m = null;
            InformationServiceInterface infoService = Metadata.getInformationService();
            String urlStr = d.getPublisherURI();
            if (urlStr != null) {
                m = infoService.fetchEntityByUrl(uc, urlStr, null);
            }
            return (PersonInterface)m;
        }
        catch (ServiceException e) {
            Logger logger = LogManager.getLogger(DavBinaryPackage.class);
            if (logger != null && logger.isInfoEnabled()) {
                logger.info(RB.getStringResource("Metadata.accessexcept.msg.txt"), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String getPublisherAlias() throws RemoteException {
        DAVBinarypackage d = (DAVBinarypackage)this._repositoryObject;
        return d.getPublisherAlias();
    }

    public Object newServiceObject() throws ServiceException, RemoteException {
        DAVBinarypackage d = (DAVBinarypackage)this._repositoryObject;
        ResultPackageInterface rpkg = null;
        final UserContextInterface uc = this._repository.getUserContext();
        TransportFactory factory = new TransportFactory();
        DAVTransportInterface transport = null;
        if (uc != null) {
            SessionContextInterface sc = uc.getSessionContext();
            if (sc != null) {
                transport = factory.getDAVTransport(d.getURL(), this._repository.getDomain(), sc);
            } else {
                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return uc.getIdentityByDomain(DavBinaryPackage.this._repository.getDomain());
                    }
                };
                UserIdentityInterface identity = null;
                try {
                    identity = (UserIdentityInterface)AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException pae) {
                    Throwable t = pae.getCause();
                    if (t instanceof RemoteException) {
                        throw (RemoteException)t;
                    }
                    throw new ServiceException(t, "");
                }
                String username = null;
                String password = null;
                if (identity != null) {
                    username = (String)identity.getPrincipal();
                    password = (String)identity.getCredential();
                }
                transport = factory.getDAVTransportWithCredentials(d.getURL(), username, password, null);
            }
        } else {
            transport = factory.getDAVTransport(d.getURL(), this._repository.getDomain(), null);
        }
        rpkg = transport.getResultPackage();
        return rpkg;
    }

    @Override
    public ContentDestination getContentDestination() throws RemoteException {
        return new ContentDestination(null, null, null, null, null);
    }

    @Override
    public EventDataInterface publish(ResultPackageInterface rPkg, InputStream inputStream) throws ServiceException, RemoteException {
        DAVBinarypackage d = (DAVBinarypackage)this._repositoryObject;
        String url = null;
        String collectionName = null;
        SessionContextInterface sc = null;
        url = d.getUrl();
        collectionName = url.substring(0, url.lastIndexOf("/"));
        UserContextInterface uc = this._repository.getUserContext();
        if (uc != null) {
            sc = uc.getSessionContext();
        }
        DAVTransport davTransport = new DAVTransport(collectionName, this._repository.getDomain(), sc, inputStream);
        String _name = d.getName();
        davTransport.setArchiveName(_name);
        davTransport.asArchive(true);
        EventDataInterface evt = davTransport.publishResultPackage(rPkg, true);
        d.refresh();
        return evt;
    }

    public String getDescription() {
        DAVBinarypackage d = (DAVBinarypackage)this._repositoryObject;
        String desc = d.getDescription();
        if (desc != null && desc.length() > 0 && desc.charAt(0) == '\"' && desc.charAt(desc.length() - 1) == '\"') {
            desc = desc.substring(1, desc.length() - 1);
        }
        return desc;
    }

    @Override
    public String getDisplayName() throws ServiceException, RemoteException {
        String name = null;
        String desc = this.getDescription();
        name = desc == null || desc.equals("") ? this.getName() : desc;
        return name;
    }

    @Override
    public String getDisplayDescription() throws ServiceException, RemoteException {
        return this.getAbstract();
    }

    @Override
    public boolean isExpired() throws RemoteException, ServiceException {
        return PackageUtil.isExpired(this.getExpirationDate());
    }
}

