/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.CMetadata;
import com.sas.services.information.metadata.ChannelInterface;
import com.sas.services.information.metadata.KeywordFilter;
import java.rmi.RemoteException;
import java.util.Iterator;

@SASScope
public class ArchiveFilter
extends KeywordFilter {
    private static final long serialVersionUID = 2938991156915877083L;
    private String _name;
    private ChannelInterface _channel;

    public ArchiveFilter() {
        this.setType("Archive");
        this._name = null;
        this._channel = null;
    }

    public ArchiveFilter(String key, int relation, String value) {
        super(key, relation, value);
        this.setType("Archive");
        this._name = null;
        this._channel = null;
    }

    public String getOMRType() {
        return "ArchiveFile";
    }

    public String getLDAPType() {
        return "sasarchive";
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public ChannelInterface getChannel() {
        return this._channel;
    }

    public void setChannel(ChannelInterface channel) {
        this._channel = channel;
    }

    public String getXMLSelectString() {
        StringBuffer buffer;
        block16: {
            buffer = new StringBuffer();
            if (this._name != null || this._keywords.size() > 0) {
                buffer.append("<XMLSelect Search=\"*");
                if (this._name != null) {
                    buffer.append("[@Name='" + this._name + "']");
                }
                if (this._keywords.size() > 0) {
                    buffer.append("[Keywords/*[");
                    Iterator it = this._keywords.iterator();
                    boolean firstName = true;
                    while (it.hasNext()) {
                        if (!firstName) {
                            buffer.append(" OR ");
                        }
                        buffer.append("@Name='" + (String)it.next() + '\'');
                        firstName = false;
                    }
                    buffer.append(" ]]");
                }
                buffer.append("\" />\n");
                if (this._channel != null) {
                    try {
                        Object o = this._channel.getRepositoryEntity();
                        if (!(o instanceof CMetadata)) break block16;
                        String channelName = null;
                        try {
                            channelName = this._channel.getName();
                        }
                        catch (RemoteException rex) {
                            channelName = "RemoteException";
                        }
                        buffer.append("<Templates>\n");
                        buffer.append("  <ArchiveFile Id=\"\" Name=\"\">\n");
                        buffer.append("    <OwningChannel search=\"@Name='" + channelName + "'\" />\n");
                        buffer.append("  </ArchiveFile>\n");
                        buffer.append("  <Channel id=\"\" Name=\"\" />\n");
                        buffer.append("</Templates>\n");
                    }
                    catch (RemoteException o) {}
                }
            } else if (this._channel != null) {
                try {
                    Object o = this._channel.getRepositoryEntity();
                    if (!(o instanceof CMetadata)) break block16;
                    String channelName = null;
                    try {
                        channelName = this._channel.getName();
                    }
                    catch (RemoteException rex) {
                        channelName = "RemoteException";
                    }
                    buffer.append("<XMLSelect Search=\"*[OwningChannel/*[@Name='" + channelName + "']]\" />\n");
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        return buffer.toString();
    }
}

