/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.archive;

import com.sas.codepolicy.SASScope;
import com.sas.io.InputStreamAdapter;
import com.sas.services.publish.archive.ArchiveInputStreamWrapper;
import com.sas.services.publish.archive.RB;
import com.sas.text.Message;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
class ArchiveZipTable {
    private ZipInputStream _zis;
    private String _filename;
    private ZipFile _file;
    private int _streamCounter = 0;
    private Vector _fileEntryNames;
    private Logger logger = LogManager.getLogger(ArchiveZipTable.class);

    ArchiveZipTable(String filename) throws FileNotFoundException, IllegalArgumentException {
        if (filename == null) {
            throw new IllegalArgumentException(RB.getStringResource("ArchiveZipTable.nullName.ex.txt"));
        }
        this._filename = filename;
        this.getEntryNames();
    }

    ArchiveZipTable(InputStream stream) {
        if (stream != null) {
            this._zis = new ZipInputStream(new BufferedInputStream(stream));
        }
        this.getEntryNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        boolean deleted = false;
        String name = this.getName();
        try {
            if (this._file != null) {
                this._file.close();
            }
        }
        catch (Exception e) {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveZipTable.closeErr.fmt.txt", (Object)this._filename), (Throwable)e);
            }
        }
        finally {
            this._file = null;
        }
        if (name != null) {
            File f = new File(name);
            deleted = f.delete();
        }
        return deleted;
    }

    protected final synchronized void close() {
        if (this._streamCounter != 0 && this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveZipTable.close.fmt.txt", (Object)this._filename));
        }
        try {
            if (this._file != null) {
                this._file.close();
            }
        }
        catch (Exception e) {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveZipTable.closeErr.fmt.txt", (Object)this._filename), (Throwable)e);
            }
        }
        finally {
            this._file = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected final ZipFile getZipFile() {
        block4: {
            if (this._file != null) {
                return this._file;
            }
            if (this._filename != null) {
                try {
                    this._file = new ZipFile(this._filename);
                }
                catch (IOException e) {
                    if (this.logger == null) break block4;
                    this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveZipTable.openErr.fmt.txt", (Object)this._filename), (Throwable)e);
                }
            }
        }
        return this._file;
    }

    protected final InputStream getZipInputStream() throws IOException, RemoteException {
        if (this._zis != null) {
            return this._zis;
        }
        ZipFile file = this.getZipFile();
        if (file != null) {
            this._zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(file.getName())));
            this.increment();
            return new ArchiveInputStreamWrapper(this._zis, this);
        }
        return this._zis;
    }

    protected final InputStream getPackageInputStream() throws IOException, RemoteException {
        InputStreamAdapter is = null;
        if (this._filename != null) {
            is = new InputStreamAdapter((InputStream)new FileInputStream(this._filename));
        }
        return is;
    }

    protected ZipEntry createZipEntry(ZipEntry ze) {
        byte[] bytes;
        long value;
        ZipEntry entry = this.createZipEntry(ze.getName());
        String data = ze.getComment();
        if (data != null) {
            entry.setComment(data);
        }
        if ((value = (long)ze.getMethod()) != -1L) {
            entry.setMethod((int)value);
        }
        if ((value = ze.getSize()) != -1L) {
            entry.setSize(value);
        }
        if ((bytes = ze.getExtra()) != null) {
            entry.setExtra(bytes);
        }
        if ((value = ze.getCrc()) != -1L) {
            entry.setCrc(value);
        }
        return entry;
    }

    protected ZipEntry createZipEntry(String name) {
        return new ZipEntry(name);
    }

    public Enumeration entries() {
        return new Enumeration(){
            private Enumeration keys;

            @Override
            public boolean hasMoreElements() {
                if (this.keys == null) {
                    this.keys = ArchiveZipTable.this.getEntryNames();
                }
                return this.keys.hasMoreElements();
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                Object key = this.keys.nextElement();
                return ArchiveZipTable.this.getEntry(key.toString());
            }
        };
    }

    protected final Enumeration getEntryNames() {
        if (this._fileEntryNames != null) {
            return this._fileEntryNames.elements();
        }
        ZipFile file = this.getZipFile();
        if (file != null) {
            this._fileEntryNames = new Vector(file.size());
            Enumeration<? extends ZipEntry> enumeration = file.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry ze = enumeration.nextElement();
                this._fileEntryNames.addElement(ze.getName());
            }
            this._fileEntryNames.trimToSize();
        } else {
            this._fileEntryNames = new Vector(0);
        }
        return this._fileEntryNames.elements();
    }

    public ZipEntry getEntry(String name) {
        if (name == null) {
            return null;
        }
        ZipFile file = this.getZipFile();
        ZipEntry ze = null;
        if (ze == null && file != null) {
            ze = file.getEntry(name);
        }
        return ze;
    }

    public synchronized InputStream getInputStream(Object key) throws IOException {
        ZipFile file;
        ZipEntry ze = null;
        if (key != null) {
            ze = this.getEntry(key.toString());
        }
        if (ze != null && (file = this.getZipFile()) != null) {
            InputStream stream = file.getInputStream(ze);
            this.increment();
            return new ArchiveInputStreamWrapper(stream, this);
        }
        return null;
    }

    protected synchronized void increment() {
        ++this._streamCounter;
    }

    protected synchronized void decrement() {
        --this._streamCounter;
        if (this._streamCounter == 0) {
            this.close();
        }
    }

    public String getName() {
        String name = null;
        ZipFile file = this.getZipFile();
        if (file != null) {
            name = file.getName();
        }
        return name;
    }
}

