/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.archive;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.services.ParseException;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.information.metadata.ContentDestination;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.information.metadata.FtpServerInterface;
import com.sas.services.information.metadata.HttpServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.publish.AbstractTransport;
import com.sas.services.publish.BinaryFileEntryInterface;
import com.sas.services.publish.DatasetEntryInterface;
import com.sas.services.publish.EntryInterface;
import com.sas.services.publish.EventDataInterface;
import com.sas.services.publish.HTMLEncodingParser;
import com.sas.services.publish.HTMLEntryInterface;
import com.sas.services.publish.HTMLFileInterface;
import com.sas.services.publish.ReferenceEntryInterface;
import com.sas.services.publish.ResultPackageEventBuilder;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.TextFileEntryInterface;
import com.sas.services.publish.ViewerEntryInterface;
import com.sas.services.publish.archive.ArchiveBinaryFileEntry;
import com.sas.services.publish.archive.ArchiveDatasetEntry;
import com.sas.services.publish.archive.ArchiveEntry;
import com.sas.services.publish.archive.ArchiveHTMLEntry;
import com.sas.services.publish.archive.ArchiveHTMLFile;
import com.sas.services.publish.archive.ArchiveLibraryMemberEntry;
import com.sas.services.publish.archive.ArchiveReferenceEntry;
import com.sas.services.publish.archive.ArchiveResultPackage;
import com.sas.services.publish.archive.ArchiveTextFileEntry;
import com.sas.services.publish.archive.ArchiveTransportInterface;
import com.sas.services.publish.archive.ArchiveViewerEntry;
import com.sas.services.publish.archive.ArchiveZipTable;
import com.sas.services.publish.archive.Encoding;
import com.sas.services.publish.archive.RB;
import com.sas.services.publish.metadata.PackageInterface;
import com.sas.services.publish.metadata.PackageUtil;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.util.AttributeMap;
import com.sas.services.util.AttributeMapInterface;
import com.sas.services.util.DateUtil;
import com.sas.services.util.Names;
import com.sas.services.util.URIUtil;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.ResourceFactory;
import com.sas.services.webdav.ResourceInterface;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

@SASScope
public class ArchiveTransport
extends AbstractTransport
implements ArchiveTransportInterface {
    private static final int EXTRAFIELD_41 = 65;
    private static final int EXTRAFIELD_53 = 83;
    private static final int EXTRAFIELD_47 = 71;
    private static final int EXTRAFIELD2_F0 = 240;
    private static final int EXTRAFIELD1_80 = 128;
    private static final int LINEFEED = 10;
    private static final int ARRAY_SIZE_4096 = 4096;
    private File _file;
    private File _replicatedFile;
    private String _extractionDirectory;
    private int _currRef;
    private int _coll;
    private PackageInterface _packageSmartObject = null;
    private UserContextInterface _userContext = null;
    private ResourceInterface _davResource = null;
    private InputStream _inputStream = null;
    private String _contentFilename = null;
    private ContentDestination _contentDestination = null;
    static final char EQUAL = '=';
    static final char BLANK = ' ';
    static final char SINGLEQUOTE = '\'';
    static final String DOUBLE_UNDERSCORE = "__";
    private static final String UTF8_ENCODING = "UTF-8";
    private final TimeZone _gmtTimeZone = TimeZone.getTimeZone("GMT");
    private int _nestedIdx = 0;
    private Logger logger = LogManager.getLogger(ArchiveTransport.class);

    public ArchiveTransport(File file, Logger logger, SessionContextInterface sessionContext) throws IllegalArgumentException, TransportException {
        if (file == null) {
            throw new IllegalArgumentException(RB.getStringResource("ArchiveTransport.illegalArgument.ex.txt"));
        }
        this._file = file;
        this.setSessionContext(sessionContext);
        if (logger != null) {
            this.setLogger(logger);
        }
    }

    public ArchiveTransport(File file, SessionContextInterface sessionContext) throws IllegalArgumentException, TransportException {
        this(file, null, sessionContext);
    }

    public ArchiveTransport(PackageInterface pkg, SessionContextInterface sessionContext) throws IllegalArgumentException, TransportException {
        this(pkg, null, sessionContext);
    }

    public ArchiveTransport(PackageInterface pkg, Logger logger) throws IllegalArgumentException, TransportException {
        this(pkg, logger, null);
    }

    public ArchiveTransport(PackageInterface pkg, Logger logger, SessionContextInterface sessionContext) throws IllegalArgumentException, TransportException {
        if (pkg == null) {
            throw new IllegalArgumentException(RB.getStringResource("ArchiveTransport.nullPkg.ex.txt"));
        }
        this._packageSmartObject = pkg;
        this.setSessionContext(sessionContext);
        try {
            this._userContext = this._packageSmartObject.getRepository().getUserContext();
            if (logger != null) {
                this.setLogger(logger);
            }
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
        }
    }

    public ArchiveTransport(InputStream stream, SessionContextInterface sessionContext) throws IllegalArgumentException, TransportException {
        this(stream, null, sessionContext);
    }

    public ArchiveTransport(InputStream stream, Logger logger, SessionContextInterface sessionContext) throws IllegalArgumentException, TransportException {
        if (stream == null) {
            throw new IllegalArgumentException(RB.getStringResource("ArchiveTransport.nullStream.ex.txt"));
        }
        this._inputStream = stream;
        this.setSessionContext(sessionContext);
        if (logger != null) {
            this.setLogger(logger);
        }
    }

    public ArchiveTransport(ResourceInterface davResource, SessionContextInterface sessionContext) throws IllegalArgumentException, TransportException {
        this(davResource, null, sessionContext);
    }

    public ArchiveTransport(ResourceInterface davResource, Logger logger, SessionContextInterface sessionContext) throws IllegalArgumentException, TransportException {
        if (davResource == null) {
            throw new IllegalArgumentException(RB.getStringResource("ArchiveTransport.nullPkg.ex.txt"));
        }
        this._davResource = davResource;
        this.setSessionContext(sessionContext);
        if (logger != null) {
            this.setLogger(logger);
        }
    }

    public ArchiveTransport(ContentDestination content, Logger logger, SessionContextInterface sessionContext) throws IllegalArgumentException, TransportException {
        this(content, logger, sessionContext, null);
    }

    public ArchiveTransport(ContentDestination content, Logger logger, SessionContextInterface sessionContext, String filename) throws IllegalArgumentException, TransportException {
        if (content == null) {
            throw new IllegalArgumentException(RB.getStringResource("ArchiveTransport.nullPkg.ex.txt"));
        }
        this._contentDestination = content;
        this._contentFilename = filename;
        this.setSessionContext(sessionContext);
        if (logger != null) {
            this.setLogger(logger);
        }
    }

    public ArchiveTransport(ContentDestination content, SessionContextInterface sessionContext, String filename) throws IllegalArgumentException, TransportException {
        this(content, null, sessionContext, filename);
    }

    @Override
    public String getName() {
        String name = null;
        if (this._file != null) {
            name = this._file.getName();
        } else if (this._contentFilename != null) {
            name = this._contentFilename;
        } else if (this._replicatedFile != null) {
            name = this._replicatedFile.getName();
        }
        return name;
    }

    @Override
    public void setExtractionDirectoryName(String directoryName) {
        char c;
        this._extractionDirectory = directoryName;
        if (this._extractionDirectory == null) {
            return;
        }
        for (int len = this._extractionDirectory.length(); len > 0 && (c = this._extractionDirectory.charAt(len - 1)) == File.separatorChar; --len) {
            this._extractionDirectory = this._extractionDirectory.substring(0, len - 1);
        }
    }

    @Override
    public String getExtractionDirectoryName() {
        return this._extractionDirectory;
    }

    @Override
    public ResultPackageInterface getResultPackage() throws TransportException {
        ArchiveResultPackage rPkg;
        block8: {
            rPkg = null;
            try {
                rPkg = this._packageSmartObject != null ? (ArchiveResultPackage)this.getServiceObject() : (this._davResource != null ? (ArchiveResultPackage)this.getDavPackage() : (this._inputStream != null || this._replicatedFile != null ? (ArchiveResultPackage)this.replicatePackage() : (this._extractionDirectory == null ? new ArchiveResultPackage(this, this._file.getCanonicalPath()) : new ArchiveResultPackage(this, this._file.getCanonicalPath(), this._extractionDirectory, false))));
                this.initializeResultPackage(rPkg, false);
            }
            catch (RemoteException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
            }
            SessionContextInterface sessionContext = this.getSessionContext();
            if (sessionContext != null) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(RB.getStringResource("ArchiveTransport.trackInSession.txt"));
                }
                try {
                    String key = "com.sas.services.publish." + rPkg.getUniqueId();
                    sessionContext.setAttribute(key, (java.lang.Object)rPkg);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(RB.getStringResource("ArchiveTransport.successfulTrackInSession.txt"));
                    }
                }
                catch (RemoteException e) {
                    if (this.logger == null) break block8;
                    this.logger.warn(RB.getStringResource("ArchiveTransport.failedToTrackInSession.txt"), (Throwable)e);
                }
            }
        }
        return rPkg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public EventDataInterface publishResultPackage(ResultPackageInterface rpkg, boolean buildEvent) throws TransportException {
        EventDataInterface eventData = null;
        boolean ifExists = false;
        boolean fileNotFoundException = false;
        this._nestedIdx = 0;
        if (this._file != null) {
            ifExists = this._file.exists();
            try {
                try {
                    this._currRef = 1;
                    this._coll = 1;
                    this.createZipPackage(this._file.getCanonicalPath(), rpkg);
                }
                catch (IOException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
                }
                catch (TransportException e) {
                    if (!(e.getRootException() instanceof FileNotFoundException)) throw e;
                    fileNotFoundException = true;
                    throw e;
                }
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(RB.getStringResource("ArchiveTransport.successfulPkgPub.txt"));
                }
                if (!buildEvent) return eventData;
                ResultPackageEventBuilder builder = new ResultPackageEventBuilder();
                try {
                    return builder.buildEvent(rpkg, this._file.toURL().toString(), null, "archive", null);
                }
                catch (IOException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.eventError.ex.txt"));
                }
            }
            catch (TransportException e) {
                if (ifExists) {
                    if (fileNotFoundException) throw e;
                }
                this._file.delete();
                throw e;
            }
        }
        if (this._contentDestination == null) return eventData;
        return this.publishToServer(rpkg, buildEvent);
    }

    private EventDataInterface publishToServer(ResultPackageInterface rpkg, boolean buildEvent) throws TransportException {
        EventDataInterface eventData = null;
        URL u = null;
        try {
            u = PackageUtil.getServerURL(this._contentDestination);
        }
        catch (ServiceException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
        }
        if (u.getProtocol().equalsIgnoreCase("http")) {
            this.publishToHttpServer(rpkg, buildEvent, u);
        } else {
            eventData = this.publishToFtpServer(rpkg, buildEvent, u);
        }
        return eventData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventDataInterface publishToHttpServer(ResultPackageInterface rpkg, boolean buildEvent, URL u) throws TransportException {
        String finalUrl;
        EventDataInterface eventData;
        block40: {
            String localFilename;
            String localFilePath;
            eventData = null;
            File spkFile = null;
            finalUrl = null;
            SessionContextInterface sessionContext = null;
            UserContextInterface uc = null;
            FileInputStream fis = null;
            if (this._contentFilename == null) {
                try {
                    File f = File.createTempFile(Names.generateName((int)0), ".spk");
                    f.deleteOnExit();
                    localFilePath = f.getCanonicalPath();
                    localFilename = f.getName();
                }
                catch (IOException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
                }
            } else {
                String tempDir = System.getProperty("java.io.tmpdir");
                StringBuffer buf = new StringBuffer();
                buf.append(tempDir);
                if (!tempDir.endsWith(File.separator)) {
                    buf.append(File.separator);
                }
                buf.append(this._contentFilename);
                localFilePath = buf.toString();
                localFilename = this._contentFilename;
            }
            this._currRef = 1;
            this._coll = 1;
            try {
                this.createZipPackage(localFilePath, rpkg);
            }
            catch (TransportException e) {
                spkFile = new File(localFilePath);
                spkFile.delete();
                spkFile = null;
                throw e;
            }
            try {
                try {
                    spkFile = new File(localFilePath);
                    sessionContext = this.getSessionContext();
                    if (sessionContext != null) {
                        uc = this.getSessionContext().getUserContext();
                    }
                    u = PackageUtil.getServerURL(this._contentDestination);
                }
                catch (ServiceException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
                }
                catch (IOException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
                }
                try {
                    HttpServerInterface hs = (HttpServerInterface)this._contentDestination.getServer();
                    String proxy = hs.getProxyUrl();
                    URL proxyUrl = null;
                    if (proxy != null && proxy.length() > 0) {
                        proxyUrl = new URL(proxy);
                    }
                    final String loginTitle = hs.getName() == null ? "" : Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.promptForServer.fmt.txt", (java.lang.Object)hs.getName());
                    String authType = hs.getAuthenticationType();
                    String user = null;
                    String pw = null;
                    Iterator iItor = null;
                    if (uc != null) {
                        if (authType.equalsIgnoreCase("metadata")) {
                            UserIdentityInterface ui = uc.getAuthServer().generatePassword(null);
                            user = (String)ui.getPrincipal();
                            pw = (String)ui.getCredential();
                        } else {
                            Iterator it = hs.getDomains().iterator();
                            if (it.hasNext()) {
                                UserIdentityInterface ui;
                                final String domain = (String)it.next();
                                final UserContextInterface userContext = uc;
                                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                                    public java.lang.Object run() throws Exception {
                                        return userContext.getIdentitiesByDomain(domain, true, loginTitle);
                                    }
                                };
                                List ilist = null;
                                try {
                                    ilist = (List)AccessController.doPrivileged(action);
                                }
                                catch (PrivilegedActionException pae) {
                                    throw new TransportException(pae.getCause(), RB.getStringResource("ArchiveTransport.httpErr.ex.txt"));
                                }
                                iItor = ilist.iterator();
                                if (iItor.hasNext() && (ui = (UserIdentityInterface)iItor.next()) != null) {
                                    user = (String)ui.getPrincipal();
                                    pw = (String)ui.getCredential();
                                }
                            }
                        }
                    }
                    ResourceInterface res = null;
                    String pubName = localFilename;
                    boolean done = false;
                    finalUrl = u.toExternalForm();
                    finalUrl = URIUtil.addSegment((String)finalUrl, (String)pubName);
                    ConnectionInfo c = new ConnectionInfo(finalUrl);
                    if (proxyUrl != null) {
                        c.setProxyURL(proxyUrl);
                    }
                    while (!done) {
                        try {
                            if (user != null) {
                                c.setUser(user);
                            }
                            if (pw != null) {
                                c.setPW(pw);
                            }
                            if ((res = ResourceFactory.bindResource((ConnectionInfo)c)).exists()) {
                                pubName = Names.generateName((int)0) + ".spk";
                                finalUrl = URIUtil.addSegment((String)u.toExternalForm(), (String)pubName);
                                c.setUrl(finalUrl);
                                if (uc == null || !authType.equalsIgnoreCase("metadata")) continue;
                                UserIdentityInterface ui = uc.getAuthServer().generatePassword(null);
                                user = (String)ui.getPrincipal();
                                pw = (String)ui.getCredential();
                                continue;
                            }
                            done = true;
                        }
                        catch (DAVException e) {
                            if (iItor != null && iItor.hasNext()) {
                                if (this.logger != null && this.logger.isInfoEnabled()) {
                                    this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.pubHttpRetry.fmt.txt", (java.lang.Object)finalUrl, (java.lang.Object)e.getMessage()));
                                }
                                UserIdentityInterface identity = (UserIdentityInterface)iItor.next();
                                user = (String)identity.getPrincipal();
                                pw = (String)identity.getCredential();
                                continue;
                            }
                            done = true;
                            throw e;
                        }
                    }
                    this._contentFilename = pubName;
                    fis = new FileInputStream(spkFile);
                    res.setContents((InputStream)fis);
                }
                catch (DAVException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.httpErr.ex.txt"));
                }
                catch (ServiceException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.httpErr.ex.txt"));
                }
                catch (RemoteException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.httpErr.ex.txt"));
                }
                catch (IOException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.httpErr.ex.txt"));
                }
                if (fis != null) {
                    this.closeInputStream(fis);
                    fis = null;
                }
                if (spkFile == null) break block40;
                spkFile.delete();
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    this.closeInputStream(fis);
                    fis = null;
                }
                if (spkFile != null) {
                    spkFile.delete();
                    spkFile = null;
                }
                throw throwable;
            }
            spkFile = null;
        }
        if (buildEvent) {
            ResultPackageEventBuilder builder = new ResultPackageEventBuilder();
            eventData = builder.buildEvent(rpkg, finalUrl, null, "archive", null);
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.serverPub.fmt.txt", (java.lang.Object)finalUrl));
        }
        return eventData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventDataInterface publishToFtpServer(ResultPackageInterface rpkg, boolean buildEvent, URL u) throws TransportException {
        String localFilename;
        String localFilePath;
        EventDataInterface eventData = null;
        File spkFile = null;
        String finalUrl = null;
        ConnectionInterface connection = null;
        SessionContextInterface sessionContext = null;
        UserContextInterface uc = null;
        FileInputStream fis = null;
        IBinaryStream bs = null;
        if (this._contentFilename == null) {
            try {
                File f = File.createTempFile(Names.generateName((int)0), ".spk");
                f.deleteOnExit();
                localFilePath = f.getCanonicalPath();
                localFilename = f.getName();
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
            }
        } else {
            String tempDir = System.getProperty("java.io.tmpdir");
            StringBuffer buf = new StringBuffer();
            buf.append(tempDir);
            if (!tempDir.endsWith(File.separator)) {
                buf.append(File.separator);
            }
            buf.append(this._contentFilename);
            localFilePath = buf.toString();
            localFilename = this._contentFilename;
        }
        this._currRef = 1;
        this._coll = 1;
        try {
            this.createZipPackage(localFilePath, rpkg);
        }
        catch (TransportException e) {
            spkFile = new File(localFilePath);
            spkFile.delete();
            spkFile = null;
            throw e;
        }
        try {
            try {
                spkFile = new File(localFilePath);
                sessionContext = this.getSessionContext();
                if (sessionContext != null) {
                    uc = this.getSessionContext().getUserContext();
                }
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
            }
            try {
                Iterator it;
                DirectoryInterface dir = this._contentDestination.getDirectory();
                LogicalServerInterface logicalServer = null;
                ServerInterface currentServer = null;
                IFileService fileService = null;
                List servers = dir.getServers();
                Iterator serverIt = servers.iterator();
                boolean foundIOM = false;
                while (serverIt.hasNext()) {
                    currentServer = (ServerInterface)serverIt.next();
                    for (String type : currentServer.getServiceTypes()) {
                        if (!type.equals("Logical IOM Server")) continue;
                        foundIOM = true;
                        break;
                    }
                    if (!foundIOM) continue;
                    logicalServer = (LogicalServerInterface)currentServer;
                    break;
                }
                if (logicalServer == null) {
                    throw new TransportException(RB.getStringResource("ArchiveTransport.noFtpServer.ex.txt"));
                }
                SessionContextInterface sc = this.getSessionContext();
                String longLivedUser = null;
                if (sc != null && (longLivedUser = (String)sc.getAttribute("com.sas.services.connection.platform.privilegedUserNameKey")) != null && this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(RB.getStringResource("ArchiveCommon.privUser.txt"));
                }
                PlatformConnectionFactoryConfiguration config = new PlatformConnectionFactoryConfiguration(logicalServer, longLivedUser);
                PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)config);
                connection = cxf.getConnection(uc);
                Object obj = connection.getObject();
                IWorkspace iWorkspace = IWorkspaceHelper.narrow((Object)obj);
                fileService = iWorkspace.FileService();
                FtpServerInterface fs = (FtpServerInterface)this._contentDestination.getServer();
                final String loginTitle = fs.getName() == null ? "" : Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.promptForServer.fmt.txt", (java.lang.Object)fs.getName());
                String ftpUser = null;
                String ftpPw = null;
                Iterator ftpItor = null;
                if (uc != null && (it = fs.getDomains().iterator()).hasNext()) {
                    final String ftpDomain = (String)it.next();
                    final UserContextInterface userContext = uc;
                    PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                        public java.lang.Object run() throws Exception {
                            return userContext.getIdentitiesByDomain(ftpDomain, true, loginTitle);
                        }
                    };
                    List ilist = null;
                    try {
                        ilist = (List)AccessController.doPrivileged(action);
                    }
                    catch (PrivilegedActionException pae) {
                        throw new TransportException(pae.getCause(), RB.getStringResource("ArchiveTransport.ftpErr.ex.txt"));
                    }
                    ftpItor = ilist.iterator();
                    if (ftpItor.hasNext()) {
                        UserIdentityInterface ui = (UserIdentityInterface)ftpItor.next();
                        ftpUser = (String)ui.getPrincipal();
                        try {
                            ftpPw = SasPasswordString.decode((String)((String)ui.getCredential()));
                        }
                        catch (SasPasswordEncodingException e) {
                            ftpPw = (String)ui.getCredential();
                        }
                    }
                }
                finalUrl = URIUtil.addSegment((String)u.toExternalForm(), (String)localFilename);
                StringHolder stringHolder = new StringHolder();
                IFileref fileref = null;
                String requestedName = "";
                String accessMethod = "FTP";
                String externalFile = null;
                String hostOptions = "";
                externalFile = u.getPath().length() == 0 ? localFilename : URIUtil.addSegment((String)u.getPath(), (String)localFilename);
                boolean done = false;
                while (!done) {
                    try {
                        int len;
                        StringBuffer buf = new StringBuffer();
                        buf.append("host='");
                        buf.append(u.getHost());
                        buf.append("' ");
                        buf.append("port=");
                        buf.append(u.getPort());
                        buf.append(" ");
                        if (ftpUser != null) {
                            buf.append("user='");
                            buf.append(ftpUser);
                            buf.append("' pass='");
                            buf.append(ftpPw);
                            buf.append("'");
                        }
                        hostOptions = buf.toString();
                        fileref = fileService.AssignFileref(requestedName, accessMethod, externalFile, hostOptions, stringHolder);
                        StreamOpenMode mode = StreamOpenMode.StreamOpenModeForWriting;
                        bs = fileref.OpenBinaryStream(mode);
                        fis = new FileInputStream(spkFile);
                        byte[] buffer = new byte[4096];
                        while ((len = fis.read(buffer)) > 0) {
                            if (len < 4096) {
                                byte[] bb = new byte[len];
                                System.arraycopy(buffer, 0, bb, 0, len);
                                bs.Write(bb);
                                continue;
                            }
                            bs.Write(buffer);
                        }
                        if (bs != null) {
                            bs.Close();
                            bs = null;
                        }
                        fileService.DeassignFileref(stringHolder.value);
                        done = true;
                    }
                    catch (Exception e) {
                        if (ftpItor != null && ftpItor.hasNext()) {
                            if (fis != null) {
                                this.closeInputStream(fis);
                                fis = null;
                            }
                            try {
                                if (bs != null) {
                                    bs.Close();
                                    bs = null;
                                }
                            }
                            catch (GenericError mode) {
                                // empty catch block
                            }
                            if (this.logger != null && this.logger.isInfoEnabled()) {
                                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.pubFtpRetry.fmt.txt", (java.lang.Object)finalUrl, (java.lang.Object)e.getMessage()));
                            }
                            UserIdentityInterface identity = (UserIdentityInterface)ftpItor.next();
                            ftpUser = (String)identity.getPrincipal();
                            try {
                                ftpPw = SasPasswordString.decode((String)((String)identity.getCredential()));
                            }
                            catch (SasPasswordEncodingException see) {
                                ftpPw = (String)identity.getCredential();
                            }
                            continue;
                        }
                        done = true;
                        throw e;
                    }
                }
                this._contentFilename = localFilename;
            }
            catch (Exception e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.ftpErr.ex.txt"));
            }
        }
        finally {
            if (fis != null) {
                this.closeInputStream(fis);
                fis = null;
            }
            try {
                if (bs != null) {
                    bs.Close();
                }
            }
            catch (GenericError e) {}
            if (spkFile != null) {
                spkFile.delete();
                spkFile = null;
            }
            if (connection != null) {
                connection.close();
                connection = null;
            }
        }
        if (buildEvent) {
            ResultPackageEventBuilder builder = new ResultPackageEventBuilder();
            eventData = builder.buildEvent(rpkg, finalUrl, null, "archive", null);
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.serverPub.fmt.txt", (java.lang.Object)finalUrl));
        }
        return eventData;
    }

    private void createZipPackage(String name, ResultPackageInterface rpkg) throws TransportException {
        ZipOutputStream zos = null;
        FileOutputStream fos = null;
        ByteArrayOutputStream baos = null;
        DataOutputStream dos = null;
        try {
            fos = new FileOutputStream(name);
            zos = new ZipOutputStream(fos);
            ZipEntry zipEntry = new ZipEntry("PackageMetaData");
            StringBuffer buf = new StringBuffer();
            buf.append("__type__=meta");
            if (rpkg.getDescription() != null) {
                buf.append(" __desc__=");
                buf.append('\"');
                buf.append(rpkg.getDescription());
                buf.append('\"');
            }
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            this.buildExtraField1(dos, buf.toString());
            this.buildExtraField2(dos, rpkg.getNameValuePairs());
            dos.flush();
            zipEntry.setExtra(baos.toByteArray());
            zos.putNextEntry(zipEntry);
            dos.close();
            baos.close();
            dos = null;
            baos = null;
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            dos.writeInt(2);
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.setTime(new Date());
            double sasCreation = DateUtil.javaDateToSASDateTime((long)calendar.getTime().getTime(), (TimeZone)this._gmtTimeZone);
            dos.writeDouble(sasCreation);
            long expirationLong = rpkg.getExpirationDateTime();
            if (expirationLong == 0L) {
                calendar = Calendar.getInstance();
                calendar.clear();
                calendar.set(9999, 11, 31, 23, 59, 59);
                calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            } else {
                calendar = Calendar.getInstance();
                calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                calendar.setTime(new Date(expirationLong));
            }
            double sasExpiration = DateUtil.javaDateToSASDateTime((long)calendar.getTime().getTime(), (TimeZone)this._gmtTimeZone);
            dos.writeDouble(sasExpiration);
            String pAbstract = rpkg.getAbstract();
            if (pAbstract != null) {
                byte[] bufBytes = pAbstract.getBytes(UTF8_ENCODING);
                dos.writeInt(bufBytes.length);
                dos.write(bufBytes);
            } else {
                dos.writeInt(0);
            }
            dos.writeByte(0);
            dos.flush();
            baos.writeTo(zos);
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
        }
        int position = 0;
        try {
            EntryInterface[] entries = rpkg.getEntries();
            for (int i = 0; i < entries.length; ++i) {
                EntryInterface entry = entries[i];
                if (entry instanceof ResultPackageInterface) {
                    StringBuffer buf;
                    String nestedName = ((ResultPackageInterface)entry).getName();
                    if (nestedName == null) {
                        buf = new StringBuffer();
                        buf.append(Names.generateName((int)0));
                        if (this._nestedIdx > 0) {
                            buf.append("_");
                            buf.append(this._nestedIdx);
                        }
                        ++this._nestedIdx;
                        buf.append(".spk");
                        nestedName = buf.toString();
                    } else {
                        buf = new StringBuffer(nestedName);
                        buf.append(".spk");
                        nestedName = buf.toString();
                    }
                    File f = File.createTempFile(nestedName, ".spk");
                    f.deleteOnExit();
                    this.createZipPackage(f.getCanonicalPath(), (ResultPackageInterface)entry);
                    this.publishNestedPackage(entry, zos, nestedName, f.getCanonicalPath(), position++);
                    continue;
                }
                if (entry instanceof ReferenceEntryInterface) {
                    this.publishReference(entry, zos, position++);
                    continue;
                }
                if (entry instanceof TextFileEntryInterface) {
                    this.publishTextFile(entry, zos, position++);
                    continue;
                }
                if (entry instanceof BinaryFileEntryInterface) {
                    this.publishBinaryFile(entry, zos, position++);
                    continue;
                }
                if (entry instanceof ViewerEntryInterface) {
                    this.publishViewer(entry, zos, position++);
                    continue;
                }
                if (!(entry instanceof HTMLEntryInterface)) continue;
                position = this.publishHTML(entry, zos, position);
            }
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                    fos = null;
                }
                catch (IOException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
                }
                zos = null;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
                }
                fos = null;
            }
            if (dos != null) {
                try {
                    dos.close();
                    baos = null;
                }
                catch (IOException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
                }
                dos = null;
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
                }
                baos = null;
            }
        }
    }

    private int convertToLittleEndian(int i) {
        return i >> 24 | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24;
    }

    private void publishReference(EntryInterface entry, ZipOutputStream zos, int position) throws TransportException {
        StringBuffer buf = new StringBuffer();
        buf.append("sas");
        if (this._currRef < 10) {
            buf.append("00");
        } else if (this._currRef < 100) {
            buf.append("0");
        }
        buf.append(Integer.toString(this._currRef));
        buf.append(".ref");
        ++this._currRef;
        String reference = null;
        ByteArrayOutputStream baos = null;
        OutputStreamWriter outWriter = null;
        try {
            reference = ((ReferenceEntryInterface)entry).getReference();
            ZipEntry zipEntry = new ZipEntry(buf.toString());
            this.setExtraFields(zipEntry, entry, reference.length(), position);
            zos.putNextEntry(zipEntry);
            baos = new ByteArrayOutputStream();
            outWriter = new OutputStreamWriter((OutputStream)baos, UTF8_ENCODING);
            outWriter.write(reference);
            outWriter.write(13);
            outWriter.write(10);
            outWriter.flush();
            if (baos != null) {
                baos.writeTo(zos);
            }
            zos.closeEntry();
        }
        catch (UnsupportedEncodingException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.referenceTransportException.ex.txt"));
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.referenceTransportException.ex.txt"));
        }
        finally {
            if (outWriter != null) {
                try {
                    outWriter.close();
                }
                catch (IOException iOException) {}
                outWriter = null;
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
                baos = null;
            }
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.successfulReferencePub.fmt.txt", (java.lang.Object)reference));
        }
    }

    private void publishTextFile(EntryInterface entry, ZipOutputStream zos, int position) throws TransportException, RemoteException {
        TextFileEntryInterface file = (TextFileEntryInterface)entry;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedReader buffered = null;
        BufferedWriter bufferedWriter = null;
        try {
            buffered = new BufferedReader(file.getReader());
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, UTF8_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.textTransportException.ex.fmt.txt", (java.lang.Object)file.getName()));
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.pubTextIOException.ex.fmt.txt", (java.lang.Object)file.getName()));
        }
        String line = null;
        int maxLength = 0;
        try {
            while ((line = buffered.readLine()) != null) {
                bufferedWriter.write(line, 0, line.length());
                bufferedWriter.write(13);
                bufferedWriter.write(10);
                if (line.length() + 2 <= maxLength) continue;
                maxLength = line.length() + 2;
            }
            bufferedWriter.flush();
            ZipEntry zipEntry = new ZipEntry(file.getName());
            this.setExtraFields(zipEntry, entry, maxLength, position);
            zos.putNextEntry(zipEntry);
            baos.writeTo(zos);
            zos.closeEntry();
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.textTransportException.ex.fmt.txt", (java.lang.Object)file.getName()));
        }
        finally {
            if (buffered != null) {
                try {
                    buffered.close();
                }
                catch (IOException iOException) {}
                buffered = null;
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
                bufferedWriter = null;
            }
            if (baos != null) {
                this.closeOutputStream(baos);
                baos = null;
            }
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.successfulTextPub.fmt.txt", (java.lang.Object)file.getName()));
        }
    }

    private void publishBinaryFile(EntryInterface entry, ZipOutputStream zos, int position) throws TransportException, RemoteException {
        BinaryFileEntryInterface file = (BinaryFileEntryInterface)entry;
        InputStream is = null;
        try {
            ZipEntry zipEntry = new ZipEntry(file.getName());
            this.setExtraFields(zipEntry, entry, 0, position);
            zos.putNextEntry(zipEntry);
            is = file.getInputStream();
        }
        catch (ServiceException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.binaryTransportException.ex.fmt.txt", (java.lang.Object)file.getName()));
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.pubBinaryIOException.ex.fmt.txt", (java.lang.Object)file.getName()));
        }
        byte[] bb = new byte[4096];
        try {
            int len;
            while ((len = is.read(bb)) != -1) {
                zos.write(bb, 0, len);
            }
            zos.closeEntry();
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.binaryTransportException.ex.fmt.txt", (java.lang.Object)file.getName()));
        }
        finally {
            if (is != null) {
                this.closeInputStream(is);
            }
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.successfulBinaryPub.fmt.txt", (java.lang.Object)file.getName()));
        }
    }

    private void publishViewer(EntryInterface entry, ZipOutputStream zos, int position) throws TransportException, RemoteException {
        ViewerEntryInterface viewer = (ViewerEntryInterface)entry;
        if (viewer.getViewerType() == 1) {
            try {
                ZipEntry zipEntry = new ZipEntry(viewer.getName());
                this.setExtraFields(zipEntry, entry, 0, position);
                zos.putNextEntry(zipEntry);
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.pubViewerIOException.ex.fmt.txt", (java.lang.Object)viewer.getName()));
            }
            InputStream is = null;
            try {
                is = viewer.getInputStream();
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.pubViewerIOException.ex.fmt.txt", (java.lang.Object)viewer.getName()));
            }
            byte[] bb = new byte[4096];
            try {
                int len;
                while ((len = is.read(bb)) != -1) {
                    zos.write(bb, 0, len);
                }
                zos.closeEntry();
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.viewerTransportException.ex.fmt.txt", (java.lang.Object)viewer.getName()));
            }
            finally {
                if (is != null) {
                    this.closeInputStream(is);
                    is = null;
                }
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedReader buffered = null;
        BufferedWriter bufferedWriter = null;
        try {
            buffered = new BufferedReader(viewer.getReader());
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, UTF8_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.viewerTransportException.ex.fmt.txt", (java.lang.Object)viewer.getName()));
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.viewerTransportException.ex.fmt.txt", (java.lang.Object)viewer.getName()));
        }
        int maxLength = 0;
        try {
            String line;
            while ((line = buffered.readLine()) != null) {
                bufferedWriter.write(line, 0, line.length());
                bufferedWriter.write(13);
                bufferedWriter.write(10);
                if (line.length() + 2 <= maxLength) continue;
                maxLength = line.length() + 2;
            }
            bufferedWriter.flush();
            ZipEntry zipEntry = new ZipEntry(viewer.getName());
            this.setExtraFields(zipEntry, entry, maxLength, position);
            zos.putNextEntry(zipEntry);
            baos.writeTo(zos);
            zos.closeEntry();
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.viewerTransportException.ex.fmt.txt", (java.lang.Object)viewer.getName()));
        }
        finally {
            if (buffered != null) {
                try {
                    buffered.close();
                }
                catch (IOException iOException) {}
                buffered = null;
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
                bufferedWriter = null;
            }
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.successfulViewerPub.fmt.txt", (java.lang.Object)viewer.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishNestedPackage(EntryInterface entry, ZipOutputStream zos, String entryname, String filename, int position) throws TransportException, RemoteException {
        block11: {
            File file = null;
            FileInputStream fis = null;
            try {
                file = new File(filename);
                try {
                    fis = new FileInputStream(file);
                    ZipEntry zipEntry = new ZipEntry(entryname);
                    this.setExtraFields(zipEntry, entry, 0, position);
                    zos.putNextEntry(zipEntry);
                }
                catch (IOException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
                }
                byte[] buffer = new byte[4096];
                try {
                    int len;
                    while ((len = fis.read(buffer)) != -1) {
                        zos.write(buffer, 0, len);
                    }
                    zos.closeEntry();
                }
                catch (IOException e) {
                    throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.binaryTransportException.ex.fmt.txt", (java.lang.Object)entryname));
                }
                if (fis != null) {
                    this.closeInputStream(fis);
                    fis = null;
                }
                if (file == null) break block11;
                file.delete();
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    this.closeInputStream(fis);
                    fis = null;
                }
                if (file != null) {
                    file.delete();
                    file = null;
                }
                throw throwable;
            }
            file = null;
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.successfulNestedPkgPub.fmt.txt", (java.lang.Object)entryname));
        }
    }

    private int publishHTML(EntryInterface entry, ZipOutputStream zos, int position) throws TransportException, RemoteException {
        int len;
        int f;
        int fileType;
        HTMLEntryInterface html = (HTMLEntryInterface)entry;
        HTMLFileInterface file = null;
        InputStream is = null;
        int bodyCount = 0;
        int companionCount = 0;
        byte[] bb = null;
        file = html.getFile();
        if (file != null && (fileType = file.getRole()) == 1) {
            ++bodyCount;
        }
        HTMLFileInterface[] files = ((HTMLEntryInterface)entry).getCompanionFiles();
        for (f = 0; f < files.length; ++f) {
            file = files[f];
            fileType = file.getRole();
            if (fileType == 2) {
                ++bodyCount;
                continue;
            }
            if (fileType != 6) continue;
            ++companionCount;
        }
        file = html.getFile();
        if (file != null) {
            try {
                ZipEntry zipEntry = new ZipEntry(file.getName());
                this.setHTMLExtraFields(zipEntry, entry, file, bodyCount, companionCount, position++);
                zos.putNextEntry(zipEntry);
                is = file.getInputStream();
            }
            catch (ServiceException e) {
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.binaryTransportException.ex.fmt.txt", (java.lang.Object)file.getName()));
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.pubHtmlIOException.ex.fmt.txt", (java.lang.Object)file.getName()));
            }
            bb = new byte[4096];
            try {
                while ((len = is.read(bb)) != -1) {
                    zos.write(bb, 0, len);
                }
                zos.closeEntry();
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.successfulHTMLFilePub.fmt.txt", (java.lang.Object)file.getName()));
                }
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.binaryTransportException.ex.fmt.txt", (java.lang.Object)file.getName()));
            }
            finally {
                if (is != null) {
                    this.closeInputStream(is);
                    is = null;
                }
            }
        }
        for (f = 0; f < files.length; ++f) {
            file = files[f];
            try {
                ZipEntry zipEntry = new ZipEntry(file.getName());
                this.setHTMLExtraFields(zipEntry, entry, file, bodyCount, companionCount, position++);
                zos.putNextEntry(zipEntry);
                is = file.getInputStream();
            }
            catch (ServiceException e) {
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.binaryTransportException.ex.fmt.txt", (java.lang.Object)file.getName()));
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.pubHtmlIOException.ex.fmt.txt", (java.lang.Object)file.getName()));
            }
            if (bb == null) {
                bb = new byte[4096];
            }
            try {
                while ((len = is.read(bb)) != -1) {
                    zos.write(bb, 0, len);
                }
                zos.closeEntry();
                if (this.logger == null || !this.logger.isDebugEnabled()) continue;
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.successfulHTMLFilePub.fmt.txt", (java.lang.Object)file.getName()));
                continue;
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.binaryTransportException.ex.fmt.txt", (java.lang.Object)file.getName()));
            }
            finally {
                if (is != null) {
                    this.closeInputStream(is);
                    is = null;
                }
            }
        }
        ++this._coll;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(RB.getStringResource("ArchiveTransport.successfulHTMLPub.txt"));
        }
        return position;
    }

    private void setExtraFields(ZipEntry zipEntry, EntryInterface entry, int maxLength, int position) throws RemoteException, TransportException {
        String mime;
        StringBuffer buf = new StringBuffer();
        if (entry instanceof ResultPackageInterface) {
            buf.append("__type__=package");
        } else if (entry instanceof ReferenceEntryInterface) {
            buf.append("__type__=referen __version__=15 __refType__=");
            if (((ReferenceEntryInterface)entry).getReferenceType().equals("HTML")) {
                buf.append("html");
            } else {
                buf.append("url");
            }
        } else if (entry instanceof BinaryFileEntryInterface) {
            buf.append("__type__=binfile __version__=15");
            BinaryFileEntryInterface binFile = (BinaryFileEntryInterface)entry;
            if (binFile.getMIMEType() != null) {
                buf.append(" __mime__='");
                buf.append(binFile.getMIMEType());
                buf.append("'");
            }
        } else if (entry instanceof TextFileEntryInterface) {
            TextFileEntryInterface textFile = (TextFileEntryInterface)entry;
            buf.append("__type__=txtfile __version__=15 __maxl__=");
            buf.append(maxLength);
            mime = textFile.getMIMEType();
            if (mime != null) {
                buf.append(" __mime__='");
                buf.append(mime);
                buf.append("'");
            }
        } else if (entry instanceof ViewerEntryInterface) {
            ViewerEntryInterface viewer = (ViewerEntryInterface)entry;
            buf.append("__type__=viewer __version__=15 __viewer__=");
            if (viewer.getViewerType() == 1) {
                buf.append("html");
                Map m = null;
                try {
                    HTMLEncodingParser parser = new HTMLEncodingParser();
                    m = parser.parse(viewer);
                }
                catch (ParseException parser) {
                    // empty catch block
                }
                String userEncoding = viewer.getEncoding();
                if (m == null) {
                    buf.append(" __encodingOffset__=0");
                    buf.append(" __encoding__=");
                    if (userEncoding != null) {
                        buf.append(userEncoding);
                    } else {
                        buf.append("ISO-8859-1");
                    }
                } else {
                    buf.append(" __encodingOffset__=");
                    Integer eOffset = (Integer)m.get("OFFSET");
                    buf.append(eOffset);
                    buf.append(" __encoding__=");
                    buf.append(m.get("ENCODING"));
                }
            } else {
                buf.append("text");
            }
            mime = viewer.getMIMEType();
            if (mime != null) {
                buf.append(" __mime__='");
                buf.append(mime);
                buf.append("'");
            }
        }
        if (entry.getDescription() != null) {
            buf.append(" __desc__=");
            buf.append('\"');
            buf.append(entry.getDescription());
            buf.append('\"');
        }
        buf.append(" __position__=");
        buf.append(position);
        DataOutputStream dos = null;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            this.buildExtraField1(dos, buf.toString());
            this.buildExtraField2(dos, entry.getNameValuePairs());
            dos.flush();
            zipEntry.setExtra(baos.toByteArray());
            if (dos != null) {
                this.closeOutputStream(baos, dos);
                dos = null;
                baos = null;
            }
        }
        catch (IOException e) {
            try {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
            }
            catch (Throwable throwable) {
                if (dos != null) {
                    this.closeOutputStream(baos, dos);
                    dos = null;
                    baos = null;
                }
                throw throwable;
            }
        }
    }

    private void buildExtraField1(DataOutputStream dos, String buf) throws TransportException {
        DataOutputStream data = null;
        ByteArrayOutputStream bstream = null;
        try {
            dos.writeByte(128);
            dos.writeByte(71);
            byte[] bufBytes = buf.getBytes(UTF8_ENCODING);
            int len = this.convertToLittleEndian(bufBytes.length + 4);
            bstream = new ByteArrayOutputStream();
            data = new DataOutputStream(bstream);
            data.writeInt(len);
            data.flush();
            byte[] bb = bstream.toByteArray();
            dos.writeByte(bb[0]);
            dos.writeByte(bb[1]);
            dos.writeByte(83);
            dos.writeByte(65);
            dos.writeByte(83);
            dos.writeByte(0);
            dos.write(bufBytes);
            if (data != null) {
                this.closeOutputStream(bstream, data);
                data = null;
                bstream = null;
            }
        }
        catch (IOException e) {
            try {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
            }
            catch (Throwable throwable) {
                if (data != null) {
                    this.closeOutputStream(bstream, data);
                    data = null;
                    bstream = null;
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildExtraField2(DataOutputStream dos, AttributeMapInterface namevalues) throws TransportException {
        StringBuffer buf = null;
        byte[] bb = null;
        if (namevalues == null) {
            return;
        }
        ByteArrayOutputStream bstream = null;
        DataOutputStream data = null;
        try {
            dos.writeByte(240);
            dos.writeByte(71);
            buf = new StringBuffer();
            String[] names = namevalues.listAttributeNames();
            for (int i = 0; i < names.length; ++i) {
                String n = names[i];
                String[] values = namevalues.getAttributes(n);
                String value = AttributeMap.buildValue((String[])values);
                buf.append(n);
                if (value != null && !value.equals("")) {
                    buf.append("=");
                    buf.append(value);
                }
                buf.append(" ");
            }
            String field2 = buf.toString().trim();
            byte[] bufBytes = field2.getBytes(UTF8_ENCODING);
            int len = this.convertToLittleEndian(bufBytes.length + 4);
            bstream = new ByteArrayOutputStream();
            data = new DataOutputStream(bstream);
            data.writeInt(len);
            data.flush();
            bb = bstream.toByteArray();
            dos.writeByte(bb[0]);
            dos.writeByte(bb[1]);
            dos.writeByte(83);
            dos.writeByte(65);
            dos.writeByte(83);
            dos.writeByte(0);
            dos.write(bufBytes);
            if (data == null) return;
            this.closeOutputStream(bstream, data);
            return;
        }
        catch (IOException e) {
            try {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
                catch (ParseException e2) {
                    throw new TransportException((Throwable)e2, RB.getStringResource("ArchiveTransport.error.ex.txt"));
                }
            }
            catch (Throwable throwable) {
                if (data == null) throw throwable;
                this.closeOutputStream(bstream, data);
                bstream = null;
                data = null;
                throw throwable;
            }
        }
    }

    private void setHTMLExtraFields(ZipEntry zipEntry, EntryInterface entry, HTMLFileInterface file, int bodyCount, int companionCount, int position) throws RemoteException, TransportException {
        StringBuffer buf = new StringBuffer();
        buf.append("__type__=html __version__=15 __coll__=");
        buf.append(this._coll);
        int fileType = file.getRole();
        if (fileType == 1 || fileType == 2) {
            buf.append(" __bodyCount__=");
            buf.append(bodyCount);
            buf.append(" __body__");
        } else if (fileType == 7 || fileType == 3) {
            buf.append(" __frame__");
        } else if (fileType == 5) {
            buf.append(" __pages__");
        } else if (fileType == 4) {
            buf.append(" __contents__");
        } else {
            buf.append(" __fsCount__=");
            buf.append(companionCount);
            buf.append(" __frameset__");
            String mime = file.getMIMEType();
            if (mime != null) {
                buf.append(" __mime__='");
                buf.append(mime);
                buf.append("'");
            }
        }
        String url = file.getURL();
        if (url != null) {
            buf.append(" __url__=");
            buf.append(url);
        }
        Map m = null;
        try {
            HTMLEncodingParser parser = new HTMLEncodingParser();
            m = parser.parse(file);
        }
        catch (ParseException parser) {
            // empty catch block
        }
        String userEncoding = file.getEncoding();
        if (m == null) {
            buf.append(" __encodingOffset__=0");
            buf.append(" __encoding__=");
            if (userEncoding != null) {
                buf.append(userEncoding);
            } else {
                buf.append("IS0-8859-1");
            }
        } else {
            buf.append(" __encodingOffset__=");
            Integer eOffset = (Integer)m.get("OFFSET");
            buf.append(eOffset);
            buf.append(" __encoding__=");
            buf.append(m.get("ENCODING"));
        }
        if (entry.getDescription() != null) {
            buf.append(" __desc__=");
            buf.append('\"');
            buf.append(entry.getDescription());
            buf.append('\"');
        }
        buf.append(" __position__=");
        buf.append(position);
        DataOutputStream dos = null;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            this.buildExtraField1(dos, buf.toString());
            this.buildExtraField2(dos, entry.getNameValuePairs());
            dos.flush();
            zipEntry.setExtra(baos.toByteArray());
            if (dos != null) {
                this.closeOutputStream(baos, dos);
                dos = null;
                baos = null;
            }
        }
        catch (IOException e) {
            try {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
            }
            catch (Throwable throwable) {
                if (dos != null) {
                    this.closeOutputStream(baos, dos);
                    dos = null;
                    baos = null;
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeResultPackage(ResultPackageInterface rPkg, boolean nested) throws TransportException, RemoteException {
        ArchiveZipTable _zipTable;
        String filename;
        Hashtable<String, ArchiveEntry> collections = new Hashtable<String, ArchiveEntry>();
        String _description = null;
        String fileToOpen = filename = ((ArchiveResultPackage)rPkg).getName();
        if (nested) {
            fileToOpen = this.retrvTempNested(rPkg);
        }
        try {
            _zipTable = new ArchiveZipTable(fileToOpen);
            ((ArchiveResultPackage)rPkg).setZipTable(_zipTable);
            ZipEntry metadata = _zipTable.getEntry("PackageMetaData");
            if (metadata == null) {
                throw new TransportException(RB.getStringResource("ArchiveTransport.noMetadata.ex.txt"));
            }
            this.getMetaData(_zipTable, rPkg);
            if (((ArchiveResultPackage)rPkg).getVersion() == 1 && (_description = metadata.getComment()) != null) {
                rPkg.setDescription(_description);
            }
            Enumeration zipentries = _zipTable.entries();
            while (zipentries.hasMoreElements()) {
                String nobs;
                String viewerType;
                String url;
                String refType;
                String mime;
                String maxl;
                String encoding;
                String coll;
                boolean companion;
                boolean pages;
                boolean contents;
                boolean body;
                boolean frame;
                ArchiveEntry archiveEntry;
                String name;
                block115: {
                    int end;
                    int start;
                    int offset = 0;
                    String extraField1 = null;
                    String extraField2 = null;
                    byte[] header = new byte[8];
                    int headerLength = 0;
                    ZipEntry zipentry = (ZipEntry)zipentries.nextElement();
                    name = zipentry.getName().trim();
                    byte[] extraBytes = zipentry.getExtra();
                    FilterInputStream extra = null;
                    try {
                        if (extraBytes != null) {
                            extra = new DataInputStream(new ByteArrayInputStream(extraBytes));
                            while (offset + 4 <= extraBytes.length) {
                                boolean notSAS = false;
                                if (offset + 8 <= extraBytes.length) {
                                    ((DataInputStream)extra).read(header, 0, 8);
                                } else {
                                    ((DataInputStream)extra).read(header, 0, 4);
                                    notSAS = true;
                                }
                                int nextlen1 = header[2];
                                int nextlen0 = header[3];
                                nextlen0 <<= 8;
                                headerLength = (nextlen0 &= 0xFF00) + (nextlen1 &= 0xFF);
                                offset = headerLength + offset + 4;
                                if (notSAS) {
                                    extra.skip(headerLength);
                                    continue;
                                }
                                byte[] tempbytes = new byte[headerLength - 4];
                                if (header[1] != 71 || header[4] != 83 || header[5] != 65 || header[6] != 83) continue;
                                if (header[0] == -128) {
                                    ((DataInputStream)extra).read(tempbytes, 0, headerLength - 4);
                                    extraField1 = new String(tempbytes, ((ArchiveResultPackage)rPkg).getTextEncoding());
                                    continue;
                                }
                                if (header[0] == -16) {
                                    ((DataInputStream)extra).read(tempbytes, 0, headerLength - 4);
                                    extraField2 = new String(tempbytes, ((ArchiveResultPackage)rPkg).getTextEncoding());
                                    continue;
                                }
                                if (header[0] == 112) {
                                    ((DataInputStream)extra).read(tempbytes, 0, headerLength - 4);
                                    continue;
                                }
                                extra.skip(headerLength - 4);
                            }
                        }
                    }
                    finally {
                        if (extra != null) {
                            try {
                                extra.close();
                            }
                            catch (IOException notSAS) {}
                            extra = null;
                        }
                    }
                    if (name.equals("PackageMetaData")) {
                        int end2;
                        int start2;
                        block114: {
                            if (extraField2 != null) {
                                try {
                                    AttributeMap nv = new AttributeMap();
                                    AttributeMap.parseNameValuePairs((AttributeMapInterface)nv, extraField2);
                                    rPkg.setNameValuePairs((AttributeMapInterface)nv);
                                }
                                catch (ParseException e) {
                                    if (this.logger == null) break block114;
                                    this.logger.warn(RB.getStringResource("ArchiveTransport.nameValueParseError.txt"), (Throwable)e);
                                }
                            }
                        }
                        if (((ArchiveResultPackage)rPkg).getVersion() <= 1) continue;
                        int length = extraField1.length();
                        int startPos = 0;
                        while (startPos < length && (start2 = extraField1.indexOf(DOUBLE_UNDERSCORE, startPos)) != -1 && (end2 = extraField1.indexOf(DOUBLE_UNDERSCORE, start2 + 2)) != -1) {
                            char endChar;
                            String keyword = extraField1.substring(start2, end2 += 2);
                            if (end2 >= length) break;
                            start2 = end2;
                            if (keyword.equalsIgnoreCase("__desc__") && (endChar = extraField1.charAt(end2)) == '=') {
                                char delimiter = extraField1.charAt(end2 + 1);
                                if ((end2 = extraField1.indexOf(delimiter, start2 = end2 + 2)) == -1) break;
                                _description = extraField1.substring(start2, end2).trim();
                            }
                            startPos = ++end2;
                        }
                        if (_description == null) continue;
                        rPkg.setDescription(_description);
                        continue;
                    }
                    if (extraField1 == null) {
                        throw new TransportException(RB.getStringResource("ArchiveTransport.noExtraField1.ex.txt"));
                    }
                    archiveEntry = null;
                    frame = false;
                    body = false;
                    contents = false;
                    pages = false;
                    companion = false;
                    coll = null;
                    encoding = null;
                    maxl = null;
                    mime = null;
                    refType = null;
                    String type = null;
                    url = null;
                    String entryVersion = null;
                    String description = null;
                    viewerType = null;
                    nobs = null;
                    String position = "-1";
                    int length = extraField1.length();
                    int startPos = 0;
                    block19: while (startPos < length && (start = extraField1.indexOf(DOUBLE_UNDERSCORE, startPos)) != -1 && (end = extraField1.indexOf(DOUBLE_UNDERSCORE, start + 2)) != -1) {
                        String value;
                        char startChar;
                        String keyword = extraField1.substring(start, end += 2);
                        startPos = end;
                        if (keyword.equalsIgnoreCase("__frame__")) {
                            frame = true;
                            continue;
                        }
                        if (keyword.equalsIgnoreCase("__body__")) {
                            body = true;
                            continue;
                        }
                        if (keyword.equalsIgnoreCase("__contents__")) {
                            contents = true;
                            continue;
                        }
                        if (keyword.equalsIgnoreCase("__pages__")) {
                            pages = true;
                            continue;
                        }
                        if (keyword.equalsIgnoreCase("__frameset__")) {
                            companion = true;
                            continue;
                        }
                        if (end >= length) break;
                        char endChar = extraField1.charAt(end);
                        if (endChar != '=' || (startChar = extraField1.charAt(start = end + 1)) == ' ') continue;
                        if (keyword.equalsIgnoreCase("__desc__")) {
                            char delim = extraField1.charAt(start);
                            end = extraField1.indexOf(delim, ++start);
                            if (end == -1) continue;
                            description = extraField1.substring(start, end).trim();
                            startPos = end + 1;
                            continue;
                        }
                        if (startChar == '\'') {
                            if (!keyword.equalsIgnoreCase("__mime__") || (end = extraField1.indexOf(39, ++start)) == -1) continue;
                            value = extraField1.substring(start, end).trim();
                            startPos = end + 1;
                            StringTokenizer tokenizer = new StringTokenizer(value, " ;");
                            while (tokenizer.hasMoreTokens()) {
                                String token = tokenizer.nextToken();
                                if (token.equals("Content-Type")) continue;
                                mime = token;
                                continue block19;
                            }
                            continue;
                        }
                        end = extraField1.indexOf(32, start);
                        if (end == -1) {
                            end = length;
                        }
                        value = extraField1.substring(start, end).trim();
                        startPos = end;
                        if (keyword.equalsIgnoreCase("__coll__")) {
                            coll = value;
                            continue;
                        }
                        if (keyword.equalsIgnoreCase("__encoding__")) {
                            encoding = value;
                            continue;
                        }
                        if (keyword.equalsIgnoreCase("__encodingOffset__")) continue;
                        if (keyword.equalsIgnoreCase("__maxl__")) {
                            maxl = value;
                            continue;
                        }
                        if (keyword.equalsIgnoreCase("__mime__")) {
                            mime = value;
                            continue;
                        }
                        if (keyword.equalsIgnoreCase("__refType__")) {
                            refType = value;
                            continue;
                        }
                        if (keyword.equalsIgnoreCase("__type__")) {
                            type = value.toLowerCase();
                            continue;
                        }
                        if (keyword.equalsIgnoreCase("__url__")) {
                            url = value;
                            continue;
                        }
                        if (keyword.equalsIgnoreCase("__version__")) {
                            entryVersion = value;
                            continue;
                        }
                        if (keyword.equalsIgnoreCase("__viewer__")) {
                            viewerType = value;
                            continue;
                        }
                        if (keyword.equalsIgnoreCase("__nobs__")) {
                            nobs = value;
                            continue;
                        }
                        if (!keyword.equalsIgnoreCase("__position__")) continue;
                        position = value;
                    }
                    if (type == null) {
                        type = "Unknown";
                    }
                    boolean createNew = false;
                    if (coll != null) {
                        archiveEntry = (ArchiveEntry)collections.get(coll);
                        if (archiveEntry == null) {
                            archiveEntry = type.equalsIgnoreCase("html") ? new ArchiveHTMLEntry() : new ArchiveViewerEntry(((ArchiveResultPackage)rPkg).getTextEncoding());
                            createNew = true;
                            collections.put(coll, archiveEntry);
                        }
                    } else {
                        archiveEntry = this.createEntry(type, name, rPkg);
                        if (archiveEntry == null) continue;
                        createNew = true;
                    }
                    archiveEntry.setPosition(Integer.valueOf(position));
                    if (createNew) {
                        rPkg.addEntry(archiveEntry);
                        archiveEntry.setName(name);
                        archiveEntry.setPackage(rPkg);
                        try {
                            if (!(archiveEntry instanceof ResultPackageInterface)) {
                                archiveEntry.setZipTable(_zipTable);
                                archiveEntry.setVersion(Integer.parseInt(entryVersion));
                            }
                        }
                        catch (NumberFormatException e) {
                            archiveEntry.setVersion(-1);
                        }
                    }
                    if (((ArchiveResultPackage)rPkg).getVersion() == 1) {
                        description = zipentry.getComment();
                    }
                    archiveEntry.setDescription(description);
                    if (extraField2 != null) {
                        try {
                            AttributeMap nv = new AttributeMap();
                            AttributeMap.parseNameValuePairs((AttributeMapInterface)nv, extraField2);
                            archiveEntry.setNameValuePairs((AttributeMapInterface)nv);
                        }
                        catch (ParseException e) {
                            if (this.logger == null) break block115;
                            this.logger.warn(RB.getStringResource("ArchiveTransport.nameValueParseError.txt"), (Throwable)e);
                        }
                    }
                }
                if (archiveEntry instanceof DatasetEntryInterface && nobs != null) {
                    ((ArchiveDatasetEntry)archiveEntry).setNobs(Integer.parseInt(nobs));
                }
                if (archiveEntry instanceof ViewerEntryInterface) {
                    ViewerEntryInterface viewer = (ViewerEntryInterface)((java.lang.Object)archiveEntry);
                    if (mime != null) {
                        viewer.setMIMEType(mime);
                    }
                    if (encoding != null) {
                        viewer.setEncoding(encoding);
                    }
                    if (viewerType != null) {
                        if (viewerType.equalsIgnoreCase("text")) {
                            ((ArchiveViewerEntry)archiveEntry).setViewerType(2);
                        } else {
                            ((ArchiveViewerEntry)archiveEntry).setViewerType(1);
                        }
                    } else {
                        ((ArchiveViewerEntry)archiveEntry).setViewerType(1);
                    }
                } else if (archiveEntry instanceof BinaryFileEntryInterface) {
                    if (mime != null) {
                        ((BinaryFileEntryInterface)((java.lang.Object)archiveEntry)).setMIMEType(mime);
                    }
                } else if (archiveEntry instanceof TextFileEntryInterface && mime != null) {
                    ((TextFileEntryInterface)((java.lang.Object)archiveEntry)).setMIMEType(mime);
                }
                archiveEntry.setPackage(rPkg);
                if (coll != null && archiveEntry instanceof ArchiveHTMLEntry) {
                    ArchiveHTMLFile hFile;
                    ArchiveHTMLEntry htmlEntry = (ArchiveHTMLEntry)archiveEntry;
                    if (frame) {
                        HTMLFileInterface currFile;
                        ArchiveHTMLFile f = new ArchiveHTMLFile();
                        f.setName(name);
                        f.setRole(7);
                        f.setZipTable(_zipTable);
                        if (url != null) {
                            f.setURL(url);
                        }
                        if (mime != null) {
                            f.setMIMEType(mime);
                        } else {
                            f.setMIMEType("text/html");
                        }
                        if (encoding != null) {
                            f.setEncoding(encoding);
                        }
                        if ((currFile = htmlEntry.getFile()) != null) {
                            ((ArchiveHTMLFile)currFile).setRole(2);
                            htmlEntry.addCompanionFile(currFile);
                        }
                        htmlEntry.setFile(f);
                    }
                    if (body) {
                        HTMLFileInterface currFile;
                        hFile = new ArchiveHTMLFile();
                        hFile.setName(name);
                        hFile.setZipTable(_zipTable);
                        if (url != null) {
                            hFile.setURL(url);
                        }
                        if (mime != null) {
                            hFile.setMIMEType(mime);
                        } else {
                            hFile.setMIMEType("text/html");
                        }
                        if (encoding != null) {
                            hFile.setEncoding(encoding);
                        }
                        if ((currFile = htmlEntry.getFile()) == null) {
                            hFile.setRole(1);
                            htmlEntry.setFile(hFile);
                        } else {
                            hFile.setRole(2);
                            htmlEntry.addCompanionFile(hFile);
                        }
                    }
                    if (contents) {
                        ArchiveHTMLFile cFile = new ArchiveHTMLFile();
                        cFile.setName(name);
                        cFile.setZipTable(_zipTable);
                        if (url != null) {
                            cFile.setURL(url);
                        }
                        if (mime != null) {
                            cFile.setMIMEType(mime);
                        } else {
                            cFile.setMIMEType("text/html");
                        }
                        if (encoding != null) {
                            cFile.setEncoding(encoding);
                        }
                        cFile.setRole(4);
                        htmlEntry.addCompanionFile(cFile);
                    }
                    if (pages) {
                        ArchiveHTMLFile pFile = new ArchiveHTMLFile();
                        pFile.setName(name);
                        pFile.setZipTable(_zipTable);
                        if (url != null) {
                            pFile.setURL(url);
                        }
                        if (mime != null) {
                            pFile.setMIMEType(mime);
                        } else {
                            pFile.setMIMEType("text/html");
                        }
                        if (encoding != null) {
                            pFile.setEncoding(encoding);
                        }
                        pFile.setRole(5);
                        htmlEntry.addCompanionFile(pFile);
                    }
                    if (companion) {
                        hFile = new ArchiveHTMLFile();
                        hFile.setName(name);
                        hFile.setZipTable(_zipTable);
                        if (url != null) {
                            hFile.setURL(url);
                        }
                        if (mime != null) {
                            hFile.setMIMEType(mime);
                        }
                        if (encoding != null) {
                            hFile.setEncoding(encoding);
                        }
                        hFile.setRole(6);
                        htmlEntry.addCompanionFile(hFile);
                    }
                }
                if (maxl != null) {
                    if (archiveEntry instanceof ArchiveTextFileEntry) {
                        ((ArchiveTextFileEntry)archiveEntry).setMaximumLineLength(Integer.valueOf(maxl));
                    } else if (archiveEntry instanceof ArchiveViewerEntry) {
                        ((ArchiveViewerEntry)archiveEntry).setMaximumLineLength(Integer.valueOf(maxl));
                    }
                }
                if (refType != null && archiveEntry instanceof ArchiveReferenceEntry) {
                    ((ArchiveReferenceEntry)archiveEntry).setReferenceType(refType);
                }
                if (archiveEntry == null || archiveEntry instanceof ArchiveHTMLEntry) continue;
                archiveEntry.setIsReadOnly(true);
            }
            Enumeration enumeration = collections.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                EntryInterface e = (EntryInterface)collections.get(key);
                if (!(e instanceof HTMLEntryInterface)) continue;
                ArchiveHTMLEntry hEntry = (ArchiveHTMLEntry)collections.get(key);
                hEntry.setIsReadOnly(true);
                ArchiveHTMLFile hFile = (ArchiveHTMLFile)hEntry.getFile();
                if (hFile != null) {
                    hFile.setIsReadOnly(true);
                }
                HTMLFileInterface[] files = hEntry.getCompanionFiles();
                for (int f = 0; f < files.length; ++f) {
                    hFile = (ArchiveHTMLFile)files[f];
                    hFile.setIsReadOnly(true);
                }
            }
            if (!nested) {
                ((ArchiveResultPackage)rPkg).setIsReadOnly(true);
            }
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
        }
        if (_zipTable != null) {
            _zipTable.close();
        }
    }

    private String retrvTempNested(ResultPackageInterface rPkg) throws TransportException {
        File outputFile;
        int READ_LENGTH_1024 = 1024;
        String filename = ((ArchiveResultPackage)rPkg).getName();
        BufferedInputStream stream = null;
        String directory = this._extractionDirectory;
        String fileToOpen = filename;
        FileOutputStream fos = null;
        try {
            stream = new BufferedInputStream(((ArchiveResultPackage)rPkg).getNestedInputStream());
            if (directory == null || directory.length() == 0) {
                outputFile = File.createTempFile("Nested_" + filename, ".spk");
                fileToOpen = outputFile.getCanonicalPath();
            } else {
                filename = directory + File.separator + filename;
                outputFile = new File(filename);
                fileToOpen = outputFile.getCanonicalPath();
            }
        }
        catch (IOException e) {
            if (stream != null) {
                this.closeInputStream(stream);
                stream = null;
            }
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
        }
        try {
            fos = new FileOutputStream(outputFile);
            int length = Math.max(((InputStream)stream).available(), 1024);
            length = Math.min(length, 4096);
            byte[] buffer = new byte[length];
            while ((length = ((InputStream)stream).read(buffer, 0, buffer.length)) != -1) {
                fos.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
                }
            }
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
                }
            }
        }
        return fileToOpen;
    }

    private ArchiveEntry createEntry(String type, String name, ResultPackageInterface rPkg) throws TransportException, RemoteException {
        ArchiveEntry entry = null;
        if (type.equals("binfile")) {
            entry = new ArchiveBinaryFileEntry();
        } else if (type.equals("catalog")) {
            entry = new ArchiveLibraryMemberEntry(2);
        } else if (type.equals("dataset")) {
            int index = name.indexOf(46);
            if (index > 0) {
                name = name.substring(0, index);
            }
            entry = new ArchiveDatasetEntry(name);
        } else if (type.equals("fdb")) {
            entry = new ArchiveLibraryMemberEntry(4);
        } else if (type.equals("html")) {
            entry = new ArchiveHTMLEntry();
        } else if (type.equals("mddb")) {
            new ArchiveLibraryMemberEntry(3);
        } else if (type.equals("package")) {
            ArchiveResultPackage pkg = null;
            try {
                pkg = new ArchiveResultPackage(this, name, this._extractionDirectory, true);
                pkg.setZipTable(((ArchiveResultPackage)rPkg).getZipTable());
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
            }
            entry = pkg;
        } else if (type.equals("referen")) {
            entry = new ArchiveReferenceEntry();
        } else if (type.equals("txtfile")) {
            entry = new ArchiveTextFileEntry(((ArchiveResultPackage)rPkg).getTextEncoding());
        } else if (type.equals("view")) {
            entry = new ArchiveLibraryMemberEntry(5);
        } else if (type.equals("viewer")) {
            entry = new ArchiveViewerEntry(((ArchiveResultPackage)rPkg).getTextEncoding());
        }
        return entry;
    }

    private void getMetaData(ArchiveZipTable _zipTable, ResultPackageInterface rPkg) throws TransportException {
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(_zipTable.getInputStream("PackageMetaData"));
            int pkgVersion = dis.readInt();
            if (pkgVersion > 2) {
                throw new TransportException(RB.getStringResource("ArchiveCommon.pkgCompat.ex.txt"));
            }
            String textEncoding = Encoding.determineEncoding(pkgVersion > 1);
            ((ArchiveResultPackage)rPkg).setTextEncoding(textEncoding);
            ((ArchiveResultPackage)rPkg).setVersion(pkgVersion);
            double d = dis.readDouble();
            ((ArchiveResultPackage)rPkg).setCreationDateTime(DateUtil.SASDateTimeToJavaDate((double)d, (TimeZone)this._gmtTimeZone));
            d = dis.readDouble();
            ((ArchiveResultPackage)rPkg).setExpirationDateTime(DateUtil.SASDateTimeToJavaDate((double)d, (TimeZone)this._gmtTimeZone));
            byte[] bytes = new byte[dis.readInt()];
            dis.readFully(bytes);
            String value = new String(bytes, ((ArchiveResultPackage)rPkg).getTextEncoding());
            rPkg.setAbstract(value);
            value = dis.readByte() + "";
            switch (value.charAt(0)) {
                case '0': {
                    value = "No path information";
                    break;
                }
                case '1': {
                    value = "Physical file path";
                    break;
                }
                case '2': {
                    value = "FTP URL";
                    break;
                }
                case '3': {
                    value = "HTTP URL";
                    break;
                }
                case '4': {
                    value = "LDAP URL";
                    break;
                }
                default: {
                    value = "Unknown path identifier: " + value;
                }
            }
            int len = dis.readInt();
            bytes = new byte[len];
            dis.readFully(bytes);
            value = new String(bytes, ((ArchiveResultPackage)rPkg).getTextEncoding());
            int count = dis.readInt();
            for (int i = 0; i < count; ++i) {
                bytes = new byte[dis.readInt()];
                dis.readFully(bytes);
            }
        }
        catch (EOFException value) {
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
        }
        finally {
            if (dis != null) {
                this.closeInputStream(dis);
            }
        }
    }

    private ResultPackageInterface getServiceObject() throws TransportException {
        ResultPackageInterface rpkg = null;
        String filename = null;
        try {
            Map m = PackageUtil.getDirectoryURL(this._packageSmartObject);
            String p = (String)m.get("PROTOCOL");
            if (p.equals("FILE")) {
                filename = (String)m.get("URL");
                if (this.logger != null && this.logger.isInfoEnabled()) {
                    this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveCommon.archiveInfo.fmt.txt", (java.lang.Object)filename));
                }
                rpkg = this.getPackage(filename, this._packageSmartObject.getContentDestination().getDirectory());
            } else {
                rpkg = p.equals("HTTP") ? this.getHttpPackage((URL)m.get("URL"), (String)m.get("DOMAIN")) : this.getFtpPackage((URL)m.get("URL"), (String)m.get("DOMAIN"));
            }
        }
        catch (ServiceException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.svcObjErr.ex.txt"));
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.svcObjErr.ex.txt"));
        }
        return rpkg;
    }

    private ResultPackageInterface getPackage(String filename, DirectoryInterface dir) throws TransportException {
        File streamedFile;
        File file;
        boolean exists;
        ArchiveResultPackage rpkg;
        block17: {
            rpkg = null;
            exists = false;
            file = null;
            streamedFile = null;
            try {
                file = new File(filename);
                exists = file.exists();
            }
            catch (SecurityException e) {
                if (this.logger == null) break block17;
                this.logger.warn(RB.getStringResource("ArchiveTransport.localErr.txt"), (Throwable)e);
            }
        }
        if (exists) {
            if (this.logger != null && this.logger.isInfoEnabled()) {
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.localArchive.fmt.txt", (java.lang.Object)filename));
            }
            try {
                rpkg = new ArchiveResultPackage(this, file.getCanonicalPath(), null, this._packageSmartObject, false);
            }
            catch (RemoteException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
            }
            catch (IOException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
            }
        }
        if (this.logger != null && this.logger.isInfoEnabled()) {
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.remoteArchive.fmt.txt", (java.lang.Object)filename));
        }
        LogicalServerInterface logicalServer = null;
        boolean foundIOM = false;
        try {
            List servers = dir.getServers();
            for (ServerInterface server : servers) {
                for (String type : server.getServiceTypes()) {
                    if (!type.equals("Logical IOM Server")) continue;
                    foundIOM = true;
                    logicalServer = (LogicalServerInterface)server;
                    break;
                }
                if (!foundIOM) continue;
                break;
            }
        }
        catch (ServiceException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveCommon.metadata.ex.txt"));
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveCommon.metadata.ex.txt"));
        }
        if (logicalServer == null) {
            throw new TransportException(RB.getStringResource("ArchiveTransport.noServer.ex.txt"));
        }
        streamedFile = this.downloadWithIOM(filename, logicalServer);
        try {
            rpkg = new ArchiveResultPackage(this, streamedFile.getCanonicalPath(), null, this._packageSmartObject, true);
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
        }
        return rpkg;
    }

    /*
     * Exception decompiling
     */
    private ResultPackageInterface getHttpPackage(URL u, String domain) throws TransportException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultPackageInterface getFtpPackage(URL u, String domain) throws TransportException {
        InputStream stream = null;
        FileOutputStream fos = null;
        File streamedFile = null;
        ArchiveResultPackage rpkg = null;
        String user = null;
        String pw = null;
        Iterator itor = null;
        String urlStr = null;
        BufferedOutputStream bos = null;
        if (domain != null && this._userContext != null) {
            try {
                ServerInterface serv;
                String serverName = null;
                if (this._packageSmartObject.getContentDestination() != null && (serv = this._packageSmartObject.getContentDestination().getServer()) != null) {
                    serverName = serv.getName();
                }
                final String loginTitle = serverName == null ? "" : Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.promptForServer.fmt.txt", serverName);
                final String dom = domain;
                final UserContextInterface userContext = this._userContext;
                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public java.lang.Object run() throws Exception {
                        return userContext.getIdentitiesByDomain(dom, true, loginTitle);
                    }
                };
                List ilist = null;
                try {
                    ilist = (List)AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException pae) {
                    throw new TransportException(pae.getCause(), RB.getStringResource("ArchiveTransport.downloadErr.ex.txt"));
                }
                itor = ilist.iterator();
                if (itor.hasNext()) {
                    UserIdentityInterface identity = (UserIdentityInterface)itor.next();
                    user = (String)identity.getPrincipal();
                    try {
                        pw = SasPasswordString.decode((String)((String)identity.getCredential()));
                    }
                    catch (SasPasswordEncodingException e) {
                        pw = (String)identity.getCredential();
                    }
                }
            }
            catch (ServiceException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.downloadErr.ex.txt"));
            }
            catch (RemoteException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.downloadErr.ex.txt"));
            }
        }
        try {
            String path = u.getPath();
            if (path.length() > 0 && path.charAt(0) == '/') {
                StringBuffer buf = new StringBuffer();
                buf.append("/%2F");
                buf.append(path.substring(1));
                path = buf.toString();
                u = new URL("ftp", u.getHost(), u.getPort(), path);
            }
            urlStr = URIUtil.addSegment((String)u.toExternalForm(), (String)(this._packageSmartObject.getName() + ".spk"));
        }
        catch (MalformedURLException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.downloadErr.ex.txt"));
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.downloadErr.ex.txt"));
        }
        boolean done = false;
        while (!done) {
            try {
                int len;
                String s;
                int pos;
                u = new URL(urlStr);
                if (user != null && (pos = (s = u.toString()).indexOf("://")) > 0) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(s.substring(0, pos + 3));
                    buf.append(user);
                    buf.append(":");
                    buf.append(pw);
                    buf.append("@");
                    buf.append(s.substring(pos + 3));
                    u = new URL(buf.toString());
                }
                URLConnection connection = u.openConnection();
                connection.connect();
                stream = connection.getInputStream();
                streamedFile = File.createTempFile(Names.generateName((int)0), ".spk");
                fos = new FileOutputStream(streamedFile);
                bos = new BufferedOutputStream(fos);
                byte[] b = new byte[4096];
                while ((len = stream.read(b)) != -1) {
                    bos.write(b, 0, len);
                }
                bos.flush();
                fos.close();
                stream.close();
                stream = null;
                bos.close();
                bos = null;
                done = true;
                if (stream != null) {
                    this.closeInputStream(stream);
                    stream = null;
                }
                if (bos == null) continue;
                this.closeOutputStream(fos, bos);
                bos = null;
                fos = null;
            }
            catch (Exception e) {
                try {
                    if (itor != null && itor.hasNext()) {
                        if (this.logger != null && this.logger.isInfoEnabled()) {
                            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.ftpRetry.fmt.txt", (java.lang.Object)urlStr, (java.lang.Object)e.getMessage()));
                        }
                        UserIdentityInterface identity = (UserIdentityInterface)itor.next();
                        user = (String)identity.getPrincipal();
                        try {
                            pw = SasPasswordString.decode((String)((String)identity.getCredential()));
                        }
                        catch (SasPasswordEncodingException spee) {
                            pw = (String)identity.getCredential();
                        }
                    } else {
                        done = true;
                        throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.downloadErr.ex.txt"));
                    }
                    if (stream != null) {
                        this.closeInputStream(stream);
                        stream = null;
                    }
                    if (bos == null) continue;
                    this.closeOutputStream(fos, bos);
                    bos = null;
                    fos = null;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        this.closeInputStream(stream);
                        stream = null;
                    }
                    if (bos != null) {
                        this.closeOutputStream(fos, bos);
                        bos = null;
                        fos = null;
                    }
                    throw throwable;
                }
            }
        }
        try {
            rpkg = new ArchiveResultPackage(this, streamedFile.getCanonicalPath(), null, this._packageSmartObject, true);
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
        }
        return rpkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadWithIOM(String archiveName, LogicalServerInterface server) throws TransportException {
        BufferedOutputStream bos;
        FileOutputStream fos;
        File streamedFile;
        block19: {
            streamedFile = null;
            ConnectionInterface connection = null;
            IFileService fileService = null;
            fos = null;
            bos = null;
            try {
                try {
                    SessionContextInterface sc = this.getSessionContext();
                    String longLivedUser = null;
                    if (sc != null && (longLivedUser = (String)sc.getAttribute("com.sas.services.connection.platform.privilegedUserNameKey")) != null && this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug(RB.getStringResource("ArchiveCommon.privUser.txt"));
                    }
                    PlatformConnectionFactoryConfiguration config = new PlatformConnectionFactoryConfiguration(server, longLivedUser);
                    PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)config);
                    connection = cxf.getConnection(this._userContext);
                    Object obj = connection.getObject();
                    IWorkspace iWorkspace = IWorkspaceHelper.narrow((Object)obj);
                    fileService = iWorkspace.FileService();
                }
                catch (ConnectionFactoryException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.connectErr.ex.txt"));
                }
                catch (RemoteException e) {
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.connectErr.ex.txt"));
                }
                try {
                    StringHolder stringHolder = new StringHolder();
                    IFileref fileref = null;
                    String requestedName = "";
                    String accessMethod = "DISK";
                    String externalFile = archiveName;
                    String hostOptions = "";
                    fileref = fileService.AssignFileref(requestedName, accessMethod, externalFile, hostOptions, stringHolder);
                    StreamOpenMode readmode = StreamOpenMode.StreamOpenModeForReading;
                    IBinaryStream bs = null;
                    bs = fileref.OpenBinaryStream(readmode);
                    streamedFile = File.createTempFile(Names.generateName((int)0), ".spk");
                    fos = new FileOutputStream(streamedFile);
                    bos = new BufferedOutputStream(fos);
                    OctetSeqHolder binIn = new OctetSeqHolder();
                    bs.Read(4096, binIn);
                    byte[] buffer = binIn.value;
                    while (buffer.length > 0) {
                        for (int i = 0; i < buffer.length; ++i) {
                            bos.write(buffer[i]);
                        }
                        bs.Read(4096, binIn);
                        buffer = binIn.value;
                    }
                    bos.flush();
                    fos.close();
                    fos = null;
                    bs.Close();
                    bs = null;
                    bos.close();
                    bos = null;
                    try {
                        fileService.DeassignFileref(stringHolder.value);
                        connection.close();
                        connection = null;
                    }
                    catch (GenericError e) {
                        if (this.logger != null) {
                            this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveTransport.closeErr.fmt.txt", (java.lang.Object)archiveName));
                        }
                    }
                }
                catch (IOException e) {
                    if (streamedFile != null) {
                        streamedFile.delete();
                        streamedFile = null;
                    }
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.downloadErr.ex.txt"));
                }
                catch (GenericError e) {
                    if (streamedFile != null) {
                        streamedFile.delete();
                        streamedFile = null;
                    }
                    throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.downloadErr.ex.txt"));
                }
                if (connection == null) break block19;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
                if (bos != null) {
                    this.closeOutputStream(fos, bos);
                    bos = null;
                    fos = null;
                }
                throw throwable;
            }
            connection.close();
            connection = null;
        }
        if (bos != null) {
            this.closeOutputStream(fos, bos);
            bos = null;
            fos = null;
        }
        return streamedFile;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResultPackageInterface getDavPackage() throws TransportException {
        File f = null;
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        ArchiveResultPackage rpkg = null;
        try {
            int len;
            f = File.createTempFile(Names.generateName((int)0), ".spk");
            bos = new BufferedOutputStream(new FileOutputStream(f));
            byte[] buffer = new byte[4096];
            bis = new BufferedInputStream(this._davResource.getContents());
            while ((len = bis.read(buffer)) > 0) {
                bos.write(buffer, 0, len);
            }
            bos.flush();
            if (bos != null) {
                this.closeOutputStream(bos);
                bos = null;
            }
            if (bis != null) {
                this.closeInputStream(bis);
                bis = null;
            }
        }
        catch (IOException e) {
            try {
                if (bos != null) {
                    this.closeOutputStream(bos);
                    bos = null;
                }
                if (f == null) throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.davErr.ex.txt"));
                f.delete();
                f = null;
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.davErr.ex.txt"));
                catch (DAVException e2) {
                    if (bos != null) {
                        this.closeOutputStream(bos);
                        bos = null;
                    }
                    if (f == null) throw new TransportException((Throwable)e2, RB.getStringResource("ArchiveTransport.davErr.ex.txt"));
                    f.delete();
                    f = null;
                    throw new TransportException((Throwable)e2, RB.getStringResource("ArchiveTransport.davErr.ex.txt"));
                }
            }
            catch (Throwable throwable) {
                if (bos != null) {
                    this.closeOutputStream(bos);
                    bos = null;
                }
                if (bis == null) throw throwable;
                this.closeInputStream(bis);
                bis = null;
                throw throwable;
            }
        }
        try {
            return new ArchiveResultPackage(this, f.getCanonicalPath(), null, this._davResource);
        }
        catch (IOException e) {
            if (f == null) throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
            f.delete();
            f = null;
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
        }
    }

    private void closeInputStream(InputStream is) {
        this.closeInputStream(null, is);
    }

    private void closeInputStream(InputStream inner, InputStream outter) {
        try {
            outter.close();
            inner = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        outter = null;
        if (inner != null) {
            try {
                inner.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            inner = null;
        }
    }

    private void closeOutputStream(OutputStream os) {
        this.closeOutputStream(null, os);
    }

    private void closeOutputStream(OutputStream inner, OutputStream outter) {
        try {
            outter.close();
            inner = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        outter = null;
        if (inner != null) {
            try {
                inner.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            inner = null;
        }
    }

    private ResultPackageInterface replicatePackage() throws TransportException {
        FileOutputStream fos = null;
        ArchiveResultPackage rpkg = null;
        if (this._replicatedFile == null) {
            try {
                int len;
                this._replicatedFile = File.createTempFile(Names.generateName((int)0), ".spk");
                this._replicatedFile.deleteOnExit();
                fos = new FileOutputStream(this._replicatedFile);
                byte[] buffer = new byte[4096];
                while ((len = this._inputStream.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.flush();
                fos.close();
                fos = null;
                this._inputStream.close();
                this._inputStream = null;
            }
            catch (IOException e) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    fos = null;
                }
                if (this._inputStream != null) {
                    try {
                        this._inputStream.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this._inputStream = null;
                }
                if (this._replicatedFile != null) {
                    this._replicatedFile.delete();
                    this._replicatedFile = null;
                }
                throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.repErr.ex.txt"));
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {}
                    fos = null;
                }
                if (this._inputStream != null) {
                    try {
                        this._inputStream.close();
                    }
                    catch (Throwable throwable) {}
                    this._inputStream = null;
                }
            }
        }
        try {
            if (this._extractionDirectory == null) {
                rpkg = new ArchiveResultPackage(this, this._replicatedFile.getCanonicalPath());
                rpkg.setReplicated(true);
            } else {
                rpkg = new ArchiveResultPackage(this, this._replicatedFile.getCanonicalPath(), this._extractionDirectory, false);
                rpkg.setReplicated(true);
            }
        }
        catch (IOException e) {
            if (this._replicatedFile != null) {
                this._replicatedFile.delete();
                this._replicatedFile = null;
            }
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveTransport.error.ex.txt"));
        }
        return rpkg;
    }
}

