/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.archive;

import com.sas.codepolicy.SASScope;
import com.sas.services.TransportException;
import com.sas.services.publish.LibraryMemberEntryInterface;
import com.sas.services.publish.archive.ArchiveEntry;
import com.sas.services.publish.archive.RB;
import java.rmi.RemoteException;

@SASScope
class ArchiveLibraryMemberEntry
extends ArchiveEntry
implements LibraryMemberEntryInterface {
    private int _type;

    private ArchiveLibraryMemberEntry() throws RemoteException {
        super(ArchiveLibraryMemberEntry.class);
    }

    ArchiveLibraryMemberEntry(int libraryMemberType) throws RemoteException, IllegalArgumentException {
        this();
        if (libraryMemberType != 2 && libraryMemberType != 1 && libraryMemberType != 3 && libraryMemberType != 4 && libraryMemberType != 5) {
            throw new IllegalArgumentException(RB.getStringResource("ArchiveLibraryMemberEntry.illegalArguementException.ex.txt"));
        }
        this._type = libraryMemberType;
    }

    @Override
    public int getLibraryMemberType() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._type;
    }

    @Override
    public String getMemberName() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this.getName();
    }

    public void setMemberName(String memberName) throws IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.entryReadOnly.ex.txt"));
        }
        this.setName(memberName);
    }

    @Override
    public String getLibraryName() throws TransportException, IllegalStateException {
        this.throwExceptionIfClosed();
        return null;
    }
}

