/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.archive;

import com.sas.codepolicy.SASScope;
import com.sas.services.TransportException;
import com.sas.services.publish.HTMLEntryInterface;
import com.sas.services.publish.HTMLFileInterface;
import com.sas.services.publish.archive.ArchiveEntry;
import com.sas.services.publish.archive.ArchiveHTMLFile;
import com.sas.services.publish.archive.RB;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;

@SASScope
class ArchiveHTMLEntry
extends ArchiveEntry
implements HTMLEntryInterface {
    private HTMLFileInterface _mainFile = null;
    private ArrayList _companionFiles = new ArrayList();

    ArchiveHTMLEntry() throws RemoteException {
        super(ArchiveHTMLEntry.class);
    }

    @Override
    public HTMLFileInterface getFile() throws IllegalStateException, TransportException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 32) {
            throw new TransportException(RB.getStringResource("ArchiveCommon.compat.ex.txt"));
        }
        return this._mainFile;
    }

    @Override
    public void setFile(HTMLFileInterface mainFile) throws IllegalArgumentException, IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.entryReadOnly.ex.txt"));
        }
        if (mainFile.getRole() != 7 && mainFile.getRole() != 1) {
            throw new IllegalArgumentException(RB.getStringResource("ArchiveHTMLEntry.setFileIllegalArgumentException.ex.txt"));
        }
        this._mainFile = mainFile;
    }

    @Override
    public HTMLFileInterface getFile(String uniqueId) throws IllegalStateException, RemoteException, TransportException {
        HTMLFileInterface foundFile = null;
        if (this._mainFile != null && uniqueId.equals(this._mainFile.getEntityKey())) {
            foundFile = this._mainFile;
        }
        if (foundFile == null) {
            for (HTMLFileInterface f : this._companionFiles) {
                if (!uniqueId.equals(f.getEntityKey())) continue;
                foundFile = f;
                break;
            }
        }
        return foundFile;
    }

    @Override
    public HTMLFileInterface[] getCompanionFiles() throws IllegalStateException, TransportException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 32) {
            throw new TransportException(RB.getStringResource("ArchiveCommon.compat.ex.txt"));
        }
        HTMLFileInterface[] files = new HTMLFileInterface[this._companionFiles.size()];
        Iterator itor = this._companionFiles.iterator();
        int i = 0;
        while (itor.hasNext()) {
            files[i++] = (HTMLFileInterface)itor.next();
        }
        return files;
    }

    @Override
    public void addCompanionFile(HTMLFileInterface companion) throws IllegalArgumentException, IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.entryReadOnly.ex.txt"));
        }
        int ftype = companion.getRole();
        if (ftype == 1 || ftype == 7) {
            throw new IllegalArgumentException(RB.getStringResource("ArchiveHTMLEntry.addCompIllegalArgumentException.ex.txt"));
        }
        int thisPosition = ((ArchiveHTMLFile)companion).getPosition();
        boolean inserted = false;
        if (this._companionFiles.size() > 0 && thisPosition != -1) {
            for (int i = 0; i < this._companionFiles.size(); ++i) {
                ArchiveHTMLFile af = (ArchiveHTMLFile)this._companionFiles.get(i);
                if (thisPosition >= af.getPosition()) continue;
                this._companionFiles.add(i, companion);
                inserted = true;
                break;
            }
            if (!inserted) {
                this._companionFiles.add(companion);
            }
        } else {
            this._companionFiles.add(companion);
        }
    }

    @Override
    public void setCompanionFiles(HTMLFileInterface[] companions) throws IllegalArgumentException, IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.entryReadOnly.ex.txt"));
        }
        ArrayList<HTMLFileInterface> newList = new ArrayList<HTMLFileInterface>(companions.length);
        for (int i = 0; i < companions.length; ++i) {
            HTMLFileInterface companion = companions[i];
            if (companion == null) continue;
            int ftype = companion.getRole();
            if (ftype == 1 || ftype == 7) {
                throw new IllegalArgumentException(RB.getStringResource("ArchiveHTMLEntry.addCompIllegalArgumentException.ex.txt"));
            }
            newList.add(companion);
        }
        this._companionFiles.clear();
        this._companionFiles = newList;
    }

    @Override
    protected void closeEntry() {
        try {
            ArchiveHTMLFile file = (ArchiveHTMLFile)this.getFile();
            if (file != null) {
                file.closeEntry();
            }
        }
        catch (TransportException e) {
            this.printCloseErrorMsg((Exception)((Object)e));
        }
        try {
            HTMLFileInterface[] companions = this.getCompanionFiles();
            for (int i = 0; i < companions.length; ++i) {
                ArchiveHTMLFile file = (ArchiveHTMLFile)companions[i];
                file.closeEntry();
            }
        }
        catch (TransportException e) {
            this.printCloseErrorMsg((Exception)((Object)e));
        }
        super.closeEntry();
    }
}

