/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.archive;

import com.sas.codepolicy.SASScope;
import com.sas.io.ChainedIOException;
import com.sas.io.InputStreamAdapter;
import com.sas.services.publish.AbstractEntry;
import com.sas.services.publish.BinaryFileEntryInterface;
import com.sas.services.publish.EntryInterface;
import com.sas.services.publish.HTMLEntryInterface;
import com.sas.services.publish.ReferenceEntryInterface;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.TextFileEntryInterface;
import com.sas.services.publish.ViewerEntryInterface;
import com.sas.services.publish.archive.ArchiveDatasetEntry;
import com.sas.services.publish.archive.ArchiveZipTable;
import com.sas.services.publish.archive.RB;
import com.sas.text.Message;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
class ArchiveEntry
extends AbstractEntry
implements EntryInterface {
    private ArchiveZipTable _zipTable;
    private String _name;
    private boolean _isReadOnly = false;
    private int _version;
    private ResultPackageInterface _resultPackage;
    private int _position = -1;

    ArchiveEntry() throws RemoteException {
        this(ArchiveEntry.class);
    }

    protected ArchiveEntry(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected final void setIsReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    void setZipTable(ArchiveZipTable table) {
        this._zipTable = table;
    }

    protected ArchiveZipTable getZipTable() {
        return this._zipTable;
    }

    protected void setVersion(int version) {
        this._version = version;
    }

    public void setName(String name) {
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveResultPackage.readOnlyIllegalStateException.ex.txt"));
        }
        this._name = name;
    }

    protected ResultPackageInterface getPackage() {
        return this._resultPackage;
    }

    protected void setPackage(ResultPackageInterface resultPackage) {
        this._resultPackage = resultPackage;
    }

    protected int getPosition() {
        return this._position;
    }

    protected void setPosition(int position) {
        this._position = position;
    }

    protected void closeEntry() {
        this.setClosed(true);
        this._zipTable = null;
        this._resultPackage = null;
    }

    int getVersion() {
        return this._version;
    }

    @Override
    public boolean isReadOnly() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._isReadOnly;
    }

    public String getName() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._name;
    }

    protected void printCloseErrorMsg(Exception e) {
        String errMsg = null;
        errMsg = this._name == null ? RB.getStringResource("ArchiveEntry.closeEntryError.txt") : Message.format((ResourceBundle)RB.getResources(), (String)"ArchiveEntry.closeEntryError.fmt.txt", (Object)this._name);
        Logger logger = LogManager.getLogger(ArchiveEntry.class);
        if (logger != null) {
            logger.warn(errMsg, (Throwable)e);
        } else {
            System.err.println(errMsg);
        }
    }

    public InputStream getInputStream(Object streamId) throws ChainedIOException, IllegalStateException {
        int compatVersion = 15;
        this.throwExceptionIfClosed();
        if (this instanceof TextFileEntryInterface) {
            compatVersion = 15;
        } else if (this instanceof BinaryFileEntryInterface) {
            compatVersion = 15;
        } else if (this instanceof ViewerEntryInterface) {
            compatVersion = 30;
        } else if (this instanceof HTMLEntryInterface) {
            compatVersion = 32;
        } else if (this instanceof ReferenceEntryInterface) {
            compatVersion = 15;
        } else if (this instanceof ArchiveDatasetEntry) {
            compatVersion = 34;
        }
        if (this._version > compatVersion) {
            throw new ChainedIOException(RB.getStringResource("ArchiveCommon.compat.ex.txt"));
        }
        try {
            return new InputStreamAdapter(this._zipTable.getInputStream(this._name));
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.streamIOError.ex.txt"));
        }
    }

    public InputStream getInputStream() throws IOException, IllegalStateException {
        int compatVersion = 15;
        this.throwExceptionIfClosed();
        if (this instanceof TextFileEntryInterface) {
            compatVersion = 15;
        } else if (this instanceof BinaryFileEntryInterface) {
            compatVersion = 15;
        } else if (this instanceof ViewerEntryInterface) {
            compatVersion = 30;
        } else if (this instanceof HTMLEntryInterface) {
            compatVersion = 32;
        } else if (this instanceof ReferenceEntryInterface) {
            compatVersion = 15;
        } else if (this instanceof ArchiveDatasetEntry) {
            compatVersion = 34;
        }
        if (this._version > compatVersion) {
            throw new ChainedIOException(RB.getStringResource("ArchiveCommon.compat.ex.txt"));
        }
        try {
            return new InputStreamAdapter(this._zipTable.getInputStream(this._name));
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.streamIOError.ex.txt"));
        }
    }
}

