/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.archive;

import com.sas.codepolicy.SASScope;
import com.sas.services.TransportException;
import com.sas.services.publish.AnnotatedServiceResultSet;
import com.sas.services.publish.DatasetEntryInterface;
import com.sas.services.publish.DatasetRetriever;
import com.sas.services.publish.RemoteResultSet;
import com.sas.services.publish.RemoteResultSetInterface;
import com.sas.services.publish.ServiceResultSet;
import com.sas.services.publish.archive.ArchiveEntry;
import com.sas.services.publish.archive.ArchiveResultPackage;
import com.sas.services.publish.archive.RB;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.sql.ResultSet;

@SASScope
class ArchiveDatasetEntry
extends ArchiveEntry
implements DatasetEntryInterface {
    private String _memberName = null;
    private static final ResultSet DUMMY_RESULTSET = new ServiceResultSet(null);
    private int _nobs = -1;

    private ArchiveDatasetEntry() throws RemoteException {
        super(ArchiveDatasetEntry.class);
    }

    ArchiveDatasetEntry(String memberName) throws RemoteException {
        super(ArchiveDatasetEntry.class);
        this._memberName = memberName;
    }

    @Override
    public String getMemberName() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._memberName;
    }

    void setNobs(int nobs) {
        this._nobs = nobs;
    }

    @Override
    public String getLibraryName() throws TransportException, IllegalStateException {
        this.throwExceptionIfClosed();
        return null;
    }

    @Override
    public int getLibraryMemberType() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return 1;
    }

    @Override
    public ResultSet getResultSet() throws IllegalStateException, TransportException {
        String encoding = null;
        ServiceResultSet resultSet = null;
        this.throwExceptionIfClosed();
        if (this.getVersion() > 34) {
            throw new TransportException(RB.getStringResource("ArchiveCommon.compat.ex.txt"));
        }
        try {
            encoding = ((ArchiveResultPackage)this.getPackage()).getTextEncoding();
            DatasetRetriever retriever = new DatasetRetriever(new DataInputStream(new BufferedInputStream(this.getInputStream())), encoding, this.getVersion(), this._nobs);
            resultSet = this.getVersion() >= 34 ? new AnnotatedServiceResultSet(retriever, this._nobs) : new ServiceResultSet(retriever, this._nobs);
            retriever.initialize();
            retriever.readVariableDefinitions();
            resultSet.setNumColumns(retriever.getColumnCount());
            resultSet.setColumns(retriever.getColumns());
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveDatasetEntry.ioTransportException.ex.txt"));
        }
        catch (TransportException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ArchiveDatasetEntry.ioTransportException.ex.txt"));
        }
        return resultSet;
    }

    @Override
    public RemoteResultSetInterface getRemoteResultSet() throws RemoteException, IllegalStateException, TransportException {
        this.throwExceptionIfClosed();
        if (this.getVersion() > 34) {
            throw new TransportException(RB.getStringResource("ArchiveCommon.compat.ex.txt"));
        }
        return new RemoteResultSet(this.getResultSet());
    }

    @Override
    public Object hasResultSet() throws UnmarshalException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return DUMMY_RESULTSET;
    }
}

