/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.archive;

import com.sas.codepolicy.SASScope;
import com.sas.io.ChainedIOException;
import com.sas.io.RemoteInputStream;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.services.publish.BinaryFileEntryInterface;
import com.sas.services.publish.archive.ArchiveEntry;
import com.sas.services.publish.archive.RB;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;

@SASScope
class ArchiveBinaryFileEntry
extends ArchiveEntry
implements BinaryFileEntryInterface {
    private String _mimeType = null;
    private static final ByteArrayInputStream DUMMY_INPUTSTREAM = new ByteArrayInputStream(new byte[1]);

    ArchiveBinaryFileEntry() throws RemoteException {
        super(ArchiveBinaryFileEntry.class);
    }

    @Override
    public String getMIMEType() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return this._mimeType;
    }

    @Override
    public void setMIMEType(String mimeType) throws IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ArchiveCommon.entryReadOnly.ex.txt"));
        }
        this._mimeType = mimeType;
    }

    @Override
    public RemoteInputStreamInterface getRemoteInputStream(Object streamId) throws IOException, RemoteException, IllegalStateException {
        InputStream stream = null;
        this.throwExceptionIfClosed();
        if (this.getVersion() > 15) {
            throw new ChainedIOException(RB.getStringResource("ArchiveCommon.compat.ex.txt"));
        }
        try {
            stream = this.getZipTable().getInputStream(this.getName());
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("ArchiveCommon.remoteStreamIOError.ex.txt"));
        }
        return new RemoteInputStream(stream);
    }

    @Override
    public Object hasInputStream() throws UnmarshalException, IllegalStateException {
        this.throwExceptionIfClosed();
        return DUMMY_INPUTSTREAM;
    }
}

