/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.alerts;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.DAVRepository;
import com.sas.services.publish.alerts.DAVAlertTransportInterface;
import com.sas.services.publish.alerts.RB;
import com.sas.services.publish.alerts.TemplateInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.util.Names;
import com.sas.services.util.TransformerFactoryFactory;
import com.sas.services.util.XMLUtil;
import com.sas.services.webdav.CollectionInterface;
import com.sas.services.webdav.PropertyMap;
import com.sas.services.webdav.ResourceFactory;
import com.sas.services.webdav.ResourceInterface;
import com.sas.text.Message;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

@SASScope
class DAVAlertTransport
implements DAVAlertTransportInterface {
    private static final String NOTIFICATION_EVENT_NAME = "com.sas.solutions.events.AlertEvent";
    private Logger _saslogger = null;
    private String _userId;
    private String _domain;
    private TemplateInterface _template = null;
    private UserContextInterface _userContext = null;

    DAVAlertTransport(UserContextInterface userContext, String domain, String userId) {
        this._userContext = userContext;
        this._domain = domain;
        this._userId = userId;
    }

    @Override
    public void send(TemplateInterface template) throws TransportException, IllegalArgumentException {
        if (template == null) {
            throw new IllegalArgumentException(RB.getStringResource("Common.nullMsg.ex.txt"));
        }
        this._template = template;
        if (this._userContext == null) {
            throw new TransportException(RB.getStringResource("DAVAlertTransport.noPublisher.ex.txt"));
        }
        this.sendNotification(this._userContext);
    }

    private void sendNotification(UserContextInterface uc) throws TransportException {
        String path = null;
        ResourceInterface resource = null;
        try {
            String targetDesc;
            path = DAVRepository.getUserPRInbox((String)this._userId, (UserContextInterface)uc);
            if (path == null) {
                throw new TransportException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVAlertTransport.inboxErr.ex.fmt.txt", (Object)this._userId));
            }
            String name = Names.generateName((int)0);
            CollectionInterface collection = null;
            HashMap<String, String> props = new HashMap<String, String>(2);
            String targetURL = (String)this._template.getMergeVariables().get("TargetURL");
            if (targetURL != null) {
                props.put("TargetURL", targetURL);
            }
            if ((targetDesc = (String)this._template.getMergeVariables().get("TargetDesc")) != null) {
                props.put("TargetDesc", targetDesc);
            }
            Document doc = this.buildEvent(props);
            if (this._domain != null && this._userContext != null) {
                UserIdentityInterface userIdentity = null;
                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return DAVAlertTransport.this._userContext.getIdentityByDomain(DAVAlertTransport.this._domain);
                    }
                };
                try {
                    userIdentity = (UserIdentityInterface)AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException pae) {
                    Throwable t = pae.getCause();
                    throw new TransportException(t, RB.getStringResource("DAVAlertTransport.davCreds.ex.txt"));
                }
                if (userIdentity != null) {
                    String user = (String)userIdentity.getPrincipal();
                    String pw = (String)userIdentity.getCredential();
                    collection = (CollectionInterface)ResourceFactory.bindResource((String)path, (String)user, (String)pw);
                    resource = collection.createResource(name, user, pw);
                } else {
                    collection = (CollectionInterface)ResourceFactory.bindResource((String)path);
                    resource = collection.createResource(name);
                }
            } else {
                collection = (CollectionInterface)ResourceFactory.bindResource((String)path);
                resource = collection.createResource(name);
            }
            resource.setContents(XMLUtil.convertNodeToString((Node)doc).getBytes());
            PropertyMap propMap = new PropertyMap();
            propMap.put((Object)"{http://www.sas.com/rnd/itech/WebDAV}type", (Object)"event");
            if (props != null) {
                Iterator entryIter = props.entrySet().iterator();
                Map.Entry mapEntry = null;
                while (entryIter.hasNext()) {
                    mapEntry = entryIter.next();
                    propMap.put((Object)("{http://www.sas.com/xml/namespace/services.webdav.eventx-1.1}" + mapEntry.getKey()), mapEntry.getValue());
                }
            }
            resource.setProperties(propMap);
            resource.close();
            resource = null;
            Logger logger = LogManager.getLogger(DAVAlertTransport.class);
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVAlertTransport.successfulPublish.fmt.txt", (Object)this._userId));
            }
        }
        catch (Exception e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVAlertTransport.sendErr.ex.fmt.txt", (Object)this._userId));
        }
        finally {
            if (resource != null) {
                try {
                    resource.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Logger getLogger() {
        return this._saslogger;
    }

    @Override
    public void setLogger(Logger logger) {
        this._saslogger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document buildEvent(Map props) throws TransportException {
        Document document = null;
        try {
            String body = this._template.getResult();
            DocumentBuilderFactory factory = TransformerFactoryFactory.newDocumentBuilderFactory();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = null;
            Element header = null;
            Element e = null;
            Text textNode = null;
            root = document.createElementNS("http://www.sas.com/xml/namespace/services.events-1.1", "sas-event:Event");
            root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sas-event", "http://www.sas.com/xml/namespace/services.events-1.1");
            root.setAttributeNS("http://www.sas.com/xml/namespace/services.events-1.1", "sas-event:name", NOTIFICATION_EVENT_NAME);
            document.appendChild(root);
            header = document.createElementNS("http://www.sas.com/xml/namespace/services.events-1.1", "sas-event:Header");
            root.appendChild(header);
            e = document.createElementNS("http://www.sas.com/xml/namespace/services.events-1.1", "sas-event:Version");
            header.appendChild(e);
            Text t = document.createTextNode("1.0");
            e.appendChild(t);
            String gmt = null;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'");
            TimeZone utc = TimeZone.getTimeZone("UTC");
            formatter.setTimeZone(utc);
            gmt = formatter.format(new Date());
            e = document.createElementNS("http://www.sas.com/xml/namespace/services.events-1.1", "sas-event:SentAt");
            header.appendChild(e);
            textNode = document.createTextNode(gmt);
            e.appendChild(textNode);
            e = document.createElementNS("http://www.sas.com/xml/namespace/services.events-1.1", "sas-event:Response");
            e.setAttributeNS("http://www.sas.com/xml/namespace/services.events-1.1", "sas-event:type", "none");
            header.appendChild(e);
            if (props != null && props.size() > 0) {
                Element pe = document.createElementNS("http://www.sas.com/xml/namespace/services.events-1.1", "sas-event:Properties");
                header.appendChild(pe);
                Iterator itor = props.entrySet().iterator();
                Map.Entry mapEntry = null;
                while (itor.hasNext()) {
                    mapEntry = itor.next();
                    String key = (String)mapEntry.getKey();
                    e = document.createElement(key);
                    textNode = document.createTextNode((String)mapEntry.getValue());
                    pe.appendChild(e);
                    e.appendChild(textNode);
                }
            }
            e = document.createElementNS("http://www.sas.com/xml/namespace/services.events-1.1", "sas-event:Body");
            root.appendChild(e);
            Document bodyNode = null;
            try (StringReader stringReader = null;){
                stringReader = new StringReader(body);
                InputSource is = new InputSource(stringReader);
                bodyNode = builder.parse(is);
            }
            Element templatedBody = bodyNode.getDocumentElement();
            Node nn = document.importNode(templatedBody, true);
            e.appendChild(nn);
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVAlertTransport.eventErr.ex.fmt.txt", (Object)this._userId));
        }
        catch (ServiceException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"DAVAlertTransport.eventErr.ex.fmt.txt", (Object)this._userId));
        }
    }
}

