/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish.alerts;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ParseException;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.publish.alerts.AlertNotification;
import com.sas.services.publish.alerts.AlertTransportFactory;
import com.sas.services.publish.alerts.AlertTransportInterface;
import com.sas.services.publish.alerts.DAVAlertTransportInterface;
import com.sas.services.publish.alerts.DAVTemplate;
import com.sas.services.publish.alerts.MailAlertTransport;
import com.sas.services.publish.alerts.RB;
import com.sas.services.publish.alerts.Template;
import com.sas.services.publish.alerts.TemplateInterface;
import com.sas.services.publish.alerts.URLTemplate;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.svcs.mail.client.MailServiceInterface;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.SimpleTemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class AlertUtil {
    private static final String NS_URI = "http://www.sas.com/xml/namespace/services.events-1.1";
    private static final String UTF8_ENCODING = "UTF-8";

    public static void notify(Document doc, Logger logger) throws ServiceException {
        AlertUtil.sendNotification(doc, null, null);
    }

    public static void notify(Document doc, Logger logger, SessionContextInterface sessionContext) throws ServiceException {
        AlertUtil.sendNotification(doc, sessionContext, null);
    }

    public static void notify(Document doc, Logger logger, SessionContextInterface sessionContext, MailServiceInterface mailService) throws ServiceException, IllegalArgumentException {
        AlertUtil.sendNotification(doc, sessionContext, mailService);
    }

    public static void sendNotification(Document doc, SessionContextInterface sessionContext, MailServiceInterface mailService) throws ServiceException, IllegalArgumentException {
        Node node;
        Element root = null;
        UserContextInterface uc = null;
        if (doc == null) {
            throw new IllegalArgumentException(RB.getStringResource("AlertUtil.nullDoc.ex.txt"));
        }
        if (sessionContext != null) {
            try {
                uc = sessionContext.getUserContext();
            }
            catch (RemoteException e) {
                throw new ServiceException((Throwable)e, RB.getStringResource("AlertUtil.userContextErr.ex.txt"));
            }
        }
        NodeList outerList = null;
        root = doc.getDocumentElement();
        NodeList nodeList = root.getElementsByTagNameNS(NS_URI, "Body");
        if (nodeList.getLength() == 0) {
            if (root.getNodeName().equals("Notification") || root.getNodeName().equals("Notifications")) {
                outerList = doc.getChildNodes();
            }
        } else {
            if (nodeList.getLength() > 1) {
                throw new ParseException(RB.getStringResource("AlertUtil.parseEventMultipleBody.ex.txt"));
            }
            node = nodeList.item(0);
            if (!"Event".equals(node.getParentNode().getLocalName())) {
                throw new ParseException(RB.getStringResource("AlertUtil.parseEventStructure.ex.txt"));
            }
            outerList = node.getChildNodes();
        }
        ArrayList notifications = new ArrayList(1);
        int outerLen = outerList.getLength();
        for (int i = 0; i < outerLen; ++i) {
            node = outerList.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("Notifications")) {
                NodeList innerList = node.getChildNodes();
                int innerLen = innerList.getLength();
                for (int j = 0; j < innerLen; ++j) {
                    node = innerList.item(j);
                    if (node.getNodeType() != 1 || !node.getNodeName().equals("Notification")) continue;
                    AlertUtil.parseNotification(notifications, (Element)node, uc, mailService);
                }
                break;
            }
            if (!node.getNodeName().equals("Notification")) continue;
            AlertUtil.parseNotification(notifications, (Element)node, uc, mailService);
            break;
        }
        AlertUtil.processNotifications(notifications);
    }

    static String resolveTemplate(InputStream is, TemplateInterface template) throws IOException {
        String templateStr = null;
        templateStr = AlertUtil.convertInputStreamToString(is);
        Map mergeVars = template.getMergeVariables();
        if (!mergeVars.isEmpty()) {
            SimpleTemplate simpleTemplate = new SimpleTemplate(templateStr, mergeVars);
            return simpleTemplate.format();
        }
        return templateStr;
    }

    private static void parseNotification(List notifications, Element node, final UserContextInterface uc, MailServiceInterface mailService) throws ServiceException {
        AlertTransportInterface alertTransport = null;
        TemplateInterface template = null;
        String type = node.getAttribute("type");
        if (!(type.equalsIgnoreCase("mail text/plain") || type.equalsIgnoreCase("mail text/html") || type.equalsIgnoreCase("mail digested") || type.equalsIgnoreCase("portlet"))) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"AlertUtil.invalidType.ex.fmt.txt", (Object)type));
        }
        alertTransport = type.equalsIgnoreCase("mail text/plain") || type.equalsIgnoreCase("mail text/html") || type.equalsIgnoreCase("mail digested") ? AlertUtil.setMailNotificationMessage(node, type, uc, mailService) : AlertUtil.setDAVNotificationMessage(node, uc);
        NodeList list = node.getElementsByTagName("Template");
        if (list.getLength() > 0) {
            Element templateNode = (Element)list.item(0);
            String name = templateNode.getAttribute("name");
            list = templateNode.getElementsByTagName("Dir");
            if (list.getLength() > 0) {
                StringBuffer resource;
                Element dirNode = (Element)list.item(0);
                type = dirNode.getAttribute("type");
                String path = dirNode.getAttribute("path");
                final String templateDomain = dirNode.getAttribute("domain");
                if (type.equalsIgnoreCase("dav")) {
                    resource = new StringBuffer(path.length() + 1 + name.length());
                    resource.append(path);
                    if (!path.endsWith("/")) {
                        resource.append("/");
                    }
                    resource.append(name);
                    String user = null;
                    String pw = null;
                    if (templateDomain != null && !templateDomain.equals("")) {
                        UserIdentityInterface uii = null;
                        if (uc != null) {
                            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    return uc.getIdentityByDomain(templateDomain);
                                }
                            };
                            try {
                                uii = (UserIdentityInterface)AccessController.doPrivileged(action);
                            }
                            catch (PrivilegedActionException pae) {
                                Throwable t = pae.getCause();
                                throw new TransportException(t, RB.getStringResource("AlertUtil.davTemplateCreds.ex.txt"));
                            }
                        }
                        if (uii != null) {
                            user = (String)uii.getPrincipal();
                            pw = (String)uii.getCredential();
                        }
                    }
                    template = new DAVTemplate(resource.toString(), user, pw);
                } else if (type.equalsIgnoreCase("file")) {
                    resource = new StringBuffer(path.length() + File.separator.length() + name.length());
                    resource.append(path);
                    if (!path.endsWith(File.separator)) {
                        resource.append(File.separator);
                    }
                    resource.append(name);
                    template = new Template(resource.toString());
                } else if (type.equalsIgnoreCase("url")) {
                    resource = new StringBuffer(path.length() + 1 + name.length());
                    resource.append(path);
                    if (!path.endsWith("/")) {
                        resource.append("/");
                    }
                    resource.append(name);
                    template = new URLTemplate(resource.toString());
                }
            }
            if ((list = templateNode.getElementsByTagName("MergeVariables")).getLength() > 0) {
                Element mergeVarNode = (Element)list.item(0);
                Map mergeVars = template.getMergeVariables();
                list = mergeVarNode.getElementsByTagName("Variable");
                int listLen = list.getLength();
                for (int i = 0; i < listLen; ++i) {
                    Element varNode = (Element)list.item(i);
                    name = varNode.getAttribute("name");
                    String value = "";
                    Node varTextNode = varNode.getFirstChild();
                    if (varTextNode != null) {
                        if (varTextNode.getNodeType() == 3) {
                            value = varTextNode.getNodeValue();
                            try {
                                value = URLDecoder.decode(value, UTF8_ENCODING);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {}
                        } else if (varTextNode.getNodeType() == 4) {
                            value = varTextNode.getNodeValue();
                        }
                    }
                    mergeVars.put(name, value);
                }
            }
        }
        AlertNotification wrap = new AlertNotification(alertTransport, template);
        notifications.add(wrap);
    }

    private static String getTextValue(Node node) {
        String value = "";
        NodeList list = node.getChildNodes();
        int listLen = list.getLength();
        for (int i = 0; i < listLen; ++i) {
            Node childNode = list.item(i);
            if (childNode.getNodeType() != 3) continue;
            value = childNode.getNodeValue();
            break;
        }
        return value;
    }

    private static void processNotifications(List notifications) throws ServiceException {
        for (AlertNotification notification : notifications) {
            AlertUtil.sendAlertNotification(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertInputStreamToString(InputStream inputStream) throws IOException {
        int DEFAULT_BUFFER_LENGTH = 1024;
        String s = null;
        StringBuffer sb = new StringBuffer();
        try (BufferedReader bufferedReader = null;){
            int chrs;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, UTF8_ENCODING));
            char[] chrBuf = new char[DEFAULT_BUFFER_LENGTH];
            while ((chrs = bufferedReader.read(chrBuf, 0, DEFAULT_BUFFER_LENGTH)) > 0) {
                sb.append(chrBuf, 0, chrs);
            }
            s = sb.toString();
            if (s != null && s.trim().length() == 0) {
                s = null;
            }
        }
        return s;
    }

    private static AlertTransportInterface setDAVNotificationMessage(Element node, UserContextInterface uc) throws ServiceException {
        DAVAlertTransportInterface davTransport = null;
        String domain = null;
        String userId = null;
        NodeList list = node.getElementsByTagName("To");
        if (list.getLength() > 0) {
            Element toNode = (Element)list.item(0);
            NodeList toList = toNode.getChildNodes();
            int toListLen = toList.getLength();
            for (int i = 0; i < toListLen; ++i) {
                String childName;
                Node childNode = toList.item(i);
                if (childNode.getNodeType() != 1 || !(childName = childNode.getNodeName()).equals("Userid")) continue;
                userId = AlertUtil.getTextValue(childNode);
                Element attNode = (Element)childNode;
                domain = attNode.getAttribute("domain");
            }
        }
        davTransport = AlertTransportFactory.getDAVAlertTransport(uc, domain, userId);
        return davTransport;
    }

    private static AlertTransportInterface setMailNotificationMessage(Element node, String mailType, final UserContextInterface uc, MailServiceInterface mailService) throws ServiceException {
        String smtpDomain = null;
        String smtpUser = null;
        String smtpPassword = null;
        MailAlertTransport mailTransport = null;
        String contentType = mailType.equalsIgnoreCase("mail text/plain") ? "text/plain;charset=UTF-8" : "text/html;charset=UTF-8";
        mailTransport = mailService == null ? new MailAlertTransport() : new MailAlertTransport(mailService);
        mailTransport.setContentType(contentType);
        NodeList list = node.getElementsByTagName("To");
        if (list.getLength() > 0) {
            Element toNode = (Element)list.item(0);
            NodeList toList = toNode.getChildNodes();
            int toListLen = toList.getLength();
            for (int i = 0; i < toListLen; ++i) {
                NodeList attList;
                String charset2;
                String value;
                Node childNode = toList.item(i);
                if (childNode.getNodeType() != 1) continue;
                String childName = childNode.getNodeName();
                if (childName.equals("EmailAddress")) {
                    value = AlertUtil.getTextValue(childNode);
                    mailTransport.setEmailAddress(value);
                    continue;
                }
                if (childName.equals("Bcc")) {
                    value = AlertUtil.getTextValue(childNode);
                    mailTransport.setBccAddress(value);
                    continue;
                }
                if (childName.equals("SMTPHost")) {
                    value = AlertUtil.getTextValue(childNode);
                    mailTransport.setHost(value);
                    continue;
                }
                if (childName.equals("SMTPUser")) {
                    smtpUser = AlertUtil.getTextValue(childNode);
                    mailTransport.setUser(smtpUser);
                    continue;
                }
                if (childName.equals("SMTPPassword")) {
                    smtpPassword = AlertUtil.getTextValue(childNode);
                    mailTransport.setPassword(smtpPassword);
                    continue;
                }
                if (childName.equals("SMTPDomain")) {
                    smtpDomain = AlertUtil.getTextValue(childNode);
                    continue;
                }
                if (childName.equals("SMTPReplyTo")) {
                    value = AlertUtil.getTextValue(childNode);
                    mailTransport.setReplyTo(value);
                    if (childNode.getNodeType() != 1) continue;
                    charset2 = ((Element)childNode).getAttribute("charset");
                    String personalName = ((Element)childNode).getAttribute("name");
                    if (personalName == null || personalName.equals("")) continue;
                    if (charset2 != null && !charset2.equals("")) {
                        mailTransport.setReplyToName(personalName, charset2);
                        continue;
                    }
                    mailTransport.setReplyToName(personalName, UTF8_ENCODING);
                    continue;
                }
                if (childName.equals("SMTPPort")) {
                    value = AlertUtil.getTextValue(childNode);
                    try {
                        mailTransport.setPort(Integer.parseInt(value));
                    }
                    catch (NumberFormatException charset2) {}
                    continue;
                }
                if (childName.equals("SMTPSubject")) {
                    Node subjectTextNode = childNode.getFirstChild();
                    if (subjectTextNode == null) continue;
                    String charset3 = null;
                    if (subjectTextNode.getNodeType() == 1) {
                        charset3 = ((Element)subjectTextNode).getAttribute("charset");
                    }
                    value = subjectTextNode.getNodeValue();
                    if (charset3 != null && !charset3.equals("")) {
                        mailTransport.setSubject(value, charset3);
                        continue;
                    }
                    mailTransport.setSubject(value, UTF8_ENCODING);
                    continue;
                }
                if (childName.equals("SMTPFrom")) {
                    value = AlertUtil.getTextValue(childNode);
                    mailTransport.setFrom(value);
                    if (childNode.getNodeType() != 1) continue;
                    charset2 = ((Element)childNode).getAttribute("charset");
                    String personalName = ((Element)childNode).getAttribute("name");
                    if (personalName == null || personalName.equals("")) continue;
                    if (charset2 != null && !charset2.equals("")) {
                        mailTransport.setFromName(personalName, charset2);
                        continue;
                    }
                    mailTransport.setFromName(personalName, UTF8_ENCODING);
                    continue;
                }
                if (!childName.equals("Attachments") || childNode.getNodeType() != 1 || (attList = ((Element)childNode).getElementsByTagName("Attachment")).getLength() <= 0) continue;
                int attListLen = attList.getLength();
                for (int a = 0; a < attListLen; ++a) {
                    String name;
                    Node currentNode = attList.item(a);
                    if (currentNode.getNodeType() != 1 || !(name = currentNode.getNodeName()).equals("Attachment")) continue;
                    Element attNode = (Element)currentNode;
                    String type = attNode.getAttribute("type");
                    String ct = attNode.getAttribute("contentType");
                    if (ct.equals("")) {
                        ct = null;
                    }
                    if (type.equalsIgnoreCase("file")) {
                        mailTransport.addAttachment(attNode.getAttribute("path"), attNode.getAttribute("cid"), attNode.getAttribute("name"), ct);
                        continue;
                    }
                    if (type.equalsIgnoreCase("url")) {
                        URL u = null;
                        try {
                            u = new URL(attNode.getAttribute("path"));
                            mailTransport.addAttachment(u, attNode.getAttribute("cid"), attNode.getAttribute("name"), ct);
                            continue;
                        }
                        catch (MalformedURLException e) {
                            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"AlertUtil.urlErr.ex.fmt.txt", (Object)attNode.getAttribute("path")));
                        }
                    }
                    if (!type.equalsIgnoreCase("dav")) continue;
                    final String domain = attNode.getAttribute("domain");
                    String user = null;
                    String pw = null;
                    UserIdentityInterface uii = null;
                    if (domain != null && !domain.equals("")) {
                        if (uc != null) {
                            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    return uc.getIdentityByDomain(domain);
                                }
                            };
                            try {
                                uii = (UserIdentityInterface)AccessController.doPrivileged(action);
                            }
                            catch (PrivilegedActionException pae) {
                                Throwable t = pae.getCause();
                                throw new TransportException(t, RB.getStringResource("AlertUtil.davAttCreds.ex.txt"));
                            }
                        }
                        if (uii != null) {
                            user = (String)uii.getPrincipal();
                            pw = (String)uii.getCredential();
                        }
                    }
                    mailTransport.addAttachment(attNode.getAttribute("path"), user, pw, attNode.getAttribute("cid"), attNode.getAttribute("name"), ct);
                }
            }
        }
        if (smtpDomain != null && smtpUser == null && smtpPassword == null && uc != null) {
            final String sdomain = smtpDomain;
            UserIdentityInterface ui = null;
            if (uc != null) {
                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return uc.getIdentityByDomain(sdomain);
                    }
                };
                try {
                    ui = (UserIdentityInterface)AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException pae) {
                    Throwable t = pae.getCause();
                    throw new TransportException(t, RB.getStringResource("AlertUtil.smtpDomainErr.ex.txt"));
                }
                if (ui != null) {
                    try {
                        mailTransport.setPassword(SasPasswordString.decode((String)((String)ui.getCredential())));
                        mailTransport.setUser((String)ui.getPrincipal());
                    }
                    catch (SasPasswordEncodingException e) {
                        throw new TransportException((Throwable)e, RB.getStringResource("AlertUtil.smtpDomainErr.ex.txt"));
                    }
                }
            }
        }
        return mailTransport;
    }

    private static void sendAlertNotification(AlertNotification notification) throws ServiceException {
        AlertTransportInterface transport = notification.getTransport();
        transport.send(notification.getTemplate());
    }
}

