/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IResultPackage;
import com.sas.iom.SAS.IWorkspace;
import com.sas.services.TransportException;
import com.sas.services.information.metadata.ChannelInterface;
import com.sas.services.information.metadata.ContentDestination;
import com.sas.services.publish.ChannelTransport;
import com.sas.services.publish.ChannelTransportInterface;
import com.sas.services.publish.archive.ArchiveTransport;
import com.sas.services.publish.archive.ArchiveTransportInterface;
import com.sas.services.publish.requester.RequesterTransport;
import com.sas.services.publish.requester.RequesterTransportInterface;
import com.sas.services.publish.webdav.DAVTransport;
import com.sas.services.publish.webdav.DAVTransportInterface;
import com.sas.services.session.SessionContextInterface;
import java.io.File;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class TransportFactory {
    public ArchiveTransportInterface getArchiveTransport(File file, Logger logger, SessionContextInterface sessionContext) throws TransportException {
        ArchiveTransport archive = null;
        archive = new ArchiveTransport(file, logger, sessionContext);
        return archive;
    }

    public ArchiveTransportInterface getArchiveTransport(File file, SessionContextInterface sessionContext) throws TransportException {
        return new ArchiveTransport(file, sessionContext);
    }

    public DAVTransportInterface getDAVTransport(String url, String domain, Logger logger, SessionContextInterface sessionContext) throws TransportException {
        DAVTransport dav = new DAVTransport(url, domain, logger, sessionContext);
        return dav;
    }

    public DAVTransportInterface getDAVTransport(String url, String domain, SessionContextInterface sessionContext) throws TransportException {
        return new DAVTransport(url, domain, sessionContext);
    }

    public DAVTransportInterface getDAVTransport(String url, String username, String password, Logger logger, SessionContextInterface sessionContext) throws TransportException {
        DAVTransport dav = new DAVTransport(url, username, password, logger, sessionContext);
        return dav;
    }

    public DAVTransportInterface getDAVTransportWithCredentials(String url, String username, String password, SessionContextInterface sessionContext) throws TransportException {
        return new DAVTransport(url, username, password, sessionContext);
    }

    public DAVTransportInterface getDAVTransport(ContentDestination content, Logger logger, SessionContextInterface sessionContext) throws TransportException {
        DAVTransport dav = new DAVTransport(content, logger, sessionContext);
        return dav;
    }

    public DAVTransportInterface getDAVTransport(ContentDestination content, SessionContextInterface sessionContext) throws TransportException {
        return new DAVTransport(content, sessionContext);
    }

    public RequesterTransportInterface getRequesterTransport(IResultPackage resultPackage, Logger logger, SessionContextInterface sessionContext) throws TransportException {
        RequesterTransport requester = new RequesterTransport(resultPackage, logger, sessionContext);
        return requester;
    }

    public RequesterTransportInterface getRequesterTransport(IResultPackage resultPackage, SessionContextInterface sessionContext) throws TransportException {
        RequesterTransport requester = new RequesterTransport(resultPackage, sessionContext);
        return requester;
    }

    public RequesterTransportInterface getRequesterTransport(IWorkspace workspace, String transportInformation, String[][] properties, Logger logger, SessionContextInterface sessionContext) throws TransportException {
        RequesterTransport requester = new RequesterTransport(workspace, transportInformation, properties, logger, sessionContext);
        return requester;
    }

    public RequesterTransportInterface getRequesterTransport(IWorkspace workspace, String transportInformation, String[][] properties, SessionContextInterface sessionContext) throws TransportException {
        RequesterTransport requester = new RequesterTransport(workspace, transportInformation, properties, sessionContext);
        return requester;
    }

    public ChannelTransportInterface getChannelTransport(ChannelInterface channel, Logger logger, SessionContextInterface sessionContext) throws TransportException {
        ChannelTransport channelT = new ChannelTransport(channel, logger, sessionContext);
        return channelT;
    }

    public ChannelTransportInterface getChannelTransport(ChannelInterface channel, SessionContextInterface sessionContext) throws TransportException {
        ChannelTransport channelT = new ChannelTransport(channel, sessionContext);
        return channelT;
    }
}

